# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev2
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class BaseTransaction(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """


    class MetaOapg:
        required = {
            "creation_time",
            "amount",
            "posted_amount",
            "type",
            "pending_amount",
            "dc_sign",
            "force_post",
            "last_updated_time",
            "group_id",
            "subtype",
            "effective_date",
            "partial_hold",
            "transaction_time",
            "currency",
            "id",
            "status",
        }
        
        class properties:
            amount = schemas.Int64Schema
            creation_time = schemas.DateTimeSchema
            currency = schemas.StrSchema
            
            
            class dc_sign(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def DEBIT(cls):
                    return cls("DEBIT")
                
                @schemas.classproperty
                def CREDIT(cls):
                    return cls("CREDIT")
            effective_date = schemas.DateSchema
            force_post = schemas.BoolSchema
            group_id = schemas.StrSchema
            id = schemas.UUIDSchema
            last_updated_time = schemas.DateTimeSchema
            partial_hold = schemas.BoolSchema
            pending_amount = schemas.Int64Schema
            posted_amount = schemas.Int64Schema
            
            
            class status(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def PENDING(cls):
                    return cls("PENDING")
                
                @schemas.classproperty
                def DECLINED(cls):
                    return cls("DECLINED")
                
                @schemas.classproperty
                def COMPLETE(cls):
                    return cls("COMPLETE")
            transaction_time = schemas.DateTimeSchema
            
            
            class type(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def ACH(cls):
                    return cls("ACH")
                
                @schemas.classproperty
                def CARD(cls):
                    return cls("CARD")
                
                @schemas.classproperty
                def CHECK(cls):
                    return cls("CHECK")
                
                @schemas.classproperty
                def EXTERNAL_CARD(cls):
                    return cls("EXTERNAL_CARD")
                
                @schemas.classproperty
                def INTERNAL_TRANSFER(cls):
                    return cls("INTERNAL_TRANSFER")
                
                @schemas.classproperty
                def WIRE(cls):
                    return cls("WIRE")
            account_id = schemas.StrSchema
            customer_id = schemas.StrSchema
            
            
            class decline(
                schemas.DictSchema
            ):
            
            
                class MetaOapg:
                    required = {
                        "reason",
                        "decline_details",
                    }
                    
                    class properties:
                        decline_details = schemas.StrSchema
                        
                        
                        class reason(
                            schemas.EnumBase,
                            schemas.StrSchema
                        ):
                            
                            @schemas.classproperty
                            def ACH_RETURN(cls):
                                return cls("ACH_RETURN")
                            
                            @schemas.classproperty
                            def BALANCE_VIOLATION(cls):
                                return cls("BALANCE_VIOLATION")
                            
                            @schemas.classproperty
                            def DISABLED_PAYMENT_TYPE(cls):
                                return cls("DISABLED_PAYMENT_TYPE")
                            
                            @schemas.classproperty
                            def DUPLICATE_TRANSACTION(cls):
                                return cls("DUPLICATE_TRANSACTION")
                            
                            @schemas.classproperty
                            def GATEWAY_DECLINED(cls):
                                return cls("GATEWAY_DECLINED")
                            
                            @schemas.classproperty
                            def GATEWAY_ERROR(cls):
                                return cls("GATEWAY_ERROR")
                            
                            @schemas.classproperty
                            def INSUFFICIENT_FUNDS(cls):
                                return cls("INSUFFICIENT_FUNDS")
                            
                            @schemas.classproperty
                            def NETWORK_DECLINED(cls):
                                return cls("NETWORK_DECLINED")
                            
                            @schemas.classproperty
                            def OTHER(cls):
                                return cls("OTHER")
                            
                            @schemas.classproperty
                            def SUSPECTED_FRAUD(cls):
                                return cls("SUSPECTED_FRAUD")
                            
                            @schemas.classproperty
                            def TRANSACTION_NOT_PERMITTED(cls):
                                return cls("TRANSACTION_NOT_PERMITTED")
                        __annotations__ = {
                            "decline_details": decline_details,
                            "reason": reason,
                        }
                
                reason: MetaOapg.properties.reason
                decline_details: MetaOapg.properties.decline_details
                
                @typing.overload
                def __getitem__(self, name: typing_extensions.Literal["decline_details"]) -> MetaOapg.properties.decline_details: ...
                
                @typing.overload
                def __getitem__(self, name: typing_extensions.Literal["reason"]) -> MetaOapg.properties.reason: ...
                
                @typing.overload
                def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
                
                def __getitem__(self, name: typing.Union[typing_extensions.Literal["decline_details", "reason", ], str]):
                    # dict_instance[name] accessor
                    return super().__getitem__(name)
                
                
                @typing.overload
                def get_item_oapg(self, name: typing_extensions.Literal["decline_details"]) -> MetaOapg.properties.decline_details: ...
                
                @typing.overload
                def get_item_oapg(self, name: typing_extensions.Literal["reason"]) -> MetaOapg.properties.reason: ...
                
                @typing.overload
                def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
                
                def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["decline_details", "reason", ], str]):
                    return super().get_item_oapg(name)
                
            
                def __new__(
                    cls,
                    *_args: typing.Union[dict, frozendict.frozendict, ],
                    reason: typing.Union[MetaOapg.properties.reason, str, ],
                    decline_details: typing.Union[MetaOapg.properties.decline_details, str, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
                ) -> 'decline':
                    return super().__new__(
                        cls,
                        *_args,
                        reason=reason,
                        decline_details=decline_details,
                        _configuration=_configuration,
                        **kwargs,
                    )
            description = schemas.StrSchema
        
            @staticmethod
            def enhanced_transaction() -> typing.Type['EnhancedTransactionData']:
                return EnhancedTransactionData
            hold_expiration_time = schemas.DateTimeSchema
            internal_account_id = schemas.StrSchema
            posted_date = schemas.DateSchema
            reference_id = schemas.StrSchema
            system_description = schemas.StrSchema
            __annotations__ = {
                "amount": amount,
                "creation_time": creation_time,
                "currency": currency,
                "dc_sign": dc_sign,
                "effective_date": effective_date,
                "force_post": force_post,
                "group_id": group_id,
                "id": id,
                "last_updated_time": last_updated_time,
                "partial_hold": partial_hold,
                "pending_amount": pending_amount,
                "posted_amount": posted_amount,
                "status": status,
                "transaction_time": transaction_time,
                "type": type,
                "account_id": account_id,
                "customer_id": customer_id,
                "decline": decline,
                "description": description,
                "enhanced_transaction": enhanced_transaction,
                "hold_expiration_time": hold_expiration_time,
                "internal_account_id": internal_account_id,
                "posted_date": posted_date,
                "reference_id": reference_id,
                "system_description": system_description,
            }
    
    creation_time: MetaOapg.properties.creation_time
    amount: MetaOapg.properties.amount
    posted_amount: MetaOapg.properties.posted_amount
    type: MetaOapg.properties.type
    pending_amount: MetaOapg.properties.pending_amount
    dc_sign: MetaOapg.properties.dc_sign
    force_post: MetaOapg.properties.force_post
    last_updated_time: MetaOapg.properties.last_updated_time
    group_id: MetaOapg.properties.group_id
    subtype: schemas.AnyTypeSchema
    effective_date: MetaOapg.properties.effective_date
    partial_hold: MetaOapg.properties.partial_hold
    transaction_time: MetaOapg.properties.transaction_time
    currency: MetaOapg.properties.currency
    id: MetaOapg.properties.id
    status: MetaOapg.properties.status
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["creation_time"]) -> MetaOapg.properties.creation_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["currency"]) -> MetaOapg.properties.currency: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dc_sign"]) -> MetaOapg.properties.dc_sign: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["effective_date"]) -> MetaOapg.properties.effective_date: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["force_post"]) -> MetaOapg.properties.force_post: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["group_id"]) -> MetaOapg.properties.group_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["last_updated_time"]) -> MetaOapg.properties.last_updated_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["partial_hold"]) -> MetaOapg.properties.partial_hold: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["pending_amount"]) -> MetaOapg.properties.pending_amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["posted_amount"]) -> MetaOapg.properties.posted_amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["transaction_time"]) -> MetaOapg.properties.transaction_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["account_id"]) -> MetaOapg.properties.account_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["customer_id"]) -> MetaOapg.properties.customer_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["decline"]) -> MetaOapg.properties.decline: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["description"]) -> MetaOapg.properties.description: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enhanced_transaction"]) -> 'EnhancedTransactionData': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["hold_expiration_time"]) -> MetaOapg.properties.hold_expiration_time: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["internal_account_id"]) -> MetaOapg.properties.internal_account_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["posted_date"]) -> MetaOapg.properties.posted_date: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["reference_id"]) -> MetaOapg.properties.reference_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["system_description"]) -> MetaOapg.properties.system_description: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["amount", "creation_time", "currency", "dc_sign", "effective_date", "force_post", "group_id", "id", "last_updated_time", "partial_hold", "pending_amount", "posted_amount", "status", "transaction_time", "type", "account_id", "customer_id", "decline", "description", "enhanced_transaction", "hold_expiration_time", "internal_account_id", "posted_date", "reference_id", "system_description", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["creation_time"]) -> MetaOapg.properties.creation_time: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["currency"]) -> MetaOapg.properties.currency: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dc_sign"]) -> MetaOapg.properties.dc_sign: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["effective_date"]) -> MetaOapg.properties.effective_date: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["force_post"]) -> MetaOapg.properties.force_post: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["group_id"]) -> MetaOapg.properties.group_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["last_updated_time"]) -> MetaOapg.properties.last_updated_time: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["partial_hold"]) -> MetaOapg.properties.partial_hold: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["pending_amount"]) -> MetaOapg.properties.pending_amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["posted_amount"]) -> MetaOapg.properties.posted_amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["transaction_time"]) -> MetaOapg.properties.transaction_time: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["account_id"]) -> typing.Union[MetaOapg.properties.account_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["customer_id"]) -> typing.Union[MetaOapg.properties.customer_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["decline"]) -> typing.Union[MetaOapg.properties.decline, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["description"]) -> typing.Union[MetaOapg.properties.description, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enhanced_transaction"]) -> typing.Union['EnhancedTransactionData', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["hold_expiration_time"]) -> typing.Union[MetaOapg.properties.hold_expiration_time, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["internal_account_id"]) -> typing.Union[MetaOapg.properties.internal_account_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["posted_date"]) -> typing.Union[MetaOapg.properties.posted_date, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["reference_id"]) -> typing.Union[MetaOapg.properties.reference_id, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["system_description"]) -> typing.Union[MetaOapg.properties.system_description, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["amount", "creation_time", "currency", "dc_sign", "effective_date", "force_post", "group_id", "id", "last_updated_time", "partial_hold", "pending_amount", "posted_amount", "status", "transaction_time", "type", "account_id", "customer_id", "decline", "description", "enhanced_transaction", "hold_expiration_time", "internal_account_id", "posted_date", "reference_id", "system_description", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        creation_time: typing.Union[MetaOapg.properties.creation_time, str, datetime, ],
        amount: typing.Union[MetaOapg.properties.amount, decimal.Decimal, int, ],
        posted_amount: typing.Union[MetaOapg.properties.posted_amount, decimal.Decimal, int, ],
        type: typing.Union[MetaOapg.properties.type, str, ],
        pending_amount: typing.Union[MetaOapg.properties.pending_amount, decimal.Decimal, int, ],
        dc_sign: typing.Union[MetaOapg.properties.dc_sign, str, ],
        force_post: typing.Union[MetaOapg.properties.force_post, bool, ],
        last_updated_time: typing.Union[MetaOapg.properties.last_updated_time, str, datetime, ],
        group_id: typing.Union[MetaOapg.properties.group_id, str, ],
        subtype: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
        effective_date: typing.Union[MetaOapg.properties.effective_date, str, date, ],
        partial_hold: typing.Union[MetaOapg.properties.partial_hold, bool, ],
        transaction_time: typing.Union[MetaOapg.properties.transaction_time, str, datetime, ],
        currency: typing.Union[MetaOapg.properties.currency, str, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        status: typing.Union[MetaOapg.properties.status, str, ],
        account_id: typing.Union[MetaOapg.properties.account_id, str, schemas.Unset] = schemas.unset,
        customer_id: typing.Union[MetaOapg.properties.customer_id, str, schemas.Unset] = schemas.unset,
        decline: typing.Union[MetaOapg.properties.decline, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        description: typing.Union[MetaOapg.properties.description, str, schemas.Unset] = schemas.unset,
        enhanced_transaction: typing.Union['EnhancedTransactionData', schemas.Unset] = schemas.unset,
        hold_expiration_time: typing.Union[MetaOapg.properties.hold_expiration_time, str, datetime, schemas.Unset] = schemas.unset,
        internal_account_id: typing.Union[MetaOapg.properties.internal_account_id, str, schemas.Unset] = schemas.unset,
        posted_date: typing.Union[MetaOapg.properties.posted_date, str, date, schemas.Unset] = schemas.unset,
        reference_id: typing.Union[MetaOapg.properties.reference_id, str, schemas.Unset] = schemas.unset,
        system_description: typing.Union[MetaOapg.properties.system_description, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'BaseTransaction':
        return super().__new__(
            cls,
            *_args,
            creation_time=creation_time,
            amount=amount,
            posted_amount=posted_amount,
            type=type,
            pending_amount=pending_amount,
            dc_sign=dc_sign,
            force_post=force_post,
            last_updated_time=last_updated_time,
            group_id=group_id,
            subtype=subtype,
            effective_date=effective_date,
            partial_hold=partial_hold,
            transaction_time=transaction_time,
            currency=currency,
            id=id,
            status=status,
            account_id=account_id,
            customer_id=customer_id,
            decline=decline,
            description=description,
            enhanced_transaction=enhanced_transaction,
            hold_expiration_time=hold_expiration_time,
            internal_account_id=internal_account_id,
            posted_date=posted_date,
            reference_id=reference_id,
            system_description=system_description,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.enhanced_transaction_data import EnhancedTransactionData
