"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.error import Error
from synctera_client.model.payment_type import PaymentType
from synctera_client.model.spend_control import SpendControl
from synctera_client.model.spend_control_direction import SpendControlDirection
from synctera_client.model.spend_control_response import SpendControlResponse
from synctera_client.model.spend_control_response_list import SpendControlResponseList
from synctera_client.model.spend_control_update_request import SpendControlUpdateRequest


class SpendControlsBetaApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_spend_control_endpoint = _Endpoint(
            settings={
                'response_type': (SpendControlResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spend_controls',
                'operation_id': 'create_spend_control',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'spend_control',
                ],
                'required': [
                    'spend_control',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'spend_control':
                        (SpendControl,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'spend_control': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_spend_control_endpoint = _Endpoint(
            settings={
                'response_type': (SpendControlResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spend_controls/{spend_control_id}',
                'operation_id': 'get_spend_control',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'spend_control_id',
                ],
                'required': [
                    'spend_control_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'spend_control_id':
                        (str,),
                },
                'attribute_map': {
                    'spend_control_id': 'spend_control_id',
                },
                'location_map': {
                    'spend_control_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_spend_controls_endpoint = _Endpoint(
            settings={
                'response_type': (SpendControlResponseList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spend_controls',
                'operation_id': 'list_spend_controls',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_id',
                    'payment_type',
                    'amount_limit',
                    'amount_limit_gte',
                    'amount_limit_lte',
                    'num_related_accounts',
                    'num_related_accounts_gte',
                    'num_related_accounts_lte',
                    'is_active',
                    'name',
                    'direction',
                    'id',
                    'sort_by',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort_by',
                ],
                'validation': [
                    'amount_limit',
                    'amount_limit_gte',
                    'amount_limit_lte',
                    'num_related_accounts',
                    'num_related_accounts_gte',
                    'num_related_accounts_lte',
                ]
            },
            root_map={
                'validations': {
                    ('amount_limit',): {

                        'exclusive_minimum': 0,
                    },
                    ('amount_limit_gte',): {

                        'exclusive_minimum': 0,
                    },
                    ('amount_limit_lte',): {

                        'exclusive_minimum': 0,
                    },
                    ('num_related_accounts',): {

                        'inclusive_minimum': 0,
                    },
                    ('num_related_accounts_gte',): {

                        'inclusive_minimum': 0,
                    },
                    ('num_related_accounts_lte',): {

                        'inclusive_minimum': 0,
                    },
                },
                'allowed_values': {
                    ('sort_by',): {

                        "NAME:ASC": "name:asc",
                        "NAME:DESC": "name:desc",
                        "NUM_RELATED_ACCOUNTS:ASC": "num_related_accounts:asc",
                        "NUM_RELATED_ACCOUNTS:DESC": "num_related_accounts:desc",
                        "AMOUNT_LIMIT:ASC": "amount_limit:asc",
                        "AMOUNT_LIMIT:DESC": "amount_limit:desc",
                        "LAST_MODIFIED_TIME:ASC": "last_modified_time:asc",
                        "LAST_MODIFIED_TIME:DESC": "last_modified_time:desc",
                        "IS_ACTIVE:ASC": "is_active:asc",
                        "IS_ACTIVE:DESC": "is_active:desc"
                    },
                },
                'openapi_types': {
                    'account_id':
                        (str,),
                    'payment_type':
                        (PaymentType,),
                    'amount_limit':
                        (int,),
                    'amount_limit_gte':
                        (int,),
                    'amount_limit_lte':
                        (int,),
                    'num_related_accounts':
                        (int,),
                    'num_related_accounts_gte':
                        (int,),
                    'num_related_accounts_lte':
                        (int,),
                    'is_active':
                        (bool,),
                    'name':
                        (str,),
                    'direction':
                        (SpendControlDirection,),
                    'id':
                        ([str],),
                    'sort_by':
                        ([str],),
                },
                'attribute_map': {
                    'account_id': 'account_id',
                    'payment_type': 'payment_type',
                    'amount_limit': 'amount_limit',
                    'amount_limit_gte': 'amount_limit_gte',
                    'amount_limit_lte': 'amount_limit_lte',
                    'num_related_accounts': 'num_related_accounts',
                    'num_related_accounts_gte': 'num_related_accounts_gte',
                    'num_related_accounts_lte': 'num_related_accounts_lte',
                    'is_active': 'is_active',
                    'name': 'name',
                    'direction': 'direction',
                    'id': 'id',
                    'sort_by': 'sort_by',
                },
                'location_map': {
                    'account_id': 'query',
                    'payment_type': 'query',
                    'amount_limit': 'query',
                    'amount_limit_gte': 'query',
                    'amount_limit_lte': 'query',
                    'num_related_accounts': 'query',
                    'num_related_accounts_gte': 'query',
                    'num_related_accounts_lte': 'query',
                    'is_active': 'query',
                    'name': 'query',
                    'direction': 'query',
                    'id': 'query',
                    'sort_by': 'query',
                },
                'collection_format_map': {
                    'id': 'csv',
                    'sort_by': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_spend_control_endpoint = _Endpoint(
            settings={
                'response_type': (SpendControlResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/spend_controls/{spend_control_id}',
                'operation_id': 'update_spend_control',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'spend_control_id',
                    'spend_control_update_request',
                ],
                'required': [
                    'spend_control_id',
                    'spend_control_update_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'spend_control_id':
                        (str,),
                    'spend_control_update_request':
                        (SpendControlUpdateRequest,),
                },
                'attribute_map': {
                    'spend_control_id': 'spend_control_id',
                },
                'location_map': {
                    'spend_control_id': 'path',
                    'spend_control_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_spend_control(
        self,
        spend_control,
        **kwargs
    ):
        """Create Spend Control  # noqa: E501

        Create a spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spend_control(spend_control, async_req=True)
        >>> result = thread.get()

        Args:
            spend_control (SpendControl): Details of the spend control to create

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SpendControlResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['spend_control'] = \
            spend_control
        return self.create_spend_control_endpoint.call_with_http_info(**kwargs)

    def get_spend_control(
        self,
        spend_control_id,
        **kwargs
    ):
        """Get Spend Control  # noqa: E501

        Get spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_spend_control(spend_control_id, async_req=True)
        >>> result = thread.get()

        Args:
            spend_control_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SpendControlResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['spend_control_id'] = \
            spend_control_id
        return self.get_spend_control_endpoint.call_with_http_info(**kwargs)

    def list_spend_controls(
        self,
        **kwargs
    ):
        """List Spend Controls  # noqa: E501

        List spend controls   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spend_controls(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            account_id (str): return results matching this account ID. [optional]
            payment_type (PaymentType): [optional]
            amount_limit (int): return results matching this amount limit. [optional]
            amount_limit_gte (int): return results with an amount limit greater than or equal to this. [optional]
            amount_limit_lte (int): return results with an amount limit less than or equal to this. [optional]
            num_related_accounts (int): return results that are associated with this many accounts. [optional]
            num_related_accounts_gte (int): return results that are associated with at least this many accounts. [optional]
            num_related_accounts_lte (int): return results that are associated with at most this many accounts. [optional]
            is_active (bool): return results that match this active status. [optional]
            name (str): return results that match this name. [optional]
            direction (SpendControlDirection): [optional]
            id ([str]): return results with these comma-separated IDs. [optional]
            sort_by ([str]): Specifies the sort order for returned Spend Controls. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SpendControlResponseList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_spend_controls_endpoint.call_with_http_info(**kwargs)

    def update_spend_control(
        self,
        spend_control_id,
        spend_control_update_request,
        **kwargs
    ):
        """Update Spend Control  # noqa: E501

        Update spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_spend_control(spend_control_id, spend_control_update_request, async_req=True)
        >>> result = thread.get()

        Args:
            spend_control_id (str):
            spend_control_update_request (SpendControlUpdateRequest): Fields to update

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SpendControlResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['spend_control_id'] = \
            spend_control_id
        kwargs['spend_control_update_request'] = \
            spend_control_update_request
        return self.update_spend_control_endpoint.call_with_http_info(**kwargs)

