"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.business import Business
from synctera_client.model.business_list import BusinessList
from synctera_client.model.error import Error
from synctera_client.model.patch_business import PatchBusiness


class BusinessesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_business_endpoint = _Endpoint(
            settings={
                'response_type': (Business,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/businesses',
                'operation_id': 'create_business',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'business',
                    'idempotency_key',
                ],
                'required': [
                    'business',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'business':
                        (Business,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'business': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_business_endpoint = _Endpoint(
            settings={
                'response_type': (Business,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/businesses/{business_id}',
                'operation_id': 'get_business',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'business_id',
                ],
                'required': [
                    'business_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'business_id':
                        (str,),
                },
                'attribute_map': {
                    'business_id': 'business_id',
                },
                'location_map': {
                    'business_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_businesses_endpoint = _Endpoint(
            settings={
                'response_type': (BusinessList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/businesses',
                'operation_id': 'list_businesses',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'entity_name',
                    'phone_number',
                    'status',
                    'is_customer',
                    'sort_by',
                    'limit',
                    'page_token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'status',
                    'sort_by',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('status',): {

                        "PROSPECT": "PROSPECT",
                        "ACTIVE": "ACTIVE",
                        "FROZEN": "FROZEN",
                        "SANCTION": "SANCTION",
                        "DISSOLVED": "DISSOLVED",
                        "CANCELLED": "CANCELLED",
                        "SUSPENDED": "SUSPENDED",
                        "MERGED": "MERGED",
                        "INACTIVE": "INACTIVE",
                        "CONVERTED": "CONVERTED"
                    },
                    ('sort_by',): {

                        "ENTITY_NAME:ASC": "entity_name:asc",
                        "ENTITY_NAME:DESC": "entity_name:desc",
                        "CREATION_TIME:ASC": "creation_time:asc",
                        "CREATION_TIME:DESC": "creation_time:desc",
                        "LAST_UPDATED_TIME:ASC": "last_updated_time:asc",
                        "LAST_UPDATED_TIME:DESC": "last_updated_time:desc"
                    },
                },
                'openapi_types': {
                    'id':
                        ([str],),
                    'entity_name':
                        (str,),
                    'phone_number':
                        (str,),
                    'status':
                        (str,),
                    'is_customer':
                        (bool,),
                    'sort_by':
                        ([str],),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'entity_name': 'entity_name',
                    'phone_number': 'phone_number',
                    'status': 'status',
                    'is_customer': 'is_customer',
                    'sort_by': 'sort_by',
                    'limit': 'limit',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'id': 'query',
                    'entity_name': 'query',
                    'phone_number': 'query',
                    'status': 'query',
                    'is_customer': 'query',
                    'sort_by': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                    'id': 'csv',
                    'sort_by': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_business_endpoint = _Endpoint(
            settings={
                'response_type': (Business,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/businesses/{business_id}',
                'operation_id': 'update_business',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'business_id',
                    'patch_business',
                    'idempotency_key',
                ],
                'required': [
                    'business_id',
                    'patch_business',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'business_id':
                        (str,),
                    'patch_business':
                        (PatchBusiness,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'business_id': 'business_id',
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'business_id': 'path',
                    'patch_business': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_business(
        self,
        business,
        **kwargs
    ):
        """Create a business  # noqa: E501

        Create a business who may act as a customer or a related business. You can then verify the identity of this customer and associate them with other people and accounts.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_business(business, async_req=True)
        >>> result = thread.get()

        Args:
            business (Business):

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Business
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['business'] = \
            business
        return self.create_business_endpoint.call_with_http_info(**kwargs)

    def get_business(
        self,
        business_id,
        **kwargs
    ):
        """Get business  # noqa: E501

        Get business by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_business(business_id, async_req=True)
        >>> result = thread.get()

        Args:
            business_id (str): Business's unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Business
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['business_id'] = \
            business_id
        return self.get_business_endpoint.call_with_http_info(**kwargs)

    def list_businesses(
        self,
        **kwargs
    ):
        """List business  # noqa: E501

        Retrieves paginated list of businesses associated with the authorized requester.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_businesses(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            id ([str]): Unique identifier for the business. Multiple IDs can be provided as a comma-separated list. . [optional]
            entity_name (str): [optional]
            phone_number (str): [optional]
            status (str): [optional]
            is_customer (bool): If true, show only customers. If false, show non-customer parties.. [optional]
            sort_by ([str]): Specifies the sort order for the returned businesses. . [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BusinessList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_businesses_endpoint.call_with_http_info(**kwargs)

    def update_business(
        self,
        business_id,
        patch_business,
        **kwargs
    ):
        """Patch business  # noqa: E501

        Update business by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_business(business_id, patch_business, async_req=True)
        >>> result = thread.get()

        Args:
            business_id (str): Business's unique identifier.
            patch_business (PatchBusiness):

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Business
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['business_id'] = \
            business_id
        kwargs['patch_business'] = \
            patch_business
        return self.update_business_endpoint.call_with_http_info(**kwargs)

