"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsTPSTokenBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dynamodb = require("aws-cdk-lib/aws-dynamodb");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_event_sources_1 = require("aws-cdk-lib/aws-lambda-event-sources");
const sqs = require("aws-cdk-lib/aws-sqs");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const tasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
class StepFunctionsTPSTokenBucket extends sfn.StateMachineFragment {
    constructor(parent, id, props) {
        super(parent, id);
        var dynamoDBTableName;
        var dynamoDBTableID;
        var sqsQueue;
        if (!props.tokenBucketDDBTableID || !props.tokenBucketDDBTableName) {
            const dynamoDBTableClass = new dynamodb.Table(this, 'TextractConcurrencyTable', {
                partitionKey: {
                    name: 'tpsTokenBucketDefault',
                    type: dynamodb.AttributeType.NUMBER,
                },
                billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            });
            dynamoDBTableName = dynamoDBTableClass.tableName;
            dynamoDBTableID = 'tpsTokenBucketDefault';
        }
        else {
            dynamoDBTableName = props.tokenBucketDDBTableName;
            dynamoDBTableID = props.tokenBucketDDBTableID;
        }
        if (!props.sqsQueue || !props.sqsQueue) {
            // should avoid using a different SQS queue for the same token bucket
            sqsQueue = new sqs.Queue(this, 'TokenBucketQueue', { visibilityTimeout: aws_cdk_lib_1.Duration.seconds(300) });
        }
        else {
            sqsQueue = props.sqsQueue;
        }
        const tpsTokenBucketFunction = new lambda.DockerImageFunction(this, 'TokenBucketFunction', {
            code: lambda.DockerImageCode.fromImageAsset(path.join(__dirname, '../lambda/tokenbucket/')),
            memorySize: 128,
            timeout: aws_cdk_lib_1.Duration.minutes(5),
            environment: {
                TOKEN_LIMIT: props.tokenLimit.toString(),
                DDB_TOKEN_ID: dynamoDBTableID,
                DDB_TOKEN_TABLE: dynamoDBTableName,
            },
        });
        tpsTokenBucketFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['dynamodb:*'], resources: ['*'] }));
        tpsTokenBucketFunction.addToRolePolicy(new iam.PolicyStatement({ actions: ['states:*'], resources: ['*'] }));
        const tpsTokenBucketFunctionInvoke = new tasks.LambdaInvoke(this, 'TPSTokenBucketFunction', {
            lambdaFunction: tpsTokenBucketFunction,
            outputPath: '$.Payload',
        });
        tpsTokenBucketFunctionInvoke.addRetry({
            interval: aws_cdk_lib_1.Duration.seconds(1),
            maxAttempts: 6,
            backoffRate: 2,
            errors: [sfn.Errors.ALL],
        });
        const sqsTokenBucketTask = new tasks.SqsSendMessage(this, 'SqsTokenBucketTask', {
            queue: sqsQueue,
            messageBody: sfn.TaskInput.fromObject({ field1: 'somedata', TaskToken: sfn.JsonPath.taskToken }),
            integrationPattern: sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
        });
        tpsTokenBucketFunction.addEventSource(new aws_lambda_event_sources_1.SqsEventSource(sqsQueue, { batchSize: 10 }));
        // const workflow_chain = sfn.Chain.start(sqsTokenBucketTask);
        // // detectText.next(releaseLockClass);
        // // textractAsyncLambdaInvoke.next(releaseLockClass);
        // const stateMachine = new sfn.StateMachine(this, 'StateMachine', {
        //   definition: workflow_chain,
        //   timeout: Duration.hours(4),
        // });
        this.endStates = [sqsTokenBucketTask];
        this.startState = sqsTokenBucketTask;
    }
}
exports.StepFunctionsTPSTokenBucket = StepFunctionsTPSTokenBucket;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsTPSTokenBucket[_a] = { fqn: "schadem-cdk-construct-sfn-token-bucket.StepFunctionsTPSTokenBucket", version: "0.0.6" };
//# sourceMappingURL=data:application/json;base64,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