"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicRule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const iot_generated_1 = require("./iot.generated");
/**
 * Defines an AWS IoT Rule in this stack.
 */
class TopicRule extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.topicRuleName,
        });
        this.actions = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_TopicRuleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, TopicRule);
            }
            throw error;
        }
        const sqlConfig = props.sql.bind(this);
        const resource = new iot_generated_1.CfnTopicRule(this, 'Resource', {
            ruleName: this.physicalName,
            topicRulePayload: {
                actions: core_1.Lazy.any({ produce: () => this.actions }),
                awsIotSqlVersion: sqlConfig.awsIotSqlVersion,
                description: props.description,
                errorAction: props.errorAction?.bind(this).configuration,
                ruleDisabled: props.enabled === undefined ? undefined : !props.enabled,
                sql: sqlConfig.sql,
            },
        });
        this.topicRuleArn = this.getResourceArnAttribute(resource.attrArn, {
            service: 'iot',
            resource: 'rule',
            resourceName: this.physicalName,
        });
        this.topicRuleName = this.getResourceNameAttribute(resource.ref);
        props.actions?.forEach(action => {
            this.addAction(action);
        });
    }
    /**
     * Import an existing AWS IoT Rule provided an ARN
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param topicRuleArn AWS IoT Rule ARN (i.e. arn:aws:iot:<region>:<account-id>:rule/MyRule).
     */
    static fromTopicRuleArn(scope, id, topicRuleArn) {
        const parts = core_1.Stack.of(scope).splitArn(topicRuleArn, core_1.ArnFormat.SLASH_RESOURCE_NAME);
        if (!parts.resourceName) {
            throw new Error(`Missing topic rule name in ARN: '${topicRuleArn}'`);
        }
        const resourceName = parts.resourceName;
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.topicRuleArn = topicRuleArn;
                this.topicRuleName = resourceName;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: topicRuleArn,
        });
    }
    /**
     * Add a action to the topic rule.
     *
     * @param action the action to associate with the topic rule.
     */
    addAction(action) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_IAction(action);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addAction);
            }
            throw error;
        }
        const { configuration } = action.bind(this);
        const keys = Object.keys(configuration);
        if (keys.length === 0) {
            throw new Error('An action property cannot be an empty object.');
        }
        if (keys.length > 1) {
            throw new Error(`An action property cannot have multiple keys, received: ${keys}`);
        }
        this.actions.push(configuration);
    }
}
exports.TopicRule = TopicRule;
_a = JSII_RTTI_SYMBOL_1;
TopicRule[_a] = { fqn: "@aws-cdk/aws-iot.TopicRule", version: "1.168.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9waWMtcnVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRvcGljLXJ1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsd0NBQTRFO0FBSTVFLG1EQUErQztBQW9FL0M7O0dBRUc7QUFDSCxNQUFhLFNBQVUsU0FBUSxlQUFRO0lBc0NyQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXFCO1FBQzdELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxhQUFhO1NBQ2xDLENBQUMsQ0FBQztRQUxZLFlBQU8sR0FBa0MsRUFBRSxDQUFDOzs7Ozs7K0NBcENsRCxTQUFTOzs7O1FBMkNsQixNQUFNLFNBQVMsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUV2QyxNQUFNLFFBQVEsR0FBRyxJQUFJLDRCQUFZLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNsRCxRQUFRLEVBQUUsSUFBSSxDQUFDLFlBQVk7WUFDM0IsZ0JBQWdCLEVBQUU7Z0JBQ2hCLE9BQU8sRUFBRSxXQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsT0FBTyxFQUFFLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQkFDbEQsZ0JBQWdCLEVBQUUsU0FBUyxDQUFDLGdCQUFnQjtnQkFDNUMsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO2dCQUM5QixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsYUFBYTtnQkFDeEQsWUFBWSxFQUFFLEtBQUssQ0FBQyxPQUFPLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLE9BQU87Z0JBQ3RFLEdBQUcsRUFBRSxTQUFTLENBQUMsR0FBRzthQUNuQjtTQUNGLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLHVCQUF1QixDQUFDLFFBQVEsQ0FBQyxPQUFPLEVBQUU7WUFDakUsT0FBTyxFQUFFLEtBQUs7WUFDZCxRQUFRLEVBQUUsTUFBTTtZQUNoQixZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7U0FDaEMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxJQUFJLENBQUMsd0JBQXdCLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBRWpFLEtBQUssQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLE1BQU0sQ0FBQyxFQUFFO1lBQzlCLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDekIsQ0FBQyxDQUFDLENBQUM7S0FDSjtJQWxFRDs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsZ0JBQWdCLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsWUFBb0I7UUFDL0UsTUFBTSxLQUFLLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxRQUFRLENBQUMsWUFBWSxFQUFFLGdCQUFTLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRTtZQUN2QixNQUFNLElBQUksS0FBSyxDQUFDLG9DQUFvQyxZQUFZLEdBQUcsQ0FBQyxDQUFDO1NBQ3RFO1FBQ0QsTUFBTSxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztRQUV4QyxNQUFNLE1BQU8sU0FBUSxlQUFRO1lBQTdCOztnQkFDa0IsaUJBQVksR0FBRyxZQUFZLENBQUM7Z0JBQzVCLGtCQUFhLEdBQUcsWUFBWSxDQUFDO1lBQy9DLENBQUM7U0FBQTtRQUNELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUMzQixrQkFBa0IsRUFBRSxZQUFZO1NBQ2pDLENBQUMsQ0FBQztLQUNKO0lBK0NEOzs7O09BSUc7SUFDSSxTQUFTLENBQUMsTUFBZTs7Ozs7Ozs7OztRQUM5QixNQUFNLEVBQUUsYUFBYSxFQUFFLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUU1QyxNQUFNLElBQUksR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3hDLElBQUksSUFBSSxDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUU7WUFDckIsTUFBTSxJQUFJLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO1NBQ2xFO1FBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtZQUNuQixNQUFNLElBQUksS0FBSyxDQUFDLDJEQUEyRCxJQUFJLEVBQUUsQ0FBQyxDQUFDO1NBQ3BGO1FBRUQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDbEM7O0FBdEZILDhCQXVGQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFybkZvcm1hdCwgUmVzb3VyY2UsIFN0YWNrLCBJUmVzb3VyY2UsIExhenkgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUFjdGlvbiB9IGZyb20gJy4vYWN0aW9uJztcbmltcG9ydCB7IElvdFNxbCB9IGZyb20gJy4vaW90LXNxbCc7XG5pbXBvcnQgeyBDZm5Ub3BpY1J1bGUgfSBmcm9tICcuL2lvdC5nZW5lcmF0ZWQnO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gQVdTIElvVCBSdWxlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSVRvcGljUnVsZSBleHRlbmRzIElSZXNvdXJjZSB7XG4gIC8qKlxuICAgKiBUaGUgdmFsdWUgb2YgdGhlIHRvcGljIHJ1bGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTiksIHN1Y2ggYXNcbiAgICogYXJuOmF3czppb3Q6dXMtZWFzdC0yOjEyMzQ1Njc4OTAxMjpydWxlL3J1bGVfbmFtZVxuICAgKlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSB0b3BpY1J1bGVBcm46IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG5hbWUgdG9waWMgcnVsZVxuICAgKlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSB0b3BpY1J1bGVOYW1lOiBzdHJpbmc7XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYW4gQVdTIElvVCBSdWxlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVG9waWNSdWxlUHJvcHMge1xuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIHRvcGljIHJ1bGUuXG4gICAqIEBkZWZhdWx0IE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHRvcGljUnVsZU5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBhY3Rpb25zIGFzc29jaWF0ZWQgd2l0aCB0aGUgdG9waWMgcnVsZS5cbiAgICpcbiAgICogQGRlZmF1bHQgTm8gYWN0aW9ucyB3aWxsIGJlIHBlcmZvcm1cbiAgICovXG4gIHJlYWRvbmx5IGFjdGlvbnM/OiBJQWN0aW9uW107XG5cbiAgLyoqXG4gICAqIEEgdGV4dHVhbCBkZXNjcmlwdGlvbiBvZiB0aGUgdG9waWMgcnVsZS5cbiAgICpcbiAgICogQGRlZmF1bHQgTm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgZGVzY3JpcHRpb24/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBhY3Rpb24gQVdTIElvVCBwZXJmb3JtcyB3aGVuIGl0IGlzIHVuYWJsZSB0byBwZXJmb3JtIGEgcnVsZSdzIGFjdGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBhY3Rpb24gd2lsbCBiZSBwZXJmb3JtZWRcbiAgICovXG4gIHJlYWRvbmx5IGVycm9yQWN0aW9uPzogSUFjdGlvbjtcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHdoZXRoZXIgdGhlIHJ1bGUgaXMgZW5hYmxlZC5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW5cblxuICAvKipcbiAgICogQSBzaW1wbGlmaWVkIFNRTCBzeW50YXggdG8gZmlsdGVyIG1lc3NhZ2VzIHJlY2VpdmVkIG9uIGFuIE1RVFQgdG9waWMgYW5kIHB1c2ggdGhlIGRhdGEgZWxzZXdoZXJlLlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2lvdC1zcWwtcmVmZXJlbmNlLmh0bWxcbiAgICovXG4gIHJlYWRvbmx5IHNxbDogSW90U3FsO1xufVxuXG4vKipcbiAqIERlZmluZXMgYW4gQVdTIElvVCBSdWxlIGluIHRoaXMgc3RhY2suXG4gKi9cbmV4cG9ydCBjbGFzcyBUb3BpY1J1bGUgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElUb3BpY1J1bGUge1xuICAvKipcbiAgICogSW1wb3J0IGFuIGV4aXN0aW5nIEFXUyBJb1QgUnVsZSBwcm92aWRlZCBhbiBBUk5cbiAgICpcbiAgICogQHBhcmFtIHNjb3BlIFRoZSBwYXJlbnQgY3JlYXRpbmcgY29uc3RydWN0ICh1c3VhbGx5IGB0aGlzYCkuXG4gICAqIEBwYXJhbSBpZCBUaGUgY29uc3RydWN0J3MgbmFtZS5cbiAgICogQHBhcmFtIHRvcGljUnVsZUFybiBBV1MgSW9UIFJ1bGUgQVJOIChpLmUuIGFybjphd3M6aW90OjxyZWdpb24+OjxhY2NvdW50LWlkPjpydWxlL015UnVsZSkuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21Ub3BpY1J1bGVBcm4oc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgdG9waWNSdWxlQXJuOiBzdHJpbmcpOiBJVG9waWNSdWxlIHtcbiAgICBjb25zdCBwYXJ0cyA9IFN0YWNrLm9mKHNjb3BlKS5zcGxpdEFybih0b3BpY1J1bGVBcm4sIEFybkZvcm1hdC5TTEFTSF9SRVNPVVJDRV9OQU1FKTtcbiAgICBpZiAoIXBhcnRzLnJlc291cmNlTmFtZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBNaXNzaW5nIHRvcGljIHJ1bGUgbmFtZSBpbiBBUk46ICcke3RvcGljUnVsZUFybn0nYCk7XG4gICAgfVxuICAgIGNvbnN0IHJlc291cmNlTmFtZSA9IHBhcnRzLnJlc291cmNlTmFtZTtcblxuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSVRvcGljUnVsZSB7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgdG9waWNSdWxlQXJuID0gdG9waWNSdWxlQXJuO1xuICAgICAgcHVibGljIHJlYWRvbmx5IHRvcGljUnVsZU5hbWUgPSByZXNvdXJjZU5hbWU7XG4gICAgfVxuICAgIHJldHVybiBuZXcgSW1wb3J0KHNjb3BlLCBpZCwge1xuICAgICAgZW52aXJvbm1lbnRGcm9tQXJuOiB0b3BpY1J1bGVBcm4sXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogQXJuIG9mIHRoaXMgdG9waWMgcnVsZVxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdG9waWNSdWxlQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIE5hbWUgb2YgdGhpcyB0b3BpYyBydWxlXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB0b3BpY1J1bGVOYW1lOiBzdHJpbmc7XG5cbiAgcHJpdmF0ZSByZWFkb25seSBhY3Rpb25zOiBDZm5Ub3BpY1J1bGUuQWN0aW9uUHJvcGVydHlbXSA9IFtdO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUb3BpY1J1bGVQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgcGh5c2ljYWxOYW1lOiBwcm9wcy50b3BpY1J1bGVOYW1lLFxuICAgIH0pO1xuXG4gICAgY29uc3Qgc3FsQ29uZmlnID0gcHJvcHMuc3FsLmJpbmQodGhpcyk7XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IG5ldyBDZm5Ub3BpY1J1bGUodGhpcywgJ1Jlc291cmNlJywge1xuICAgICAgcnVsZU5hbWU6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgICAgdG9waWNSdWxlUGF5bG9hZDoge1xuICAgICAgICBhY3Rpb25zOiBMYXp5LmFueSh7IHByb2R1Y2U6ICgpID0+IHRoaXMuYWN0aW9ucyB9KSxcbiAgICAgICAgYXdzSW90U3FsVmVyc2lvbjogc3FsQ29uZmlnLmF3c0lvdFNxbFZlcnNpb24sXG4gICAgICAgIGRlc2NyaXB0aW9uOiBwcm9wcy5kZXNjcmlwdGlvbixcbiAgICAgICAgZXJyb3JBY3Rpb246IHByb3BzLmVycm9yQWN0aW9uPy5iaW5kKHRoaXMpLmNvbmZpZ3VyYXRpb24sXG4gICAgICAgIHJ1bGVEaXNhYmxlZDogcHJvcHMuZW5hYmxlZCA9PT0gdW5kZWZpbmVkID8gdW5kZWZpbmVkIDogIXByb3BzLmVuYWJsZWQsXG4gICAgICAgIHNxbDogc3FsQ29uZmlnLnNxbCxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLnRvcGljUnVsZUFybiA9IHRoaXMuZ2V0UmVzb3VyY2VBcm5BdHRyaWJ1dGUocmVzb3VyY2UuYXR0ckFybiwge1xuICAgICAgc2VydmljZTogJ2lvdCcsXG4gICAgICByZXNvdXJjZTogJ3J1bGUnLFxuICAgICAgcmVzb3VyY2VOYW1lOiB0aGlzLnBoeXNpY2FsTmFtZSxcbiAgICB9KTtcbiAgICB0aGlzLnRvcGljUnVsZU5hbWUgPSB0aGlzLmdldFJlc291cmNlTmFtZUF0dHJpYnV0ZShyZXNvdXJjZS5yZWYpO1xuXG4gICAgcHJvcHMuYWN0aW9ucz8uZm9yRWFjaChhY3Rpb24gPT4ge1xuICAgICAgdGhpcy5hZGRBY3Rpb24oYWN0aW9uKTtcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGQgYSBhY3Rpb24gdG8gdGhlIHRvcGljIHJ1bGUuXG4gICAqXG4gICAqIEBwYXJhbSBhY3Rpb24gdGhlIGFjdGlvbiB0byBhc3NvY2lhdGUgd2l0aCB0aGUgdG9waWMgcnVsZS5cbiAgICovXG4gIHB1YmxpYyBhZGRBY3Rpb24oYWN0aW9uOiBJQWN0aW9uKTogdm9pZCB7XG4gICAgY29uc3QgeyBjb25maWd1cmF0aW9uIH0gPSBhY3Rpb24uYmluZCh0aGlzKTtcblxuICAgIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhjb25maWd1cmF0aW9uKTtcbiAgICBpZiAoa2V5cy5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQW4gYWN0aW9uIHByb3BlcnR5IGNhbm5vdCBiZSBhbiBlbXB0eSBvYmplY3QuJyk7XG4gICAgfVxuICAgIGlmIChrZXlzLmxlbmd0aCA+IDEpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQW4gYWN0aW9uIHByb3BlcnR5IGNhbm5vdCBoYXZlIG11bHRpcGxlIGtleXMsIHJlY2VpdmVkOiAke2tleXN9YCk7XG4gICAgfVxuXG4gICAgdGhpcy5hY3Rpb25zLnB1c2goY29uZmlndXJhdGlvbik7XG4gIH1cbn1cbiJdfQ==