# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['found']

package_data = \
{'': ['*']}

install_requires = \
['aiostream>=0.4.3,<0.5.0',
 'cffi>=1.14.5,<2.0.0',
 'foundationdb>=6.3.16,<7.0.0',
 'immutables>=0.15,<0.16',
 'more-itertools>=8.8.0,<9.0.0',
 'zstandard>=0.15.2,<0.16.0']

setup_kwargs = {
    'name': 'asyncio-foundationdb',
    'version': '0.10.3',
    'description': 'asyncio drivers for FoundationDB',
    'long_description': "# [asyncio-foundationdb](https://github.com/amirouche/asyncio-foundationdb/)\n\n*early draft*\n\nasyncio drivers for foundationdb tested with CPython 3.9 and PyPy 3.7\n\n[![Library Database](https://images.unsplash.com/photo-1544383835-bda2bc66a55d?ixlib=rb-1.2.1&ixid=MnwxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8&auto=format&fit=crop&w=1021&q=80)](https://unsplash.com/photos/lRoX0shwjUQ)\n\n## Table of Content\n\n<!-- markdown-toc start - Don't edit this section. Run M-x markdown-toc-refresh-toc -->\n- [Getting started](#getting-started)\n- [ChangeLog](#changelog)\n    - [v0.10.x](#v010x)\n- [`import found`](#import-found)\n- [`from found import bstore`](#from-found-import-bstore)\n- [`from found import nstore`](#from-found-import-nstore)\n- [`from found import eavstore`](#from-found-import-eavstore)\n- [`from found import pstore`](#from-found-import-pstore)\n<!-- markdown-toc end -->\n\n## Getting started\n\n```\npip install asyncio-foundationdb\n```\n\n```python\nimport found\n\n\nasync def get(tx, key):\n    out = await found.get(tx, key)\n\nasync def set(tx, key, value):\n    return found.set(tx, key, value)\n\n\ndb = await found.open()\nout = await found.transactional(db, get, b'hello')\nassert out is None\n\nawait found.transactional(db, set, b'hello', b'world')\nout = await found.transactional(db, get, b'hello')\nassert out == b'world'\n```\n\n## ChangeLog\n\n### v0.10.x\n\n- Almost full rewrite\n- Remove hooks for the time being\n- Port Generic Tuple Store aka. `nstore`\n- Add blob store aka. `bstore`\n- Add Entity-Attribute-Value store aka. `eavstore`\n- Add inverted index store aka. `pstore`\n\n## `import found`\n\n### `found.BaseFoundException`\n\nAll `found` exceptions inherit that class.\n\n### `found.FoundException`\n\nException raised when there is an error foundationdb client driver, or\nfoundationdb server side.\n\n### async `found.open(cluster_file=None)`\n\nOpen database.\n\nCoroutine that will open a connection with the cluster specified in\nthe file `cluster_file`. If `cluster_file` is not provided the default\nis `/etc/foundationdb/fdb.cluster`. Returns a database object.\n\n### async `found.transactional(db, func, *args, snapshot=False, **kwargs)`\n\nOperate a transaction for `func`.\n\nCoroutine that will operate a transaction against `db` for `func`. If\n`snapshot=True` then the transaction is read-only. `func` will receive\nan appropriate transaction object as first argument, then `args`, then\n`kwargs`. Because of errors `transactional` might run `func` several\ntimes, hence `func` should be idempotent.\n\n### async `found.get(tx, key)`\n\nGet the value associated with `key`.\n\nCoroutine that will fetch the value associated with `key` inside the\ndatabase associated with `tx`. `key` must be `bytes`. In case of\nsuccess, returns `bytes`. Otherwise, if there is no value associated\nwith `key`, returns the object `None`.\n\n### `found.set(tx, key, value)`\n\nSet `key` to `value`.\n\nIn the database associated with `tx`, associate `key` with\n`value`. Both `key` and `value` must be `bytes`.\n\n### `found.pack(tuple)`\n\nSerialize python objects `tuple` into bytes.\n\n### `found.pack_with_versionstamp(tuple)`\n\nSerialize python objects `tuple` into bytes. `tuple` may contain\n`found.Versionstamp` objects.\n\n### `found.unpack(bytes)`\n\nDeserialize bytes into python objects.\n\n### `found.Versionstamp(...)`\n\nFIXME.\n\n### `found.clear(tx, key, other=None)`\n\nRemove key or keys.\n\nIn the database associated with `tx`, clear the specified `key` or\nrange of keys.\n\n`key` and `other` if provided must be `bytes`.\n\nIf `other=None`, then clear the association that might exists with\n`key`. Otherwise, if `other` is provided, `found.clear` will remove\nany association between `key` and `other` but not the association with\n`other` if any (that is `other` is excluded from the range).\n\n### async `found.query(tx, key, other, *, limit=0, mode=STREAMING_MODE_ITERATOR)`\n\nFetch key-value pairs.\n\nIn the database associated with `tx`, generate at most `limit`\nkey-value pairs inside the specified range, with the specified order.\n\nIf `key < other` then `found.query` generates key-value pairs in\nlexicographic order. Otherwise, if `key > other` then `found.query`\ngenerates key-value pairs in reverse lexicographic order, that is\nstarting at `other` until `key`.\n\nIf `limit=0`, then `found.query` generates all key-value pairs in the\nspecified bounds. Otherwise if `limit > 0` then, it generates at most\n`limit` pairs.\n\nThe keyword `mode` can be one the following constant:\n\n- `found.STREAMING_MODE_WANT_ALL`\n- `found.STREAMING_MODE_ITERATOR`\n- `found.STREAMING_MODE_EXACT`\n- `found.STREAMING_MODE_SMALL`\n- `found.STREAMING_MODE_MEDIUM`\n- `found.STREAMING_MODE_LARGE`\n- `found.STREAMING_MODE_SERIAL`\n\n### `found.next_prefix(key)`\n\nReturns the immediatly next byte sequence that is not prefix of `key`.\n\n### `found.lt(key, offset=0)`\n\n### `found.lte(key, offset=0)`\n\n### `found.gt(key, offset=0)`\n\n### `found.gte(key, offset=0)`\n\n### async `found.read_version(tx)`\n\n### `found.set_read_version(tx, version)`\n\n### `found.add(tx, key, param)`\n\n### `found.bit_and(tx, key, param)`\n\n### `found.bit_or(tx, key, param)`\n\n### `found.bit_xor(tx, key, param)`\n\n### `found.max(tx, key, param)`\n\n### `found.byte_max(tx, key, param)`\n\n### `found.min(tx, key, param)`\n\n### `found.byte_min(tx, key, param)`\n\n### `found.set_versionstamped_key(tx, key, param)`\n\n### `found.set_versionstamped_value(tx, key, param)`\n\n## `from found import bstore`\n\n### `bstore.BStoreException`\n\nException specific to `bstore`.\n\n### `bstore.make(name, prefix)`\n\nHandle over a `bstore` called `name` with `prefix`.\n\n### async `bstore.get_or_create(tx, bstore, blob)`\n\n### `bstore.get(tx, bstore, uid)`\n\n## `from found import nstore`\n\n### `nstore.NStoreException`\n\nException specific to `nstore`.\n\n### `nstore.make(name, prefix, n)`\n\nCreate a handle over a `nstore` called `name` with `prefix` and `n`\ncolumns.\n\nThe argument `name` should be a string, it is really meant to ease\ndebugging. `prefix` should be a tuple that can be packed with\n`found.pack`. Last but not least, `n` is the number of columns in the\nreturned tuple store (or, if you prefer, the number of tuple items).\n\nIt is preferable to store the returned value.\n\n### `nstore.add(tx, nstore, *items, *, value=b'')`\n\nIn the database associated with `tx`, as part of `nstore`, add\n`items` associated with `value`.\n\n### `nstore.remove(tx, nstore, *items)`\n\nIn the database associated with `tx`, as part of `nstore`, remove\n`items` and the associated value.\n\n### async `nstore.get(tx, nstore, *items)`\n\nIn the database associated with `tx`, as part of `nstore`, get the\nvalue associated with `items`. If there is no such items in `nstore`,\nreturns `None`.\n\n### `nstore.var(name)`\n\nCreate a variable called `name` for use with `nstore.query`.\n\n### async `nstore.query(tx, nstore, pattern, *patterns)`\n\nIn the database associated with `tx`, as part of `nstore`, generate\nmappings that match `pattern` and `patterns`. Both `pattern` and\n`patterns` may contain `nstore.var` that will be replaced with\nmatching values in the generic tuple store.\n\n## `from found import eavstore`\n\n### `eavstore.make(name, prefix)`\n\nCreate a handle over an eavstore called `name` with `prefix`.\n\nThe argument `name` should be a string, it is really meant to ease\ndebugging. `prefix` should be a tuple that can be packed with\n`found.pack`.\n\n### `eavstore.create(tx, eavstore, dict)`\n\nStore a dictionary.\n\nIn the database associated with `tx`, as part of `eavstore`, save\n`dict` and returns its unique identifier.\n\n### async `eavstore.get(tx, eavstore, uid)`\n\nFetch a dictionary.\n\nIn the database associated with `tx`, as part of `eavstore`, retrieve\nthe dictionary associated with `uid`. If there is no such dictionary,\nreturns an empty dictionary.\n\n### `eavstore.remove(tx, eavstore, uid)`\n\nClear a dictionary.\n\nIn the database associated with `tx`, as part of `eavstore`, remove\nthe dictionary associated with `uid`.\n\n### `eavstore.update(tx, eavstore, uid, dict)`\n\nUpdate a dictionary.\n\nIn the database associated with `tx`, as part of `eavstore`, replace\nthe dictionary associated with `uid` with `dict`.\n\n### async `eavstore.query(tx, eavstore, key, value)`\n\nLookup dictionaries according to sppecification.\n\nIn the database associated with `tx`, as part of `eavstore`, generates\nunique identifier for dictionaries that have `key` equal to `value`.\n\n## `from found import pstore`\n\n### `pstore.PStoreException`\n\nException specific to `pstore`.\n\n### `pstore.make(name, prefix, pool)`\n\nA handle over a `pstore` called `name` with `prefix`, that will use\n`pool`.\n\n### async `pstore.index(tx, store, docuid, counter)`\n\nAssociates `docuid` with `counter`.\n\nCoroutine that associates the identifier `docuid` with the dict-like\n`counter` inside the database associated with `tx` at `store` for\nlater retriaval with `pstore.search`.\n\n`counter` must be a dict-like mapping string to integers bigger than\nzero.\n\n### async `pstore.search(tx, store, keywords, limit)`\n\nReturn a sorted list of at most `limit` documents matching `keywords`.\n",
    'author': 'Amirouche',
    'author_email': 'amirouche@hyper.dev',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}
from build import *
build(setup_kwargs)

setup(**setup_kwargs)
