"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerV2Origin = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const http_origin_1 = require("./http-origin");
/**
 * An Origin for a v2 load balancer.
 */
class LoadBalancerV2Origin extends http_origin_1.HttpOrigin {
    constructor(loadBalancer, props = {}) {
        super(loadBalancer.loadBalancerDnsName, { ...props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_LoadBalancerV2OriginProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.LoadBalancerV2Origin = LoadBalancerV2Origin;
_a = JSII_RTTI_SYMBOL_1;
LoadBalancerV2Origin[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.LoadBalancerV2Origin", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9hZC1iYWxhbmNlci1vcmlnaW4uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2FkLWJhbGFuY2VyLW9yaWdpbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQSwrQ0FBNEQ7QUFPNUQ7O0dBRUc7QUFDSCxNQUFhLG9CQUFxQixTQUFRLHdCQUFVO0lBRWxELFlBQVksWUFBbUMsRUFBRSxRQUFtQyxFQUFFO1FBQ3BGLEtBQUssQ0FBQyxZQUFZLENBQUMsbUJBQW1CLEVBQUUsRUFBRSxHQUFHLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7Ozs7S0FDdkQ7O0FBSkgsb0RBTUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlbGJ2MiBmcm9tICdAYXdzLWNkay9hd3MtZWxhc3RpY2xvYWRiYWxhbmNpbmd2Mic7XG5pbXBvcnQgeyBIdHRwT3JpZ2luLCBIdHRwT3JpZ2luUHJvcHMgfSBmcm9tICcuL2h0dHAtb3JpZ2luJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBhbiBPcmlnaW4gYmFja2VkIGJ5IGEgdjIgbG9hZCBiYWxhbmNlci5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMb2FkQmFsYW5jZXJWMk9yaWdpblByb3BzIGV4dGVuZHMgSHR0cE9yaWdpblByb3BzIHsgfVxuXG4vKipcbiAqIEFuIE9yaWdpbiBmb3IgYSB2MiBsb2FkIGJhbGFuY2VyLlxuICovXG5leHBvcnQgY2xhc3MgTG9hZEJhbGFuY2VyVjJPcmlnaW4gZXh0ZW5kcyBIdHRwT3JpZ2luIHtcblxuICBjb25zdHJ1Y3Rvcihsb2FkQmFsYW5jZXI6IGVsYnYyLklMb2FkQmFsYW5jZXJWMiwgcHJvcHM6IExvYWRCYWxhbmNlclYyT3JpZ2luUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKGxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJEbnNOYW1lLCB7IC4uLnByb3BzIH0pO1xuICB9XG5cbn1cbiJdfQ==