/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import ai.h2o.org.eclipse.jetty.websocket.api.Session;
import ai.h2o.org.eclipse.jetty.websocket.api.WebSocketListener;
import ai.h2o.org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import ai.h2o.org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import ai.h2o.org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import ai.h2o.org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import ai.h2o.org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import java.io.IOException;
import water.webserver.iface.H2OWebsocketServlet;
import water.webserver.iface.WebsocketConnection;
import water.webserver.iface.WebsocketHandler;

public class Jetty9WebsocketServlet
extends WebSocketServlet {
    private final H2OWebsocketServlet impl;

    public Jetty9WebsocketServlet(H2OWebsocketServlet impl) {
        this.impl = impl;
    }

    @Override
    public void configure(WebSocketServletFactory factory) {
        factory.setCreator(new H2OWebSocketCreator());
    }

    public class H2OWebSocketCreator
    implements WebSocketCreator {
        @Override
        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            return new Jetty9WebsocketHandler();
        }
    }

    class Jetty9WebsocketHandler
    implements WebSocketListener {
        private WebsocketHandler handler;
        private Jetty9WebsocketConnection conn;

        Jetty9WebsocketHandler() {
        }

        @Override
        public void onWebSocketConnect(Session sess) {
            this.conn = new Jetty9WebsocketConnection(sess);
            this.handler = Jetty9WebsocketServlet.this.impl.onConnect(this.conn);
        }

        @Override
        public void onWebSocketBinary(byte[] payload, int offset, int len) {
        }

        @Override
        public void onWebSocketText(String message) {
            this.handler.onMessage(message);
        }

        @Override
        public void onWebSocketClose(int statusCode, String reason) {
            this.handler.onClose(this.conn);
            this.conn = null;
            this.handler = null;
        }

        @Override
        public void onWebSocketError(Throwable cause) {
            cause.printStackTrace();
        }
    }

    static class Jetty9WebsocketConnection
    implements WebsocketConnection {
        private final Session sess;

        Jetty9WebsocketConnection(Session sess) {
            this.sess = sess;
        }

        @Override
        public void sendMessage(String message) throws IOException {
            this.sess.getRemote().sendString(message);
        }
    }
}

