/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;
import water.AutoBuffer;
import water.Iced;
import water.IcedWrapper;
import water.util.StringUtils;

public class TwoDimTable
extends Iced {
    private String tableHeader;
    private String tableDescription;
    private String[] rowHeaders;
    private String[] colHeaders;
    private String[] colTypes;
    private String[] colFormats;
    private IcedWrapper[][] cellValues;
    private String colHeaderForRowHeaders;
    public static final double emptyDouble = 9.9E-324;
    private static int PRINTOUT_ROW_LIMIT = 20;

    public static boolean isEmpty(double d2) {
        return Double.doubleToRawLongBits(d2) == Double.doubleToRawLongBits(9.9E-324);
    }

    public TwoDimTable(String tableHeader, String tableDescription, String[] rowHeaders, String[] colHeaders, String[] colTypes, String[] colFormats, String colHeaderForRowHeaders) {
        if (tableHeader == null) {
            tableHeader = "";
        }
        if (tableDescription == null) {
            tableDescription = "";
        }
        this.colHeaderForRowHeaders = colHeaderForRowHeaders;
        if (rowHeaders == null) {
            throw new IllegalArgumentException("rowHeaders is null");
        }
        for (int r2 = 0; r2 < rowHeaders.length; ++r2) {
            if (rowHeaders[r2] != null) continue;
            rowHeaders[r2] = "";
        }
        if (colHeaders == null) {
            throw new IllegalArgumentException("colHeaders is null");
        }
        for (int c2 = 0; c2 < colHeaders.length; ++c2) {
            if (colHeaders[c2] != null) continue;
            colHeaders[c2] = "";
        }
        int rowDim = rowHeaders.length;
        int colDim = colHeaders.length;
        if (colTypes == null) {
            colTypes = new String[colDim];
            Arrays.fill(colTypes, "string");
        } else {
            if (colTypes.length != colDim) {
                throw new IllegalArgumentException("colTypes must have the same length as colHeaders");
            }
            for (int c3 = 0; c3 < colDim; ++c3) {
                colTypes[c3] = colTypes[c3].toLowerCase();
                if (colTypes[c3].equals("double") || colTypes[c3].equals("float") || colTypes[c3].equals("int") || colTypes[c3].equals("long") || colTypes[c3].equals("string")) continue;
                throw new IllegalArgumentException(String.format("colTypes values must be one of \"double\", \"float\", \"int\", \"long\", or \"string\". Received \"%s\" as ColType %d", colTypes[c3], c3));
            }
        }
        if (colFormats == null) {
            colFormats = new String[colDim];
            Arrays.fill(colFormats, "%s");
        } else if (colFormats.length != colDim) {
            throw new IllegalArgumentException("colFormats must have the same length as colHeaders");
        }
        this.tableHeader = tableHeader;
        this.tableDescription = tableDescription;
        this.rowHeaders = rowHeaders;
        this.colHeaders = colHeaders;
        this.colTypes = colTypes;
        this.colFormats = colFormats;
        this.cellValues = new IcedWrapper[rowDim][colDim];
    }

    public TwoDimTable(String tableHeader, String tableDescription, String[] rowHeaders, String[] colHeaders, String[] colTypes, String[] colFormats, String colHeaderForRowHeaders, String[][] strCellValues, double[][] dblCellValues) {
        this(tableHeader, tableDescription, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders);
        int c2;
        assert (TwoDimTable.isEmpty(9.9E-324));
        assert (!Arrays.equals(new AutoBuffer().put8d(9.9E-324).buf(), new AutoBuffer().put8d(Double.NaN).buf()));
        int rowDim = rowHeaders.length;
        int colDim = colHeaders.length;
        for (c2 = 0; c2 < colDim; ++c2) {
            if (!colTypes[c2].equalsIgnoreCase("string")) continue;
            for (Object vec : strCellValues) {
                if (vec == null) {
                    throw new IllegalArgumentException("Null string in strCellValues");
                }
                if (((String[])vec).length == colDim) continue;
                throw new IllegalArgumentException("Each row in strCellValues must have the same length as colHeaders");
            }
            break;
        }
        for (c2 = 0; c2 < colDim; ++c2) {
            if (colTypes[c2].equalsIgnoreCase("string")) continue;
            for (Object vec : (String)dblCellValues) {
                if (((String[])vec).length == colDim) continue;
                throw new IllegalArgumentException("Each row in dblCellValues must have the same length as colHeaders");
            }
            break;
        }
        for (int r2 = 0; r2 < rowDim; ++r2) {
            for (int c3 = 0; c3 < colDim; ++c3) {
                if (strCellValues[r2] == null || strCellValues[r2][c3] == null || dblCellValues[r2] == null || TwoDimTable.isEmpty(dblCellValues[r2][c3])) continue;
                throw new IllegalArgumentException("Cannot provide both a String and a Double at row " + r2 + " and column " + c3 + ".");
            }
        }
        block18: for (c2 = 0; c2 < colDim; ++c2) {
            switch (colTypes[c2]) {
                case "double": 
                case "float": {
                    int r3;
                    for (r3 = 0; r3 < rowDim; ++r3) {
                        this.set(r3, c2, dblCellValues[r3][c2]);
                    }
                    continue block18;
                }
                case "int": 
                case "long": {
                    int r3;
                    for (r3 = 0; r3 < rowDim; ++r3) {
                        double val = dblCellValues[r3][c2];
                        if (TwoDimTable.isEmpty(val)) {
                            this.set(r3, c2, Double.NaN);
                            continue;
                        }
                        if ((double)((long)val) == val) {
                            this.set(r3, c2, (long)val);
                            continue;
                        }
                        this.set(r3, c2, val);
                    }
                    continue block18;
                }
                case "string": {
                    int r3;
                    for (r3 = 0; r3 < rowDim; ++r3) {
                        this.set(r3, c2, strCellValues[r3][c2]);
                    }
                    continue block18;
                }
                default: {
                    throw new IllegalArgumentException("Column type " + colTypes[c2] + " is not supported.");
                }
            }
        }
    }

    public Object get(int row, int col) {
        return this.cellValues[row][col] == null ? null : this.cellValues[row][col].get();
    }

    public String getTableHeader() {
        return this.tableHeader;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public String[] getRowHeaders() {
        return this.rowHeaders;
    }

    public String[] getColHeaders() {
        return this.colHeaders;
    }

    public String getColHeaderForRowHeaders() {
        return this.colHeaderForRowHeaders;
    }

    public String[] getColTypes() {
        return this.colTypes;
    }

    public String[] getColFormats() {
        return this.colFormats;
    }

    public IcedWrapper[][] getCellValues() {
        return this.cellValues;
    }

    public int getRowDim() {
        return this.rowHeaders.length;
    }

    public int getColDim() {
        return this.colHeaders.length;
    }

    public void setTableHeader(String newHeader) {
        if (!StringUtils.isNullOrEmpty(newHeader)) {
            this.tableHeader = newHeader;
        }
    }

    public void set(int row, int col, Object o2) {
        this.cellValues[row][col] = o2 == null ? new IcedWrapper(null) : (o2 instanceof Double && Double.isNaN((Double)o2) ? new IcedWrapper(Double.NaN) : (o2 instanceof int[] ? new IcedWrapper(Arrays.toString((int[])o2)) : (o2 instanceof long[] ? new IcedWrapper(Arrays.toString((long[])o2)) : (o2 instanceof float[] ? new IcedWrapper(Arrays.toString((float[])o2)) : (o2 instanceof double[] ? new IcedWrapper(Arrays.toString((double[])o2)) : (this.colTypes[col] == "string" ? new IcedWrapper(o2.toString()) : new IcedWrapper(o2)))))));
    }

    public String toString() {
        return this.toString(2, true);
    }

    public String toString(int pad) {
        return this.toString(pad, true);
    }

    private boolean skip(int row) {
        assert (PRINTOUT_ROW_LIMIT % 2 == 0);
        if (this.getRowDim() <= PRINTOUT_ROW_LIMIT) {
            return false;
        }
        if (row <= PRINTOUT_ROW_LIMIT / 2) {
            return false;
        }
        return row < this.getRowDim() - PRINTOUT_ROW_LIMIT / 2;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int pad, boolean full) {
        void var10_18;
        String[][] cellStrings;
        if (pad < 0) {
            throw new IllegalArgumentException("pad must be a non-negative integer");
        }
        int rowDim = this.getRowDim();
        int colDim = this.getColDim();
        int actualRowDim = full ? rowDim : Math.min(PRINTOUT_ROW_LIMIT + 1, rowDim);
        for (Object[] objectArray : cellStrings = new String[actualRowDim + 1][colDim + 1]) {
            Arrays.fill(objectArray, "");
        }
        cellStrings[0][0] = this.colHeaderForRowHeaders != null ? this.colHeaderForRowHeaders : "";
        int row = 0;
        for (int r2 = 0; r2 < rowDim; ++r2) {
            if (!full && this.skip(r2)) continue;
            cellStrings[row + 1][0] = this.rowHeaders[r2];
            ++row;
        }
        for (int c2 = 0; c2 < colDim; ++c2) {
            cellStrings[0][c2 + 1] = this.colHeaders[c2];
        }
        for (int c2 = 0; c2 < colDim; ++c2) {
            String formatString = this.colFormats[c2];
            row = 0;
            for (int i2 = 0; i2 < rowDim; ++i2) {
                if (!full && this.skip(i2)) continue;
                Object o2 = this.get(i2, c2);
                if (o2 == null || o2 instanceof Double && TwoDimTable.isEmpty((Double)o2)) {
                    cellStrings[row + 1][c2 + 1] = "";
                    ++row;
                    continue;
                }
                if (o2 instanceof Double && Double.isNaN((Double)o2)) {
                    cellStrings[row + 1][c2 + 1] = "NaN";
                    ++row;
                    continue;
                }
                try {
                    cellStrings[row + 1][c2 + 1] = o2 instanceof Double ? String.format(formatString, (Double)o2) : (o2 instanceof Float ? String.format(formatString, (Float)o2) : (o2 instanceof Integer ? String.format(formatString, (Integer)o2) : (o2 instanceof Long ? String.format(formatString, (Long)o2) : (o2 instanceof String ? (String)o2 : String.format(formatString, this.cellValues[i2][c2])))));
                }
                catch (Throwable t2) {
                    cellStrings[row + 1][c2 + 1] = o2.toString();
                }
                ++row;
            }
        }
        int[] colLen = new int[colDim + 1];
        for (int c3 = 0; c3 <= colDim; ++c3) {
            for (int i3 = 0; i3 <= actualRowDim; ++i3) {
                colLen[c3] = Math.max(colLen[c3], cellStrings[i3][c3].length());
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.tableHeader.length() > 0) {
            sb.append(this.tableHeader);
        }
        if (this.tableDescription.length() > 0) {
            sb.append(" (").append(this.tableDescription).append(")");
        }
        sb.append(":\n");
        boolean bl = false;
        while (var10_18 <= actualRowDim) {
            int len = colLen[0];
            if (actualRowDim != rowDim && var10_18 - true == PRINTOUT_ROW_LIMIT / 2) {
                assert (!full);
                sb.append("---");
            } else {
                if (len > 0) {
                    sb.append(String.format("%" + colLen[0] + "s", cellStrings[var10_18][0]));
                }
                for (int c4 = 1; c4 <= colDim; ++c4) {
                    len = colLen[c4];
                    if (len <= 0) continue;
                    sb.append(String.format("%" + (len + pad) + "s", cellStrings[var10_18][c4].equals("null") ? "" : cellStrings[var10_18][c4]));
                }
            }
            sb.append("\n");
            ++var10_18;
        }
        return sb.toString();
    }
}

