/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import water.H2O;
import water.exceptions.JCodeSB;
import water.util.IcedBitSet;
import water.util.SB;

public class SBPrintStream
extends PrintStream
implements JCodeSB<SBPrintStream> {
    private final boolean _outputDoubles = H2O.getSysBoolProperty("java.output.doubles", false);
    private int _indent = 0;

    public SBPrintStream(OutputStream out) {
        super(out);
    }

    public SBPrintStream(OutputStream out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public SBPrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush, encoding);
    }

    @Override
    public SBPrintStream ps(String s2) {
        this.append("\"");
        this.pj(s2);
        this.append("\"");
        return this;
    }

    @Override
    public SBPrintStream p(JCodeSB s2) {
        return this.p(s2.getContent());
    }

    @Override
    public SBPrintStream p(String s2) {
        this.append(s2);
        return this;
    }

    private SBPrintStream p(float s2) {
        if (Float.isNaN(s2)) {
            this.append("Float.NaN");
        } else if (Float.isInfinite(s2)) {
            this.append(s2 > 0.0f ? "Float.POSITIVE_INFINITY" : "Float.NEGATIVE_INFINITY");
        } else {
            this.append(s2);
        }
        return this;
    }

    @Override
    public SBPrintStream p(double s2) {
        if (Double.isNaN(s2)) {
            this.append("Double.NaN");
        } else if (Double.isInfinite(s2)) {
            this.append(s2 > 0.0 ? "Double.POSITIVE_INFINITY" : "Double.NEGATIVE_INFINITY");
        } else {
            this.append(s2);
        }
        return this;
    }

    @Override
    public SBPrintStream p(char s2) {
        this.append(s2);
        return this;
    }

    @Override
    public SBPrintStream p(int s2) {
        this.append(s2);
        return this;
    }

    @Override
    public SBPrintStream p(long s2) {
        this.append(s2);
        return this;
    }

    @Override
    public SBPrintStream p(boolean s2) {
        this.append(Boolean.toString(s2));
        return this;
    }

    @Override
    public SBPrintStream pobj(Object s2) {
        this.append(s2.toString());
        return this;
    }

    @Override
    public SBPrintStream i(int d2) {
        for (int i2 = 0; i2 < d2 + this._indent; ++i2) {
            this.p("  ");
        }
        return this;
    }

    @Override
    public SBPrintStream i() {
        return this.i(0);
    }

    @Override
    public SBPrintStream ip(String s2) {
        return this.i().p(s2);
    }

    @Override
    public SBPrintStream s() {
        this.append(' ');
        return this;
    }

    @Override
    public SBPrintStream pj(double s2) {
        if (Double.isInfinite(s2)) {
            this.append("Double.").append(s2 > 0.0 ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Double.isNaN(s2)) {
            this.append("Double.NaN");
        } else {
            this.append(s2);
        }
        return this;
    }

    @Override
    public SBPrintStream pj(float s2) {
        if (this._outputDoubles) {
            return this.pj((double)s2);
        }
        if (Float.isInfinite(s2)) {
            this.append("Float.").append(s2 > 0.0f ? "POSITIVE_INFINITY" : "NEGATIVE_INFINITY");
        } else if (Float.isNaN(s2)) {
            this.append("Float.NaN");
        } else {
            this.append(s2).append('f');
        }
        return this;
    }

    @Override
    public SBPrintStream pj(String s2) {
        this.append(SB.escapeJava(s2));
        return this;
    }

    @Override
    public SBPrintStream pj(String objectName, String fieldName) {
        this.append(objectName).append('.').append(fieldName);
        return this;
    }

    @Override
    public SBPrintStream p(IcedBitSet ibs) {
        SB sb = new SB();
        sb = ibs.toString(sb);
        return this.append(sb);
    }

    public SBPrintStream p(SB sb) {
        return this.append(sb);
    }

    @Override
    public SBPrintStream ii(int i2) {
        this._indent += i2;
        return this;
    }

    @Override
    public SBPrintStream di(int i2) {
        this._indent -= i2;
        return this;
    }

    @Override
    public SBPrintStream ci(JCodeSB sb) {
        this._indent = sb.getIndent();
        return this;
    }

    @Override
    public SBPrintStream nl() {
        return this.p('\n');
    }

    @Override
    public SBPrintStream toJavaStringInit(String[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.p('\"').pj(ss[i2]).p("\",");
        }
        if (ss.length > 0) {
            this.p('\"').pj(ss[ss.length - 1]).p('\"');
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(float[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.pj(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(double[] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.pj(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.pj(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(double[][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.toJavaStringInit(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJavaStringInit(double[][][] ss) {
        if (ss == null) {
            return this.p("null");
        }
        this.p('{');
        for (int i2 = 0; i2 < ss.length - 1; ++i2) {
            this.toJavaStringInit(ss[i2]).p(',');
        }
        if (ss.length > 0) {
            this.toJavaStringInit(ss[ss.length - 1]);
        }
        return this.p('}');
    }

    @Override
    public SBPrintStream toJSArray(float[] nums) {
        this.p('[');
        for (int i2 = 0; i2 < nums.length; ++i2) {
            if (i2 > 0) {
                this.p(',');
            }
            this.p(nums[i2]);
        }
        return this.p(']');
    }

    @Override
    public SBPrintStream toJSArray(String[] ss) {
        this.p('[');
        for (int i2 = 0; i2 < ss.length; ++i2) {
            if (i2 > 0) {
                this.p(',');
            }
            this.p('\"').p(ss[i2]).p('\"');
        }
        return this.p(']');
    }

    @Override
    public int getIndent() {
        return this._indent;
    }

    @Override
    public String getContent() {
        throw new UnsupportedOperationException("Cannot get content of stream!");
    }

    public SBPrintStream append(float f2) {
        this.append(Float.toString(f2));
        return this;
    }

    public SBPrintStream append(double d2) {
        this.append(Double.toString(d2));
        return this;
    }

    public SBPrintStream append(int i2) {
        this.append(Integer.toString(i2));
        return this;
    }

    public SBPrintStream append(long l2) {
        this.append(Long.toString(l2));
        return this;
    }

    public SBPrintStream append(SB sb) {
        this.append(sb.toString());
        return this;
    }
}

