/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.ByteArrayOutputStream;
import water.util.ConcatenatedLogArchiveWriter;
import water.util.LogArchiveWriter;
import water.util.ZipLogArchiveWriter;

public enum LogArchiveContainer {
    ZIP("application/octet-stream"){

        @Override
        public LogArchiveWriter createLogArchiveWriter(ByteArrayOutputStream baos) {
            return new ZipLogArchiveWriter(baos);
        }
    }
    ,
    LOG("text/plain"){

        @Override
        public LogArchiveWriter createLogArchiveWriter(ByteArrayOutputStream baos) {
            return new ConcatenatedLogArchiveWriter(baos);
        }
    };

    private final String _mime_type;

    private LogArchiveContainer(String mimeType) {
        this._mime_type = mimeType;
    }

    public abstract LogArchiveWriter createLogArchiveWriter(ByteArrayOutputStream var1);

    public String getFileExtension() {
        return this.name().toLowerCase();
    }

    public String getMimeType() {
        return this._mime_type;
    }
}

