/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxProcFileReader {
    private String _systemData;
    private String _processData;
    private String _processStatus;
    private String _pid;
    private long _systemIdleTicks = -1L;
    private long _systemTotalTicks = -1L;
    private long _processTotalTicks = -1L;
    private long _processRss = -1L;
    private int _processCpusAllowed = -1;
    private int _processNumOpenFds = -1;
    private ArrayList<long[]> _cpuTicks = null;

    public boolean isWsl() {
        try {
            if (!new File("/proc/version").exists()) {
                return false;
            }
            String s2 = this.readFile(new File("/proc/version"));
            return s2.contains("Microsoft");
        }
        catch (Exception e2) {
            return false;
        }
    }

    public long getSystemIdleTicks() {
        assert (this._systemIdleTicks > 0L);
        return this._systemIdleTicks;
    }

    public long getSystemTotalTicks() {
        assert (this._systemTotalTicks > 0L);
        return this._systemTotalTicks;
    }

    public long getProcessTotalTicks() {
        assert (this._processTotalTicks > 0L);
        return this._processTotalTicks;
    }

    public long[][] getCpuTicks() {
        assert (this._cpuTicks != null);
        return (long[][])this._cpuTicks.toArray((T[])new long[0][0]);
    }

    public long getProcessRss() {
        assert (this._processRss > 0L);
        return this._processRss;
    }

    private static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    private static boolean getOSMatchesName(String osNamePrefix) {
        String osName = System.getProperty("os.name");
        return LinuxProcFileReader.isOSNameMatch(osName, osNamePrefix);
    }

    private static boolean IS_OS_LINUX() {
        return LinuxProcFileReader.getOSMatchesName("Linux") || LinuxProcFileReader.getOSMatchesName("LINUX");
    }

    public int getProcessCpusAllowed() {
        return this.getProcessCpusAllowed(LinuxProcFileReader.IS_OS_LINUX());
    }

    int getProcessCpusAllowed(boolean isLinux) {
        if (!isLinux) {
            return this.getProcessCpusAllowedFallback();
        }
        if (this._processCpusAllowed < 0) {
            return this.getProcessCpusAllowedFallback();
        }
        return this._processCpusAllowed;
    }

    int getProcessCpusAllowedFallback() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getProcessNumOpenFds() {
        assert (this._processNumOpenFds > 0);
        return this._processNumOpenFds;
    }

    public String getProcessID() {
        return this._pid;
    }

    public void read() {
        String pid = "-1";
        try {
            this._pid = pid = LinuxProcFileReader.getProcessId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File f2 = new File("/proc/stat");
        if (!f2.exists()) {
            return;
        }
        try {
            this.readSystemProcFile();
            this.readProcessProcFile(pid);
            this.readProcessNumOpenFds(pid);
            this.readProcessStatusFile(pid);
            this.parseSystemProcFile(this._systemData);
            this.parseProcessProcFile(this._processData);
            this.parseProcessStatusFile(this._processStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean valid() {
        return this._systemIdleTicks >= 0L && this._systemTotalTicks >= 0L && this._processTotalTicks >= 0L && this._processNumOpenFds >= 0;
    }

    public static int numSetBitsHex(String s2) {
        int[] bits_set = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
        int nset = 0;
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            Character ch = Character.valueOf(s2.charAt(i2));
            if (ch.charValue() == ',') continue;
            int x2 = Integer.parseInt(ch.toString(), 16);
            nset += bits_set[x2];
        }
        return nset;
    }

    private static String getProcessId() throws Exception {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            throw new Exception("Can't get process Id");
        }
        return Long.toString(Long.parseLong(jvmName.substring(0, index)));
    }

    private String readFile(File f2) throws Exception {
        int n2;
        char[] buffer = new char[16384];
        FileReader fr = new FileReader(f2);
        int bytesRead = 0;
        do {
            if ((n2 = fr.read(buffer, bytesRead, buffer.length - bytesRead)) < 0) {
                fr.close();
                return new String(buffer, 0, bytesRead);
            }
            if (n2 != 0) continue;
            fr.close();
            throw new Exception("LinuxProcFileReader readFile read 0 bytes");
        } while ((bytesRead += n2) < buffer.length);
        fr.close();
        throw new Exception("LinuxProcFileReader readFile unexpected buffer full");
    }

    private void readSystemProcFile() {
        try {
            this._systemData = this.readFile(new File("/proc/stat"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void parseSystemProcFile(String s2) {
        if (s2 == null) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(s2));
            String line = reader.readLine();
            Pattern p2 = Pattern.compile("cpu\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*");
            Matcher m4 = p2.matcher(line);
            boolean b2 = m4.matches();
            if (!b2) {
                return;
            }
            long systemUserTicks = Long.parseLong(m4.group(1));
            long systemNiceTicks = Long.parseLong(m4.group(2));
            long systemSystemTicks = Long.parseLong(m4.group(3));
            this._systemIdleTicks = Long.parseLong(m4.group(4));
            this._systemTotalTicks = systemUserTicks + systemNiceTicks + systemSystemTicks + this._systemIdleTicks;
            this._cpuTicks = new ArrayList();
            line = reader.readLine();
            while (line != null && (b2 = (m4 = (p2 = Pattern.compile("cpu(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*")).matcher(line)).matches())) {
                long cpuUserTicks = 0L;
                long cpuSystemTicks = 0L;
                long cpuOtherTicks = 0L;
                long cpuIdleTicks = 0L;
                cpuOtherTicks += Long.parseLong(m4.group(3));
                cpuSystemTicks += Long.parseLong(m4.group(4));
                cpuSystemTicks += Long.parseLong(m4.group(7));
                long[] oneCpuTicks = new long[]{cpuUserTicks += Long.parseLong(m4.group(2)), cpuSystemTicks += Long.parseLong(m4.group(8)), cpuOtherTicks += Long.parseLong(m4.group(6)), cpuIdleTicks += Long.parseLong(m4.group(5))};
                this._cpuTicks.add(oneCpuTicks);
                line = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessProcFile(String pid) {
        try {
            String s2 = "/proc/" + pid + "/stat";
            this._processData = this.readFile(new File(s2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void parseProcessProcFile(String s2) {
        if (s2 == null) {
            return;
        }
        try {
            BufferedReader reader = new BufferedReader(new StringReader(s2));
            String line = reader.readLine();
            Pattern p2 = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+(\\S+).*");
            Matcher m4 = p2.matcher(line);
            boolean b2 = m4.matches();
            if (!b2) {
                return;
            }
            long processUserTicks = Long.parseLong(m4.group(14));
            long processSystemTicks = Long.parseLong(m4.group(15));
            this._processTotalTicks = processUserTicks + processSystemTicks;
            this._processRss = Long.parseLong(m4.group(24));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessNumOpenFds(String pid) {
        try {
            String s2 = "/proc/" + pid + "/fd";
            File f2 = new File(s2);
            String[] arr = f2.list();
            if (arr != null) {
                this._processNumOpenFds = arr.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readProcessStatusFile(String pid) {
        try {
            String s2 = "/proc/" + pid + "/status";
            this._processStatus = this.readFile(new File(s2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void parseProcessStatusFile(String s2) {
        if (s2 == null) {
            return;
        }
        try {
            Pattern p2 = Pattern.compile("Cpus_allowed:\\s+([A-Fa-f0-9,]+)");
            Matcher m4 = p2.matcher(s2);
            boolean b2 = m4.find();
            if (!b2) {
                return;
            }
            this._processCpusAllowed = LinuxProcFileReader.numSetBitsHex(m4.group(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

