/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.IOException;
import java.io.OutputStream;

public class LineLimitOutputStreamWrapper
extends OutputStream {
    private final OutputStream os;
    private final int lineLimit;
    private int linesCnt = 0;

    public LineLimitOutputStreamWrapper(OutputStream os2, int lineLimit) {
        this.os = os2;
        this.lineLimit = lineLimit;
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.linesCnt < this.lineLimit) {
            this.os.write(b2);
            if (b2 == 10) {
                ++this.linesCnt;
            }
        }
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.linesCnt < this.lineLimit) {
            for (int i2 = 0; i2 < len; ++i2) {
                if (b2[off + i2] == 10) {
                    ++this.linesCnt;
                }
                if (this.linesCnt != this.lineLimit) continue;
                len = off + i2;
                break;
            }
            this.os.write(b2, off, len);
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.os.write(b2);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

