/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.util.ArrayList;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.persist.PersistNFS;
import water.util.ArrayUtils;

public class FileIntegrityChecker
extends MRTask<FileIntegrityChecker> {
    final String[] _files;
    final long[] _sizes;
    int[] _ok;

    @Override
    public void setupLocal() {
        this._ok = new int[this._files.length];
        for (int i2 = 0; i2 < this._files.length; ++i2) {
            File f2 = new File(this._files[i2]);
            if (!f2.exists() || f2.length() != this._sizes[i2]) continue;
            this._ok[i2] = 1;
        }
    }

    @Override
    public void reduce(FileIntegrityChecker o2) {
        ArrayUtils.add(this._ok, o2._ok);
    }

    private void addFolder(File path, ArrayList<File> filesInProgress) {
        if (!path.canRead()) {
            return;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File f2 : files) {
                if (!f2.canRead() || f2.length() == 0L || f2.isHidden() && !path.isHidden()) continue;
                if (f2.isDirectory()) {
                    this.addFolder(f2, filesInProgress);
                    continue;
                }
                filesInProgress.add(f2);
            }
        } else if (path.length() > 0L) {
            filesInProgress.add(path);
        }
    }

    public static FileIntegrityChecker check(File r2) {
        return (FileIntegrityChecker)new FileIntegrityChecker(r2).doAllNodes();
    }

    public FileIntegrityChecker(File root) {
        super((byte)119);
        ArrayList<File> filesInProgress = new ArrayList<File>();
        this.addFolder(root, filesInProgress);
        this._files = new String[filesInProgress.size()];
        this._sizes = new long[filesInProgress.size()];
        for (int i2 = 0; i2 < this._files.length; ++i2) {
            File f2 = filesInProgress.get(i2);
            this._files[i2] = f2.getAbsolutePath();
            this._sizes[i2] = f2.length();
        }
    }

    public int size() {
        return this._files.length;
    }

    public Key syncDirectory(ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        Futures fs = new Futures();
        Key k2 = null;
        for (int i2 = 0; i2 < this._files.length; ++i2) {
            if (this._ok[i2] < H2O.CLOUD.size()) {
                if (fails == null) continue;
                fails.add(this._files[i2]);
                continue;
            }
            File f2 = new File(this._files[i2]);
            k2 = PersistNFS.decodeFile(f2);
            if (files != null) {
                files.add(this._files[i2]);
            }
            if (keys != null) {
                keys.add(k2.toString());
            }
            if (DKV.get(k2) != null) {
                dels.add(k2.toString());
            }
            Key<Job> lockOwner = Key.make();
            new Frame(k2).delete_and_lock(lockOwner);
            NFSFileVec nfs = NFSFileVec.make(f2, fs);
            ((Frame)new Frame(k2, new String[]{"C1"}, new Vec[]{nfs}).update(lockOwner)).unlock(lockOwner);
        }
        fs.blockForPending();
        return k2;
    }
}

