/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.zip.GZIPInputStream;
import water.Iced;

public class DecompressionFactory
extends Iced<DecompressionFactory> {
    private final String _name;

    private DecompressionFactory(String name) {
        this._name = name;
    }

    InputStream wrapInputStream(InputStream is) throws IOException {
        String n2;
        switch (n2 = this._name.toLowerCase()) {
            case "none": {
                return is;
            }
            case "gzip": {
                return new GZIPInputStream(is);
            }
            case "bzip2": {
                return this.wrapDynamic("org.python.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream", is);
            }
            case "snappy": {
                return this.wrapDynamic("org.xerial.snappy.SnappyInputStream", is);
            }
        }
        return this.wrapDynamic(this._name, is);
    }

    private InputStream wrapDynamic(String className, InputStream os2) {
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> constructor = cls.getConstructor(InputStream.class);
            return (InputStream)constructor.newInstance(os2);
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalArgumentException("Cannot create a decompressor using class " + className, e2);
        }
    }

    public static DecompressionFactory make(String name) {
        return new DecompressionFactory(name);
    }
}

