/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ByteStreams {
    public static void readFully(InputStream in, byte[] b2) throws IOException {
        ByteStreams.readFully(in, b2, 0, b2.length);
    }

    private static void readFully(InputStream in, byte[] b2, int off, int len) throws IOException {
        int read = ByteStreams.read(in, b2, off, len);
        if (read != len) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + len + " bytes expected");
        }
    }

    public static int read(InputStream in, byte[] b2, int off, int len) throws IOException {
        int total;
        int result;
        ByteStreams.checkNotNull(in);
        ByteStreams.checkNotNull(b2);
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (total = 0; total < len && (result = in.read(b2, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }
}

