/*
 * Decompiled with CFR 0.152.
 */
package water.udf.specialized;

import water.fvec.Chunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.udf.ColumnFactory;
import water.udf.DataChunk;
import water.udf.DataColumn;
import water.udf.DataColumns;

public class Strings
extends DataColumns.BaseFactory<String> {
    public static final Strings Strings = new Strings();

    public Strings() {
        super((byte)2, "Strings");
    }

    @Override
    public DataChunk<String> apply(Chunk c2) {
        return new StringChunk(c2);
    }

    @Override
    public DataColumn<String> newColumn(Vec vec) {
        if (vec.get_type() != 2) {
            throw new IllegalArgumentException("Expected type T_STR, got " + vec.get_type_str());
        }
        return new StringColumn(vec, this);
    }

    private static String asString(Object x2) {
        return x2 == null ? null : x2.toString();
    }

    static class StringColumn
    extends DataColumn<String> {
        public StringColumn() {
        }

        StringColumn(Vec vec, ColumnFactory<String> factory) {
            super(vec, factory);
        }

        @Override
        public String get(long idx) {
            return this.isNA(idx) ? null : water.udf.specialized.Strings.asString(this.vec().atStr(new BufferedString(), idx));
        }

        @Override
        public void set(long idx, String value) {
            this.vec().set(idx, value);
        }
    }

    static class StringChunk
    extends DataChunk<String> {
        public StringChunk() {
        }

        public StringChunk(Chunk c2) {
            super(c2);
        }

        @Override
        public String get(int idx) {
            return water.udf.specialized.Strings.asString(this.c.atStr(new BufferedString(), idx));
        }

        @Override
        public void set(int idx, String value) {
            this.c.set(idx, value);
        }
    }
}

