/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import water.fvec.Chunk;
import water.fvec.RawChunk;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.DependentChunk;
import water.udf.FunColumnBase;
import water.udf.TypedChunk;
import water.util.Java7;
import water.util.fp.Function3;

public class Fun3Column<X, Y, Z, T>
extends FunColumnBase<T> {
    private final Function3<X, Y, Z, T> f;
    private final Column<X> xs;
    private final Column<Y> ys;
    private final Column<Z> zs;

    @Override
    public int rowLayout() {
        return this.xs.rowLayout();
    }

    public Fun3Column() {
        this.f = null;
        this.xs = null;
        this.ys = null;
        this.zs = null;
    }

    public Fun3Column(Function3<X, Y, Z, T> f2, Column<X> xs, Column<Y> ys, Column<Z> zs) {
        super(xs);
        this.f = f2;
        this.xs = xs;
        this.ys = ys;
        this.zs = zs;
        assert (xs.isCompatibleWith(ys)) : "Columns 1 and 2 must be compatible: " + xs + ", " + ys;
        assert (xs.isCompatibleWith(zs)) : "Columns 1 and 3 must be compatible: " + xs + ", " + zs;
    }

    @Override
    public T get(long idx) {
        return this.isNA(idx) ? null : (T)this.f.apply(this.xs.apply(idx), this.ys.apply(idx), this.zs.apply(idx));
    }

    @Override
    public TypedChunk<T> chunkAt(int i2) {
        return new FunChunk(this.xs.chunkAt(i2), this.ys.chunkAt(i2), this.zs.chunkAt(i2));
    }

    @Override
    public boolean isNA(long idx) {
        return this.xs.isNA(idx) || this.ys.isNA(idx);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 instanceof Fun3Column) {
            Fun3Column other = (Fun3Column)o2;
            return Java7.Objects.equals(this.f, other.f) && this.xs.equals(other.xs);
        }
        return false;
    }

    public int hashCode() {
        return 61 * this.xs.hashCode() + Java7.Objects.hashCode(this.f);
    }

    public String toString() {
        return "Fun3Column(" + this.f.getClass().getSimpleName() + "," + this.xs + "," + this.ys + "," + this.zs + ")";
    }

    public class FunChunk
    extends DependentChunk<T> {
        private final TypedChunk<X> cx;
        private final TypedChunk<Y> cy;
        private final TypedChunk<Z> cz;
        private RawChunk myChunk;

        public FunChunk(TypedChunk<X> cx, TypedChunk<Y> cy, TypedChunk<Z> cz) {
            super(cx);
            this.myChunk = new RawChunk(this);
            this.cx = cx;
            this.cy = cy;
            this.cz = cz;
        }

        @Override
        public Chunk rawChunk() {
            return this.myChunk;
        }

        @Override
        public Vec vec() {
            return Fun3Column.this.vec();
        }

        @Override
        public boolean isNA(int i2) {
            return this.cx.isNA(i2) || this.cy.isNA(i2) || this.cz.isNA(i2);
        }

        @Override
        public T get(int i2) {
            return Fun3Column.this.f.apply(this.cx.get(i2), this.cy.get(i2), this.cz.get(i2));
        }
    }
}

