/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import water.DKV;
import water.Key;
import water.udf.CFuncRef;

class DkvClassLoader
extends ClassLoader {
    private final Map<String, byte[]> jarCache;
    private final Key jarKey;

    public DkvClassLoader(CFuncRef cFuncRef, ClassLoader parent) {
        this(cFuncRef.keyName, parent);
    }

    public DkvClassLoader(String jarKeyName, ClassLoader parent) {
        this(Key.make(jarKeyName), parent);
    }

    public DkvClassLoader(Key jarKey, ClassLoader parent) {
        super(parent);
        this.jarKey = jarKey;
        this.jarCache = DkvClassLoader.buildJarCache(jarKey);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e2) {
            String path = name.replace('.', '/').concat(".class");
            byte[] klazzBytes = this.jarCache.get(path);
            if (klazzBytes != null && klazzBytes.length > 0) {
                return this.defineClass(name, klazzBytes, 0, klazzBytes.length);
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    protected URL findResource(String name) {
        return this.url(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        URL url = this.url(name);
        return url == null ? Collections.emptyEnumeration() : Collections.enumeration(Collections.singletonList(url));
    }

    protected URL url(String name) {
        URL url = null;
        byte[] content = this.jarCache.get(name);
        if (content != null) {
            try {
                url = new URL("dkv", "", -1, this.jarKey + (name.startsWith("/") ? "!" : "!/") + name, new DkvUrlStreamHandler());
            }
            catch (MalformedURLException e2) {
                throw new RuntimeException(e2);
            }
        }
        return url;
    }

    static Map<String, byte[]> buildJarCache(Key jarKey) {
        HashMap<String, byte[]> jarCache = new HashMap<String, byte[]>();
        try (JarInputStream jis = new JarInputStream(new ByteArrayInputStream(DKV.get(jarKey).memOrLoad()));){
            JarEntry entry = null;
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                byte[] content = DkvClassLoader.readJarEntry(jis, entry);
                jarCache.put(entry.getName(), content);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        return jarCache;
    }

    static byte[] readJarEntry(JarInputStream jis, JarEntry entry) throws IOException {
        int len = (int)entry.getSize();
        return len > 0 ? IOUtils.toByteArray((InputStream)jis, (int)len) : IOUtils.toByteArray((InputStream)jis);
    }

    protected static class ByteArrayUrlConnection
    extends URLConnection {
        private final InputStream inputStream;

        protected ByteArrayUrlConnection(URL url, InputStream inputStream) {
            super(url);
            this.inputStream = inputStream;
        }

        @Override
        public void connect() {
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() {
            this.connect();
            return this.inputStream;
        }
    }

    final class DkvUrlStreamHandler
    extends URLStreamHandler {
        public static final String PROTO = "dkv";

        DkvUrlStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            if (!url.getProtocol().equals(PROTO)) {
                throw new IOException("Cannot handle protocol: " + url.getProtocol());
            }
            String path = url.getPath();
            int separator = path.indexOf("!/");
            if (separator == -1) {
                throw new MalformedURLException("Cannot find '!/' in DKV URL!");
            }
            String file = path.substring(separator + 2);
            byte[] content = (byte[])DkvClassLoader.this.jarCache.get(file);
            assert (content != null) : " DkvUrlStreamHandler is not created properly to point to file resource: " + url.toString();
            return new ByteArrayUrlConnection(url, new ByteArrayInputStream(content));
        }
    }
}

