/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.io.IOException;
import java.util.List;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.udf.Column;
import water.udf.ColumnFactory;
import water.udf.DataChunk;
import water.udf.DataColumn;
import water.udf.TypedFrame;
import water.util.fp.Function;
import water.util.fp.Functions;

public class DataColumns {
    protected DataColumns() {
    }

    public static Vec buildZeroVec(long length, byte typeCode) {
        return Vec.makeCon(0.0, length, true, typeCode);
    }

    public static abstract class BaseFactory<T>
    implements ColumnFactory<T> {
        public final byte typeCode;
        public final String name;

        protected BaseFactory(byte typeCode, String name) {
            this.typeCode = typeCode;
            this.name = name;
        }

        @Override
        public byte typeCode() {
            return this.typeCode;
        }

        @Override
        public Vec buildZeroVec(long length) {
            return DataColumns.buildZeroVec(length, this.typeCode);
        }

        public Vec buildZeroVec(Column<?> master) {
            Vec vec = this.buildZeroVec(master.size());
            vec.align(master.vec());
            return vec;
        }

        @Override
        public abstract DataChunk<T> apply(Chunk var1);

        @Override
        public abstract DataColumn<T> newColumn(Vec var1);

        @Override
        public DataColumn<T> newColumn(long length, Function<Long, T> f2) throws IOException {
            return new TypedFrame<T>(this, length, f2).newColumn();
        }

        @Override
        public DataColumn<T> materialize(Column<T> xs) throws IOException {
            return TypedFrame.forColumn(this, xs).newColumn();
        }

        @Override
        public DataColumn<T> newColumn(List<T> xs) throws IOException {
            return this.newColumn(xs.size(), Functions.onList(xs));
        }

        public DataColumn<T> constColumn(T t2, long length) throws IOException {
            return this.newColumn(length, Functions.constant(t2));
        }

        public String toString() {
            return this.name;
        }
    }
}

