/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string.algorithms;

import no.priv.garshol.duke.Comparator;
import org.apache.commons.lang.math.IEEE754rUtils;

public class LevenshteinDistanceComparator
implements Comparator {
    @Override
    public boolean isTokenized() {
        return true;
    }

    @Override
    public double compare(String a2, String b2) {
        if (a2.isEmpty() && b2.isEmpty()) {
            return 1.0;
        }
        return 1.0 - this.distance(a2, b2) / (double)Math.max(a2.length(), b2.length());
    }

    private double distance(String a2, String b2) {
        int i2;
        if (a2.isEmpty()) {
            return b2.length();
        }
        if (b2.isEmpty()) {
            return a2.length();
        }
        if (a2.equals(b2)) {
            return 0.0;
        }
        int aLength = b2.length();
        int bLength = a2.length();
        double[] v0 = new double[aLength + 1];
        double[] v1 = new double[aLength + 1];
        for (i2 = 0; i2 < v0.length; ++i2) {
            v0[i2] = (double)i2 * 1.0;
        }
        for (i2 = 0; i2 < bLength; ++i2) {
            v1[0] = (double)(i2 + 1) * 1.0;
            for (int j2 = 0; j2 < aLength; ++j2) {
                v1[j2 + 1] = IEEE754rUtils.min((double)(v1[j2] + 1.0), (double)(v0[j2 + 1] + 1.0), (double)(v0[j2] + (a2.charAt(i2) == b2.charAt(j2) ? 0.0 : 1.0)));
            }
            double[] swap = v0;
            v0 = v1;
            v1 = swap;
        }
        return v0[aLength];
    }
}

