/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.ArrayList;
import java.util.HashMap;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstTrim
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "trim";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("trim() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.trimCategoricalCol(v3) : this.trimStringCol(v3);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec trimCategoricalCol(Vec vec) {
        String[] doms = (String[])vec.domain().clone();
        HashMap<String, ArrayList<Integer>> trimmedToOldDomainIndices = new HashMap<String, ArrayList<Integer>>();
        for (int i2 = 0; i2 < doms.length; ++i2) {
            String trimmed;
            doms[i2] = trimmed = doms[i2].trim();
            if (!trimmedToOldDomainIndices.containsKey(trimmed)) {
                ArrayList<Integer> val = new ArrayList<Integer>();
                val.add(i2);
                trimmedToOldDomainIndices.put(trimmed, val);
                continue;
            }
            trimmedToOldDomainIndices.get(trimmed).add(i2);
        }
        if (trimmedToOldDomainIndices.size() < doms.length) {
            return VecUtils.DomainDedupe.domainDeduper(vec, trimmedToOldDomainIndices);
        }
        return vec.makeCopy(doms);
    }

    private Vec trimStringCol(Vec vec) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i2 = 0; i2 < chk.len(); ++i2) {
                        newChk.addNA();
                    }
                } else {
                    ((CStrChunk)chk).asciiTrim(newChk);
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

