/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstStrSplit
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "split"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "strsplit";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        String splitRegEx = asts[2].exec(env).getStr();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("strsplit() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        ArrayList<Vec> vs = new ArrayList<Vec>(fr.numCols());
        for (Vec v3 : fr.vecs()) {
            Vec[] splits;
            if (v3.isCategorical()) {
                for (Vec split : splits = this.strSplitCategoricalCol(v3, splitRegEx)) {
                    vs.add(split);
                }
                continue;
            }
            for (Vec split : splits = this.strSplitStringCol(v3, splitRegEx)) {
                vs.add(split);
            }
        }
        return new ValFrame(new Frame(vs.toArray(new Vec[vs.size()])));
    }

    private Vec[] strSplitCategoricalCol(Vec vec, String splitRegEx) {
        final String[] old_domains = vec.domain();
        final String[][] new_domains = this.newDomains(old_domains, splitRegEx);
        final String regex = splitRegEx;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                Chunk c2 = cs[0];
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    int cnt = 0;
                    if (!c2.isNA(i2)) {
                        String[] ss;
                        int idx = (int)c2.at8(i2);
                        String s2 = old_domains[idx];
                        for (String s1 : ss = s2.split(regex)) {
                            int n_idx = Arrays.asList(new_domains[cnt]).indexOf(s1);
                            if (n_idx == -1) {
                                ncs[cnt++].addNA();
                                continue;
                            }
                            ncs[cnt++].addNum(n_idx);
                        }
                    }
                    if (cnt >= ncs.length) continue;
                    while (cnt < ncs.length) {
                        ncs[cnt].addNA();
                        ++cnt;
                    }
                }
            }
        }.doAll(new_domains.length, (byte)4, new Frame(vec))).outputFrame(null, null, new_domains).vecs();
    }

    private String[][] newDomains(String[] domains, String regex) {
        ArrayList<HashSet<String>> strs = new ArrayList<HashSet<String>>();
        for (String domain : domains) {
            String[] news = domain.split(regex);
            for (int i2 = 0; i2 < news.length; ++i2) {
                if (strs.size() == i2) {
                    HashSet<String> x2 = new HashSet<String>();
                    x2.add(news[i2]);
                    strs.add(x2);
                    continue;
                }
                strs.get(i2).add(news[i2]);
            }
        }
        return this.listToArray(strs);
    }

    private String[][] listToArray(ArrayList<HashSet<String>> strs) {
        String[][] doms = new String[strs.size()][];
        int i2 = 0;
        for (HashSet<String> h2 : strs) {
            doms[i2++] = h2.toArray(new String[h2.size()]);
        }
        return doms;
    }

    private Vec[] strSplitStringCol(Vec vec, final String splitRegEx) {
        int newColCnt = ((CountSplits)new CountSplits((String)splitRegEx).doAll((Vec[])new Vec[]{vec}))._maxSplits;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                Chunk chk = cs[0];
                if (chk instanceof C0DChunk) {
                    for (int row = 0; row < chk.len(); ++row) {
                        for (int col = 0; col < ncs.length; ++col) {
                            ncs[col].addNA();
                        }
                    }
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int row = 0; row < chk._len; ++row) {
                        int col = 0;
                        if (!chk.isNA(row)) {
                            String[] ss;
                            for (String s2 : ss = chk.atStr(tmpStr, row).toString().split(splitRegEx)) {
                                ncs[col++].addStr(s2);
                            }
                        }
                        if (col >= ncs.length) continue;
                        while (col < ncs.length) {
                            ncs[col].addNA();
                            ++col;
                        }
                    }
                }
            }
        }.doAll(newColCnt, (byte)2, new Frame(vec))).outputFrame().vecs();
    }

    private static class CountSplits
    extends MRTask<CountSplits> {
        private final String _regex;
        int _maxSplits = 0;

        CountSplits(String regex) {
            this._regex = regex;
        }

        @Override
        public void map(Chunk chk) {
            BufferedString tmpStr = new BufferedString();
            for (int row = 0; row < chk._len; ++row) {
                int split;
                if (chk.isNA(row) || (split = chk.atStr(tmpStr, row).toString().split(this._regex).length) <= this._maxSplits) continue;
                this._maxSplits = split;
            }
        }

        @Override
        public void reduce(CountSplits that) {
            if (this._maxSplits < that._maxSplits) {
                this._maxSplits = that._maxSplits;
            }
        }
    }
}

