/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import no.priv.garshol.duke.Comparator;
import no.priv.garshol.duke.comparators.JaccardIndexComparator;
import no.priv.garshol.duke.comparators.LongestCommonSubstring;
import no.priv.garshol.duke.comparators.QGramComparator;
import no.priv.garshol.duke.comparators.SoundexComparator;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.string.algorithms.H2OJaroWinklerComparator;
import water.rapids.ast.prims.string.algorithms.LevenshteinDistanceComparator;
import water.rapids.vals.ValFrame;

public class AstStrDistance
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary_x", "ary_y", "measure"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "strDistance";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        boolean compareEmpty;
        Frame frX = stk.track(asts[1].exec(env)).getFrame();
        Frame frY = stk.track(asts[2].exec(env)).getFrame();
        String measure = asts[3].exec(env).getStr();
        boolean bl = compareEmpty = asts[4].exec(env).getNum() == 1.0;
        if (frX.numCols() != frY.numCols() || frX.numRows() != frY.numRows()) {
            throw new IllegalArgumentException("strDistance() requires the frames to have the same number of columns and rows.");
        }
        for (int i2 = 0; i2 < frX.numCols(); ++i2) {
            if (AstStrDistance.isCharacterType(frX.vec(i2)) && AstStrDistance.isCharacterType(frY.vec(i2))) continue;
            throw new IllegalArgumentException("Types of columns of both frames need to be String/Factor");
        }
        AstStrDistance.makeComparator(measure);
        byte[] outputTypes = new byte[frX.numCols()];
        Vec[] vecs = new Vec[frX.numCols() * 2];
        for (int i3 = 0; i3 < outputTypes.length; ++i3) {
            outputTypes[i3] = 3;
            vecs[i3] = frX.vec(i3);
            vecs[i3 + outputTypes.length] = frY.vec(i3);
        }
        Frame distFr = ((StringDistanceComparator)new StringDistanceComparator(measure, compareEmpty).doAll(outputTypes, vecs)).outputFrame();
        return new ValFrame(distFr);
    }

    private static boolean isCharacterType(Vec v2) {
        return v2.get_type() == 2 || v2.get_type() == 4;
    }

    private static Comparator makeComparator(String measure) {
        switch (measure) {
            case "jaccard": 
            case "JaccardIndex": {
                return new JaccardIndexComparator();
            }
            case "jw": 
            case "JaroWinkler": {
                return new H2OJaroWinklerComparator();
            }
            case "lv": 
            case "Levenshtein": {
                return new LevenshteinDistanceComparator();
            }
            case "lcs": 
            case "LongestCommonSubstring": {
                return new LongestCommonSubstring();
            }
            case "qgram": 
            case "QGram": {
                return new QGramComparator();
            }
            case "soundex": 
            case "Soundex": {
                return new SoundexComparator();
            }
        }
        throw new IllegalArgumentException("Unknown comparator: " + measure);
    }

    private static class StringDistanceComparator
    extends MRTask<StringDistanceComparator> {
        private final String _measure;
        private final boolean _compareEmpty;

        private StringDistanceComparator(String measure, boolean compareEmpty) {
            this._measure = measure;
            this._compareEmpty = compareEmpty;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            BufferedString tmpStr = new BufferedString();
            Comparator cmp = AstStrDistance.makeComparator(this._measure);
            int N2 = nc.length;
            assert (N2 * 2 == cs.length);
            for (int i2 = 0; i2 < N2; ++i2) {
                Chunk cX = cs[i2];
                String[] domainX = this._fr.vec(i2).domain();
                Chunk cY = cs[i2 + N2];
                String[] domainY = this._fr.vec(i2 + N2).domain();
                for (int row = 0; row < cX._len; ++row) {
                    if (cX.isNA(row) || cY.isNA(row)) {
                        nc[i2].addNA();
                        continue;
                    }
                    String strX = StringDistanceComparator.getString(tmpStr, cX, row, domainX);
                    String strY = StringDistanceComparator.getString(tmpStr, cY, row, domainY);
                    if (!this._compareEmpty && (strX.isEmpty() || strY.isEmpty())) {
                        nc[i2].addNA();
                        continue;
                    }
                    double dist = cmp.compare(strX, strY);
                    nc[i2].addNum(dist);
                }
            }
        }

        private static String getString(BufferedString tmpStr, Chunk chk, int row, String[] domain) {
            if (domain != null) {
                return domain[(int)chk.at8(row)];
            }
            return chk.atStr(tmpStr, row).toString();
        }
    }
}

