/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import java.util.HashMap;
import java.util.Iterator;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstEntropy
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "entropy";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("entropy() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.entropyCategoricalCol(v3) : this.entropyStringCol(v3);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec entropyCategoricalCol(Vec vec) {
        Vec res = ((MRTask)new MRTask(){
            transient double[] catEntropies;

            @Override
            public void setupLocal() {
                String[] doms = this._fr.anyVec().domain();
                this.catEntropies = new double[doms.length];
                for (int i2 = 0; i2 < doms.length; ++i2) {
                    this.catEntropies[i2] = AstEntropy.this.calcEntropy(doms[i2]);
                }
            }

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                newChk.alloc_doubles(chk._len);
                for (int i2 = 0; i2 < chk._len; ++i2) {
                    if (chk.isNA(i2)) {
                        newChk.addNA();
                        continue;
                    }
                    newChk.addNum(this.catEntropies[(int)chk.atd(i2)]);
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
        return res;
    }

    private Vec entropyStringCol(Vec vec) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    newChk.addNAs(chk.len());
                } else if (((CStrChunk)chk)._isAllASCII) {
                    ((CStrChunk)chk).asciiEntropy(newChk);
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i2 = 0; i2 < chk._len; ++i2) {
                        if (chk.isNA(i2)) {
                            newChk.addNA();
                            continue;
                        }
                        String str = chk.atStr(tmpStr, i2).toString();
                        newChk.addNum(AstEntropy.this.calcEntropy(str));
                    }
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame().anyVec();
    }

    private double calcEntropy(String str) {
        HashMap<Character, Integer> freq = new HashMap<Character, Integer>();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c2 = str.charAt(i2);
            Integer count2 = (Integer)freq.get(Character.valueOf(c2));
            if (count2 == null) {
                freq.put(Character.valueOf(c2), 1);
                continue;
            }
            freq.put(Character.valueOf(c2), count2 + 1);
        }
        double sume = 0.0;
        int N2 = str.length();
        Iterator iterator = freq.keySet().iterator();
        while (iterator.hasNext()) {
            char c3 = ((Character)iterator.next()).charValue();
            double n2 = ((Integer)freq.get(Character.valueOf(c3))).intValue();
            sume += -n2 / (double)N2 * Math.log(n2 / (double)N2) / Math.log(2.0);
        }
        return sume;
    }
}

