/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.search;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.params.AstStrList;
import water.rapids.vals.ValFrame;
import water.util.MathUtils;

public class AstMatch
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "table", "nomatch", "incomparables"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "match";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Object[] values;
        MRTask matchTask;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 || !fr.anyVec().isCategorical() && !fr.anyVec().isString()) {
            throw new IllegalArgumentException("can only match on a single categorical/string column.");
        }
        double noMatch = asts[3].exec(env).getNum();
        if (asts[2] instanceof AstNumList) {
            matchTask = new NumMatchTask(((AstNumList)asts[2]).sort().expand(), noMatch);
        } else if (asts[2] instanceof AstNum) {
            matchTask = new NumMatchTask(new double[]{asts[2].exec(env).getNum()}, noMatch);
        } else if (asts[2] instanceof AstStrList) {
            values = ((AstStrList)asts[2])._strs;
            Arrays.sort(values);
            matchTask = fr.anyVec().isString() ? new StrMatchTask((String[])values, noMatch) : new CatMatchTask((String[])values, noMatch);
        } else if (asts[2] instanceof AstStr) {
            values = new String[]{asts[2].exec(env).getStr()};
            matchTask = fr.anyVec().isString() ? new StrMatchTask((String[])values, noMatch) : new CatMatchTask((String[])values, noMatch);
        } else {
            throw new IllegalArgumentException("Expected numbers/strings. Got: " + asts[2].getClass());
        }
        Frame result = ((MRTask)matchTask.doAll((byte)3, fr.anyVec())).outputFrame();
        return new ValFrame(result);
    }

    private static double in(String[] matches, String s2, double nomatch) {
        return Arrays.binarySearch(matches, s2) >= 0 ? 1.0 : nomatch;
    }

    private static double in(double[] matches, double d2, double nomatch) {
        return AstMatch.binarySearchDoublesUlp(matches, 0, matches.length, d2) >= 0 ? 1.0 : nomatch;
    }

    private static int binarySearchDoublesUlp(double[] a2, int from, int to, double key) {
        int lo = from;
        int hi = to - 1;
        while (lo <= hi) {
            long keyBits;
            int mid = lo + hi >>> 1;
            double midVal = a2[mid];
            if (MathUtils.equalsWithinOneSmallUlp(midVal, key)) {
                return mid;
            }
            if (midVal < key) {
                lo = mid + 1;
                continue;
            }
            if (midVal > key) {
                hi = mid - 1;
                continue;
            }
            long midBits = Double.doubleToLongBits(midVal);
            if (midBits == (keyBits = Double.doubleToLongBits(key))) {
                return mid;
            }
            if (midBits < keyBits) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return -(lo + 1);
    }

    private static class NumMatchTask
    extends MRTask<CatMatchTask> {
        double[] _values;
        double _noMatch;

        NumMatchTask(double[] values, double noMatch) {
            this._values = values;
            this._noMatch = noMatch;
        }

        @Override
        public void map(Chunk c2, NewChunk nc) {
            int rows = c2._len;
            for (int r2 = 0; r2 < rows; ++r2) {
                double x2 = c2.isNA(r2) ? this._noMatch : AstMatch.in(this._values, c2.atd(r2), this._noMatch);
                nc.addNum(x2);
            }
        }
    }

    private static class CatMatchTask
    extends MRTask<CatMatchTask> {
        String[] _values;
        double _noMatch;

        CatMatchTask(String[] values, double noMatch) {
            this._values = values;
            this._noMatch = noMatch;
        }

        @Override
        public void map(Chunk c2, NewChunk nc) {
            String[] domain = c2.vec().domain();
            int rows = c2._len;
            for (int r2 = 0; r2 < rows; ++r2) {
                double x2 = c2.isNA(r2) ? this._noMatch : AstMatch.in(this._values, domain[(int)c2.at8(r2)], this._noMatch);
                nc.addNum(x2);
            }
        }
    }

    private static class StrMatchTask
    extends MRTask<CatMatchTask> {
        String[] _values;
        double _noMatch;

        StrMatchTask(String[] values, double noMatch) {
            this._values = values;
            this._noMatch = noMatch;
        }

        @Override
        public void map(Chunk c2, NewChunk nc) {
            BufferedString bs = new BufferedString();
            int rows = c2._len;
            for (int r2 = 0; r2 < rows; ++r2) {
                double x2 = c2.isNA(r2) ? this._noMatch : AstMatch.in(this._values, c2.atStr(bs, r2).toString(), this._noMatch);
                nc.addNum(x2);
            }
        }
    }
}

