/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.repeaters;

import water.Futures;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstSeq
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"from", "to", "by"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "seq";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        double from = asts[1].exec(env).getNum();
        double to = asts[2].exec(env).getNum();
        double by = asts[3].exec(env).getNum();
        double delta = to - from;
        if (delta == 0.0 && to == 0.0) {
            throw new IllegalArgumentException("Expected `to` and `from` to have nonzero difference.");
        }
        double n2 = delta / by;
        if (n2 < 0.0) {
            throw new IllegalArgumentException("wrong sign in 'by' argument");
        }
        if (n2 > Double.MAX_VALUE) {
            throw new IllegalArgumentException("'by' argument is much too small");
        }
        Futures fs = new Futures();
        AppendableVec av = new AppendableVec(Vec.newKey(), 3);
        NewChunk nc = new NewChunk(av, 0);
        int len = (int)n2 + 1;
        for (int r2 = 0; r2 < len; ++r2) {
            nc.addNum(from + (double)r2 * by);
        }
        nc.close(0, fs);
        Vec vec = av.layout_and_close(fs);
        fs.blockForPending();
        return new ValFrame(new Frame(vec));
    }
}

