/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.reducers;

import java.util.PriorityQueue;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstTopN
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"frame", "col", "nPercent", "grabTopN"};
    }

    @Override
    public String str() {
        return "topn";
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String example() {
        return "(topn frame col nPercent getBottomN)";
    }

    @Override
    public String description() {
        return "Return the top N percent rows for a numerical column as a frame with two columns.  The first column will contain the original row indices of the chosen values.  The second column contains the top N rowvalues.  If grabTopN is -1, we will return the bottom N percent.  If grabTopN is 1, we will returnthe top N percent of rows";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame frOriginal = stk.track(asts[1].exec(env)).getFrame();
        int colIndex = (int)stk.track(asts[2].exec(env)).getNum();
        double nPercent = stk.track(asts[3].exec(env)).getNum();
        int grabTopN = (int)stk.track(asts[4].exec(env)).getNum();
        long numRows = Math.round(nPercent * 0.01 * (double)frOriginal.numRows());
        String[] finalColumnNames = new String[]{"Original_Row_Indices", frOriginal.name(colIndex)};
        GrabTopNPQ grabTask = new GrabTopNPQ(finalColumnNames, numRows, grabTopN, frOriginal.vec(colIndex).isInt());
        grabTask.doAll(frOriginal.vec(colIndex));
        return new ValFrame(grabTask._sortedOut);
    }

    public class RowValue<E extends Comparable<E>>
    implements Comparable<RowValue<E>> {
        private long _rowIndex;
        private E _value;
        boolean _increasing;
        int _flipSign;
        final /* synthetic */ AstTopN this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public RowValue(long value, E e2, int n3) {
            void flipSign;
            void rowIndex;
            this.this$0 = (AstTopN)this$0;
            this._rowIndex = rowIndex;
            this._value = value;
            this._flipSign = flipSign;
        }

        public E getValue() {
            return this._value;
        }

        public long getRow() {
            return this._rowIndex;
        }

        @Override
        public int compareTo(RowValue<E> other) {
            return this.getValue().compareTo(other.getValue()) * this._flipSign;
        }
    }

    public class GrabTopNPQ<E extends Comparable<E>>
    extends MRTask<GrabTopNPQ<E>> {
        final String[] _columnName;
        PriorityQueue _sortQueue;
        long[] _rowIndices;
        long[] _lValues;
        double[] _dValues;
        Frame _sortedOut;
        final int _rowSize;
        final int _flipSign;
        boolean _csLong = false;

        private GrabTopNPQ(String[] columnName, long rowSize, int flipSign, boolean isLong) {
            this._columnName = columnName;
            this._rowSize = (int)rowSize;
            this._flipSign = flipSign;
            this._csLong = isLong;
        }

        @Override
        public void map(Chunk cs) {
            this._sortQueue = new PriorityQueue();
            long startRow = cs.start();
            for (int rowIndex = 0; rowIndex < cs._len; ++rowIndex) {
                long absRowIndex = (long)rowIndex + startRow;
                if (cs.isNA(rowIndex)) continue;
                this.addOneValue(cs, rowIndex, absRowIndex, this._sortQueue);
            }
            if (this._csLong) {
                this._lValues = new long[this._sortQueue.size()];
                this.copyPQ2ArryL(this._sortQueue, this._lValues);
            } else {
                this._dValues = new double[this._sortQueue.size()];
                this.copyPQ2ArryD(this._sortQueue, this._dValues);
            }
        }

        public void copyPQ2ArryL(PriorityQueue sortQueue, long[] values) {
            int qSize = sortQueue.size();
            this._rowIndices = new long[qSize];
            for (int index = qSize - 1; index >= 0; --index) {
                RowValue tempPairs = (RowValue)sortQueue.poll();
                this._rowIndices[index] = tempPairs.getRow();
                values[index] = (Long)tempPairs.getValue();
            }
        }

        public <T> void copyPQ2ArryD(PriorityQueue sortQueue, double[] values) {
            int qSize = sortQueue.size();
            this._rowIndices = new long[qSize];
            for (int index = qSize - 1; index >= 0; --index) {
                RowValue tempPairs = (RowValue)sortQueue.poll();
                this._rowIndices[index] = tempPairs.getRow();
                values[index] = (Double)tempPairs.getValue();
            }
        }

        @Override
        public void reduce(GrabTopNPQ<E> other) {
            if (this._csLong) {
                this.mergeArraysL(other._rowIndices, other._lValues);
            } else {
                this.mergeArraysD(other._rowIndices, other._dValues);
            }
        }

        public void mergeArraysL(long[] otherRow, long[] otherValue) {
            int finalArraySize = StrictMath.min(this._rowSize, this._lValues.length + otherValue.length);
            long[] newRow = new long[finalArraySize];
            long[] newValues = new long[finalArraySize];
            int thisRowIndex = 0;
            int otherRowIndex = 0;
            for (int index = 0; index < finalArraySize; ++index) {
                if (thisRowIndex < this._lValues.length && otherRowIndex < otherValue.length) {
                    if (Long.valueOf(this._lValues[thisRowIndex]).compareTo(otherValue[otherRowIndex]) * this._flipSign >= 0) {
                        newRow[index] = this._rowIndices[thisRowIndex];
                        newValues[index] = this._lValues[thisRowIndex++];
                        continue;
                    }
                    newRow[index] = otherRow[otherRowIndex];
                    newValues[index] = otherValue[otherRowIndex++];
                    continue;
                }
                if (thisRowIndex < this._lValues.length) {
                    newRow[index] = this._rowIndices[thisRowIndex];
                    newValues[index] = this._lValues[thisRowIndex++];
                    continue;
                }
                newRow[index] = otherRow[otherRowIndex];
                newValues[index] = otherValue[otherRowIndex++];
            }
            this._rowIndices = newRow;
            this._lValues = newValues;
        }

        public void mergeArraysD(long[] otherRow, double[] otherValue) {
            int finalArraySize = StrictMath.min(this._rowSize, this._rowIndices.length + otherRow.length);
            long[] newRow = new long[finalArraySize];
            double[] newValues = new double[finalArraySize];
            int thisRowIndex = 0;
            int otherRowIndex = 0;
            for (int index = 0; index < finalArraySize; ++index) {
                if (thisRowIndex < this._dValues.length && otherRowIndex < otherValue.length) {
                    if (Double.valueOf(this._dValues[thisRowIndex]).compareTo(otherValue[otherRowIndex]) * this._flipSign >= 0) {
                        newRow[index] = this._rowIndices[thisRowIndex];
                        newValues[index] = this._dValues[thisRowIndex++];
                        continue;
                    }
                    newRow[index] = otherRow[otherRowIndex];
                    newValues[index] = otherValue[otherRowIndex++];
                    continue;
                }
                if (thisRowIndex < this._dValues.length) {
                    newRow[index] = this._rowIndices[thisRowIndex];
                    newValues[index] = this._dValues[thisRowIndex++];
                    continue;
                }
                newRow[index] = otherRow[otherRowIndex];
                newValues[index] = otherValue[otherRowIndex++];
            }
            this._rowIndices = newRow;
            this._dValues = newValues;
        }

        @Override
        public void postGlobal() {
            int index;
            Vec[] xvecs = new Vec[2];
            long actualRowOutput = this._rowIndices.length;
            for (index = 0; index < xvecs.length; ++index) {
                xvecs[index] = Vec.makeZero(actualRowOutput);
            }
            index = 0;
            while ((long)index < actualRowOutput) {
                xvecs[0].set((long)index, this._rowIndices[index]);
                xvecs[1].set((long)index, this._csLong ? (double)this._lValues[index] : this._dValues[index]);
                ++index;
            }
            this._sortedOut = new Frame(this._columnName, xvecs);
        }

        public void addOneValue(Chunk cs, int rowIndex, long absRowIndex, PriorityQueue sortHeap) {
            RowValue currPair = null;
            if (this._csLong) {
                long a2 = cs.at8(rowIndex);
                currPair = new RowValue(AstTopN.this, absRowIndex, (Comparable)Long.valueOf(a2), this._flipSign);
            } else {
                double a3 = cs.atd(rowIndex);
                currPair = new RowValue(AstTopN.this, absRowIndex, (Comparable)Double.valueOf(a3), this._flipSign);
            }
            sortHeap.offer(currPair);
            if (sortHeap.size() > this._rowSize) {
                sortHeap.poll();
            }
        }
    }
}

