/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.reducers;

import java.util.Arrays;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public abstract class AstCumu
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "axis"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        throw H2O.unimpl();
    }

    public abstract double op(double var1, double var3);

    public abstract double init();

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr2;
        Frame f2 = stk.track(asts[1].exec(env)).getFrame();
        AstRoot axisAR = asts[2];
        for (Vec v2 : f2.vecs()) {
            if (!v2.isCategorical() && !v2.isString() && !v2.isUUID()) continue;
            throw new IllegalArgumentException("Cumulative functions not applicable to enum, string, or UUID values");
        }
        double axis = axisAR.exec(env).getNum();
        if (axis != 1.0 && axis != 0.0) {
            throw new IllegalArgumentException("Axis must be 0 or 1");
        }
        if (f2.numCols() == 1) {
            if (axis == 0.0) {
                CumuTask t2 = new CumuTask(f2.anyVec().nChunks(), this.init());
                t2.doAll(new byte[]{3}, f2.anyVec());
                final double[] chkCumu = t2._chkCumu;
                Vec cumuVec = t2.outputFrame().anyVec();
                new MRTask(){

                    @Override
                    public void map(Chunk c2) {
                        if (c2.cidx() != 0) {
                            double d2 = chkCumu[c2.cidx() - 1];
                            for (int i2 = 0; i2 < c2._len; ++i2) {
                                c2.set(i2, AstCumu.this.op(c2.atd(i2), d2));
                            }
                        }
                    }
                }.doAll(cumuVec);
                Key<Frame> k2 = Key.make();
                return new ValFrame(new Frame(k2, null, new Vec[]{cumuVec}));
            }
            return new ValFrame(new Frame(f2));
        }
        if (axis == 0.0) {
            CumuTaskWholeFrame t3 = new CumuTaskWholeFrame(f2.anyVec().nChunks(), this.init(), f2.numCols());
            fr2 = ((CumuTaskWholeFrame)t3.doAll(f2.numCols(), (byte)3, f2)).outputFrame(null, f2.names(), null);
            final double[][] chkCumu = t3._chkCumu;
            new MRTask(){

                @Override
                public void map(Chunk[] cs) {
                    if (cs[0].cidx() != 0) {
                        for (int i2 = 0; i2 < cs.length; ++i2) {
                            double d2 = chkCumu[i2][cs[i2].cidx() - 1];
                            for (int j2 = 0; j2 < cs[i2]._len; ++j2) {
                                cs[i2].set(j2, AstCumu.this.op(cs[i2].atd(j2), d2));
                            }
                        }
                    }
                }
            }.doAll(fr2);
            return new ValFrame(new Frame(fr2));
        }
        CumuTaskAxis1 t4 = new CumuTaskAxis1(this.init());
        fr2 = ((CumuTaskAxis1)t4.doAll(f2.numCols(), (byte)3, f2)).outputFrame(null, f2.names(), null);
        return new ValFrame(new Frame(fr2));
    }

    protected class CumuTask
    extends MRTask<CumuTask> {
        final int _nchks;
        final double _init;
        double[] _chkCumu;

        CumuTask(int nchks, double init) {
            this._nchks = nchks;
            this._init = init;
        }

        @Override
        public void setupLocal() {
            this._chkCumu = new double[this._nchks];
        }

        @Override
        public void map(Chunk c2, NewChunk nc) {
            double acc = this._init;
            for (int i2 = 0; i2 < c2._len; ++i2) {
                acc = AstCumu.this.op(acc, c2.atd(i2));
                nc.addNum(acc);
            }
            this._chkCumu[c2.cidx()] = acc;
        }

        @Override
        public void reduce(CumuTask t2) {
            if (this._chkCumu != t2._chkCumu) {
                ArrayUtils.add(this._chkCumu, t2._chkCumu);
            }
        }

        @Override
        public void postGlobal() {
            for (int i2 = 1; i2 < this._chkCumu.length; ++i2) {
                this._chkCumu[i2] = AstCumu.this.op(this._chkCumu[i2], this._chkCumu[i2 - 1]);
            }
        }
    }

    protected class CumuTaskWholeFrame
    extends MRTask<CumuTaskWholeFrame> {
        final int _nchks;
        final double _init;
        final int _ncols;
        double[][] _chkCumu;

        CumuTaskWholeFrame(int nchks, double init, int ncols) {
            this._nchks = nchks;
            this._init = init;
            this._ncols = ncols;
        }

        @Override
        public void setupLocal() {
            this._chkCumu = new double[this._ncols][this._nchks];
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            double[] acc = new double[cs.length];
            Arrays.fill(acc, this._init);
            for (int i2 = 0; i2 < cs.length; ++i2) {
                for (int j2 = 0; j2 < cs[i2]._len; ++j2) {
                    acc[i2] = AstCumu.this.op(acc[i2], cs[i2].atd(j2));
                    nc[i2].addNum(acc[i2]);
                }
                this._chkCumu[i2][cs[i2].cidx()] = acc[i2];
            }
        }

        @Override
        public void reduce(CumuTaskWholeFrame t2) {
            if (this._chkCumu != t2._chkCumu) {
                ArrayUtils.add(this._chkCumu, t2._chkCumu);
            }
        }

        @Override
        public void postGlobal() {
            for (int i2 = 1; i2 < this._chkCumu.length; ++i2) {
                for (int j2 = 1; j2 < this._chkCumu[i2].length; ++j2) {
                    this._chkCumu[i2][j2] = AstCumu.this.op(this._chkCumu[i2][j2], this._chkCumu[i2][j2 - 1]);
                }
            }
        }
    }

    protected class CumuTaskAxis1
    extends MRTask<CumuTaskAxis1> {
        final double _init;

        CumuTaskAxis1(double init) {
            this._init = init;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int i2 = 0; i2 < cs[0].len(); ++i2) {
                for (int j2 = 0; j2 < cs.length; ++j2) {
                    double preVal = j2 == 0 ? this._init : nc[j2 - 1].atd(i2);
                    nc[j2].addNum(AstCumu.this.op(preVal, cs[j2].atd(i2)));
                }
            }
        }
    }
}

