/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.operators;

import java.util.Arrays;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;
import water.rapids.vals.ValRow;
import water.util.ArrayUtils;
import water.util.VecUtils;

public class AstIfElse
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"test", "true", "false"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "ifelse";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Object[] dom;
        Val val = stk.track(asts[1].exec(env));
        if (val.isNum()) {
            double d2 = val.getNum();
            if (Double.isNaN(d2)) {
                return new ValNum(Double.NaN);
            }
            Val res = stk.track(asts[d2 == 0.0 ? 3 : 2].exec(env));
            return res.isFrame() ? new ValNum(res.getFrame().vec(0).at(0L)) : res;
        }
        if (val.type() == 6) {
            return this.row_ifelse((ValRow)val, asts[2].exec(env), asts[3].exec(env));
        }
        Frame tst = val.getFrame();
        Frame fr = new Frame(tst);
        Val tval = null;
        for (Vec vec : tst.vecs()) {
            if (vec.min() != 0.0 || vec.max() != 0.0) {
                tval = this.exec_check(env, stk, tst, asts[2]);
                break;
            }
            tval = Unevaluated.INSTANCE;
        }
        Val fval = null;
        for (Vec vec : tst.vecs()) {
            if (vec.nzCnt() + vec.naCnt() < vec.length()) {
                fval = this.exec_check(env, stk, tst, asts[3]);
                break;
            }
            fval = Unevaluated.INSTANCE;
        }
        if (tval == Unevaluated.INSTANCE && fval == Unevaluated.INSTANCE) {
            tval = null;
            fval = null;
        } else if (tval == Unevaluated.INSTANCE) {
            tval = fval;
        } else if (fval == Unevaluated.INSTANCE) {
            fval = tval;
        }
        final boolean has_tfr = tval != null && tval.isFrame();
        final String ts = tval != null && tval.isStr() ? tval.getStr() : null;
        final double td = tval != null && tval.isNum() ? tval.getNum() : Double.NaN;
        final int[] tsIntMap = new int[tst.numCols()];
        final boolean has_ffr = fval != null && fval.isFrame();
        final String fs = fval != null && fval.isStr() ? fval.getStr() : null;
        final double fd = fval != null && fval.isNum() ? fval.getNum() : Double.NaN;
        final int[] fsIntMap = new int[tst.numCols()];
        if (has_tfr) {
            fr.add(tval.getFrame());
        }
        if (has_ffr) {
            fr.add(fval.getFrame());
        }
        String[][] domains = null;
        final int[][] maps = new int[tst.numCols()][];
        if (fs != null || ts != null) {
            Vec v2;
            int i2;
            domains = new String[tst.numCols()][];
            if (fs != null && ts != null) {
                for (i2 = 0; i2 < tst.numCols(); ++i2) {
                    domains[i2] = new String[]{fs, ts};
                    fsIntMap[i2] = 0;
                    tsIntMap[i2] = 1;
                }
            } else if (ts != null) {
                for (i2 = 0; i2 < tst.numCols(); ++i2) {
                    if (has_ffr) {
                        v2 = fr.vec(i2 + tst.numCols() + (has_tfr ? tst.numCols() : 0));
                        if (!v2.isCategorical()) {
                            throw H2O.unimpl("Column is not categorical.");
                        }
                    } else {
                        throw H2O.unimpl();
                    }
                    dom = Arrays.copyOf(v2.domain(), v2.domain().length + 1);
                    dom[dom.length - 1] = ts;
                    Arrays.sort(dom);
                    maps[i2] = AstIfElse.computeMap(v2.domain(), (String[])dom);
                    tsIntMap[i2] = ArrayUtils.find(dom, ts);
                    domains[i2] = dom;
                }
            } else {
                for (i2 = 0; i2 < tst.numCols(); ++i2) {
                    if (has_tfr) {
                        v2 = fr.vec(i2 + tst.numCols() + (has_ffr ? tst.numCols() : 0));
                        if (!v2.isCategorical()) {
                            throw H2O.unimpl("Column is not categorical.");
                        }
                    } else {
                        throw H2O.unimpl();
                    }
                    dom = Arrays.copyOf(v2.domain(), v2.domain().length + 1);
                    dom[dom.length - 1] = fs;
                    Arrays.sort(dom);
                    maps[i2] = AstIfElse.computeMap(v2.domain(), (String[])dom);
                    fsIntMap[i2] = ArrayUtils.find(dom, fs);
                    domains[i2] = dom;
                }
            }
        }
        Frame res = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                assert (nchks.length + (has_tfr ? nchks.length : 0) + (has_ffr ? nchks.length : 0) == chks.length);
                for (int i2 = 0; i2 < nchks.length; ++i2) {
                    Chunk ctst = chks[i2];
                    NewChunk res = nchks[i2];
                    for (int row = 0; row < ctst._len; ++row) {
                        double d2 = ctst.isNA(row) ? Double.NaN : (ctst.atd(row) == 0.0 ? (has_ffr ? AstIfElse.domainMap(chks[i2 + nchks.length + (has_tfr ? nchks.length : 0)].atd(row), maps[i2]) : (fs != null ? (double)fsIntMap[i2] : fd)) : (has_tfr ? AstIfElse.domainMap(chks[i2 + nchks.length].atd(row), maps[i2]) : (ts != null ? (double)tsIntMap[i2] : td)));
                        res.addNum(d2);
                    }
                }
            }
        }.doAll(tst.numCols(), (byte)3, fr)).outputFrame(null, domains);
        if (domains != null) {
            for (int i3 = 0; i3 < res.numCols(); ++i3) {
                if (res.vec(i3).domain() == null) continue;
                dom = ((VecUtils.CollectDomainFast)new VecUtils.CollectDomainFast((int)res.vec(i3).max()).doAll(res.vec(i3))).domain();
                String[] newDomain = new String[dom.length];
                for (int l2 = 0; l2 < dom.length; ++l2) {
                    newDomain[l2] = res.vec(i3).domain()[(int)dom[l2]];
                }
                new MRTask((long[])dom){
                    final /* synthetic */ long[] val$dom;
                    {
                        this.val$dom = lArray;
                    }

                    @Override
                    public void map(Chunk c2) {
                        for (int i2 = 0; i2 < c2._len; ++i2) {
                            if (c2.isNA(i2)) continue;
                            c2.set(i2, ArrayUtils.find(this.val$dom, c2.at8(i2)));
                        }
                    }
                }.doAll(res.vec(i3));
                res.vec(i3).setDomain(newDomain);
            }
        }
        return new ValFrame(res);
    }

    private static double domainMap(double d2, int[] maps) {
        if (maps != null && d2 == (double)((int)d2) && 0.0 <= d2 && d2 < (double)maps.length) {
            return maps[(int)d2];
        }
        return d2;
    }

    private static int[] computeMap(String[] from, String[] to) {
        int[] map = new int[from.length];
        for (int i2 = 0; i2 < from.length; ++i2) {
            map[i2] = ArrayUtils.find(to, from[i2]);
        }
        return map;
    }

    Val exec_check(Env env, Env.StackHelp stk, Frame tst, AstRoot ast) {
        Val val = ast.exec(env);
        if (val.isFrame()) {
            Frame fr = stk.track(val).getFrame();
            if (tst.numCols() != fr.numCols() || tst.numRows() != fr.numRows()) {
                throw new IllegalArgumentException("ifelse test frame and other frames must match dimensions, found " + tst + " and " + fr);
            }
        }
        return val;
    }

    ValRow row_ifelse(ValRow tst, Val yes, Val no) {
        double[] False;
        double[] True;
        double[] test = tst.getRow();
        if (!yes.isRow() && !no.isRow()) {
            throw H2O.unimpl();
        }
        switch (yes.type()) {
            case 1: {
                True = new double[]{yes.getNum()};
                break;
            }
            case 6: {
                True = yes.getRow();
                break;
            }
            default: {
                throw H2O.unimpl("row ifelse unimpl: " + yes.getClass());
            }
        }
        switch (no.type()) {
            case 1: {
                False = new double[]{no.getNum()};
                break;
            }
            case 6: {
                False = no.getRow();
                break;
            }
            default: {
                throw H2O.unimpl("row ifelse unimplL " + no.getClass());
            }
        }
        double[] ds = new double[test.length];
        String[] ns = new String[test.length];
        for (int i2 = 0; i2 < test.length; ++i2) {
            ns[i2] = "C" + (i2 + 1);
            ds[i2] = Double.isNaN(test[i2]) ? Double.NaN : (test[i2] == 0.0 ? False[i2] : True[i2]);
        }
        return new ValRow(ds, ns);
    }

    private static class Unevaluated
    extends Val {
        static Unevaluated INSTANCE = new Unevaluated();

        private Unevaluated() {
        }

        @Override
        public int type() {
            return -1;
        }
    }
}

