/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNumList;
import water.rapids.vals.ValFrame;
import water.util.Log;

public class AstScale
extends AstPrimitive {
    private final boolean _in_place;

    private AstScale(boolean inPlace) {
        this._in_place = inPlace;
    }

    public AstScale() {
        this(false);
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "center", "scale"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "scale";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame outputFrame;
        Frame originalFrame = stk.track(asts[1].exec(env)).getFrame();
        Frame numericFrame = new Frame(new Vec[0]);
        for (int i2 = 0; i2 < originalFrame.numCols(); ++i2) {
            Vec v2 = originalFrame.vec(i2);
            if (v2.get_type() != 3) continue;
            numericFrame.add(originalFrame.name(i2), v2);
        }
        if (numericFrame.numCols() == 0) {
            Log.info("Nothing scaled in frame '%s'. There are no numeric columns.");
            return new ValFrame(originalFrame);
        }
        double[] means = AstScale.calcMeans(env, asts[2], numericFrame, originalFrame);
        double[] mults = AstScale.calcMults(env, asts[3], numericFrame, originalFrame);
        Frame workFrame = this._in_place ? numericFrame : numericFrame.deepCopy(null);
        new InPlaceScaleTask(means, mults).doAll(workFrame);
        if (this._in_place) {
            outputFrame = originalFrame;
        } else {
            outputFrame = new Frame(new Vec[0]);
            String[] names = originalFrame.names();
            byte[] types = originalFrame.types();
            for (int i3 = 0; i3 < originalFrame.numCols(); ++i3) {
                if (types[i3] == 3) {
                    outputFrame.add(names[i3], workFrame.vec(names[i3]));
                    continue;
                }
                outputFrame.add(names[i3], originalFrame.vec(i3));
            }
        }
        return new ValFrame(outputFrame);
    }

    static double[] calcMeans(Env env, AstRoot meanSpec, Frame fr, Frame origFr) {
        double[] means;
        int ncols = fr.numCols();
        if (meanSpec instanceof AstNumList) {
            means = AstScale.extractNumericValues(((AstNumList)meanSpec).expand(), fr, origFr);
        } else {
            double d2 = meanSpec.exec(env).getNum();
            if (d2 == 0.0) {
                means = new double[ncols];
            } else if (d2 == 1.0) {
                means = fr.means();
            } else {
                throw new IllegalArgumentException("Only true or false allowed");
            }
        }
        return means;
    }

    static double[] calcMults(Env env, AstRoot multSpec, Frame fr, Frame origFr) {
        double[] mults;
        if (multSpec instanceof AstNumList) {
            mults = AstScale.extractNumericValues(((AstNumList)multSpec).expand(), fr, origFr);
        } else {
            Val v2 = multSpec.exec(env);
            if (v2 instanceof ValFrame) {
                mults = AstScale.extractNumericValues(AstScale.toArray(v2.getFrame().anyVec()), fr, origFr);
            } else {
                double d2 = v2.getNum();
                if (d2 == 0.0) {
                    mults = new double[fr.numCols()];
                    Arrays.fill(mults, 1.0);
                } else if (d2 == 1.0) {
                    mults = fr.mults();
                } else {
                    throw new IllegalArgumentException("Only true or false allowed");
                }
            }
        }
        return mults;
    }

    private static double[] toArray(Vec v2) {
        double[] res = new double[(int)v2.length()];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = v2.at(i2);
        }
        return res;
    }

    private static double[] extractNumericValues(double[] vals, Frame fr, Frame origFr) {
        if (vals.length != origFr.numCols()) {
            throw new IllegalArgumentException("Values must be the same length as is the number of columns of the Frame to scale (fill 0 for non-numeric columns).");
        }
        if (vals.length == fr.numCols()) {
            return vals;
        }
        double[] numVals = new double[fr.numCols()];
        int pos = 0;
        for (int i2 = 0; i2 < origFr.numCols(); ++i2) {
            if (origFr.vec(i2).get_type() != 3) continue;
            numVals[pos++] = vals[i2];
        }
        assert (pos == numVals.length);
        return numVals;
    }

    public static class AstScaleInPlace
    extends AstScale {
        public AstScaleInPlace() {
            super(true);
        }

        @Override
        public String str() {
            return "scale_inplace";
        }
    }

    private static class InPlaceScaleTask
    extends MRTask<InPlaceScaleTask> {
        private final double[] _means;
        private final double[] _mults;

        InPlaceScaleTask(double[] means, double[] mults) {
            this._means = means;
            this._mults = mults;
        }

        @Override
        public void map(Chunk[] cs) {
            for (int i2 = 0; i2 < cs.length; ++i2) {
                for (int row = 0; row < cs[i2]._len; ++row) {
                    cs[i2].set(row, (cs[i2].atd(row) - this._means[i2]) * this._mults[i2]);
                }
            }
        }
    }
}

