/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.Arrays;
import java.util.BitSet;
import water.MRTask;
import water.fvec.C16Chunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Env;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstId;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.vals.ValFrame;

public class AstRowSlice
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "rows"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "rows";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame returningFrame;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        long nrows = fr.numRows();
        if (asts[2] instanceof AstNumList) {
            long[] rows;
            final AstNumList nums = (AstNumList)asts[2];
            if (!nums._isSort && !nums.isEmpty() && nums._bases[0] >= 0.0) {
                throw new IllegalArgumentException("H2O does not currently reorder rows, please sort your row selection first");
            }
            Object object = rows = (Object)(nums._isList || nums.min() < 0.0 ? nums.expand8Sort() : null);
            if (rows != null && rows.length != 0) {
                if (rows[0] >= 0L) {
                    if (rows[rows.length - 1] > nrows) {
                        throw new IllegalArgumentException("Row must be an integer from 0 to " + (nrows - 1L));
                    }
                } else {
                    if (rows[rows.length - 1] >= 0L) {
                        throw new IllegalArgumentException("Cannot mix negative and postive row selection");
                    }
                    BitSet bs = new BitSet((int)nrows);
                    for (long row : rows) {
                        int idx = (int)(-row - 1L);
                        if (idx < 0 || (long)idx >= nrows) continue;
                        bs.set(idx);
                    }
                    rows = new long[(int)nrows - bs.cardinality()];
                    int i2 = bs.nextClearBit(0);
                    int j2 = 0;
                    while ((long)i2 < nrows) {
                        rows[j2++] = i2;
                        i2 = bs.nextClearBit(i2 + 1);
                    }
                }
            }
            final long[] ls = rows;
            returningFrame = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    long max;
                    if (nums.cnt() == 0L) {
                        return;
                    }
                    if (ls != null && ls.length == 0) {
                        return;
                    }
                    long start = cs[0].start();
                    long end = start + (long)cs[0]._len;
                    long min2 = ls == null ? (long)nums.min() : ls[0];
                    long l2 = max = ls == null ? (long)nums.max() - 1L : ls[ls.length - 1];
                    if (max >= start && min2 <= end) {
                        long startOffset = min2 > start ? min2 : start;
                        for (int i2 = (int)(startOffset - start); i2 < cs[0]._len; ++i2) {
                            if ((ls != null || !nums.has(start + (long)i2)) && (ls == null || Arrays.binarySearch(ls, start + (long)i2) < 0)) continue;
                            for (int c2 = 0; c2 < cs.length; ++c2) {
                                if (cs[c2] instanceof CStrChunk) {
                                    ncs[c2].addStr(cs[c2], i2);
                                    continue;
                                }
                                if (cs[c2] instanceof C16Chunk) {
                                    ncs[c2].addUUID(cs[c2], i2);
                                    continue;
                                }
                                if (cs[c2].isNA(i2)) {
                                    ncs[c2].addNA();
                                    continue;
                                }
                                ncs[c2].addNum(cs[c2].atd(i2));
                            }
                        }
                    }
                }
            }.doAll(fr.types(), fr)).outputFrame(fr.names(), fr.domains());
        } else if (asts[2] instanceof AstNum) {
            long[] rows = new long[]{(long)((AstNum)asts[2]).getNum()};
            returningFrame = fr.deepSlice(rows, null);
        } else if (asts[2] instanceof AstExec || asts[2] instanceof AstId) {
            Frame predVec = stk.track(asts[2].exec(env)).getFrame();
            if (predVec.numCols() != 1) {
                throw new IllegalArgumentException("Conditional Row Slicing Expression evaluated to " + predVec.numCols() + " columns.  Must be a boolean Vec.");
            }
            returningFrame = fr.deepSlice(predVec, null);
        } else {
            throw new IllegalArgumentException("Row slicing requires a number-list as the last argument, but found a " + asts[2].getClass());
        }
        return new ValFrame(returningFrame);
    }
}

