/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import java.util.ArrayList;
import java.util.Iterator;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValNums;

public class AstColumnsByType
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "type"};
    }

    @Override
    public String str() {
        return "columnsByType";
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public ValNums apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        DType dtype;
        String type;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        switch (type = stk.track(asts[2].exec(env)).getStr()) {
            case "numeric": {
                dtype = DType.Numeric;
                break;
            }
            case "categorical": {
                dtype = DType.Categorical;
                break;
            }
            case "string": {
                dtype = DType.String;
                break;
            }
            case "time": {
                dtype = DType.Time;
                break;
            }
            case "uuid": {
                dtype = DType.UUID;
                break;
            }
            case "bad": {
                dtype = DType.Bad;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown data type to filter by: " + type);
            }
        }
        Vec[] vecs = fr.vecs();
        ArrayList<Double> idxs = new ArrayList<Double>();
        for (double i2 = 0.0; i2 < (double)fr.numCols(); i2 += 1.0) {
            if (dtype.equals((Object)DType.Numeric) && vecs[(int)i2].isNumeric()) {
                idxs.add(i2);
                continue;
            }
            if (dtype.equals((Object)DType.Categorical) && vecs[(int)i2].isCategorical()) {
                idxs.add(i2);
                continue;
            }
            if (dtype.equals((Object)DType.String) && vecs[(int)i2].isString()) {
                idxs.add(i2);
                continue;
            }
            if (dtype.equals((Object)DType.Time) && vecs[(int)i2].isTime()) {
                idxs.add(i2);
                continue;
            }
            if (dtype.equals((Object)DType.UUID) && vecs[(int)i2].isUUID()) {
                idxs.add(i2);
                continue;
            }
            if (!dtype.equals((Object)DType.Bad) || !vecs[(int)i2].isBad()) continue;
            idxs.add(i2);
        }
        double[] include_cols = new double[idxs.size()];
        int i3 = 0;
        Iterator iterator = idxs.iterator();
        while (iterator.hasNext()) {
            double d2 = (Double)iterator.next();
            include_cols[i3++] = (int)d2;
        }
        return new ValNums(include_cols);
    }

    private static enum DType {
        Numeric,
        Categorical,
        String,
        Time,
        UUID,
        Bad;

    }
}

