/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;
import water.util.VecUtils;

public class AstAsCharacter
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "as.character";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame ary = stk.track(asts[1].exec(env)).getFrame();
        Vec[] nvecs = new Vec[ary.numCols()];
        for (int c2 = 0; c2 < nvecs.length; ++c2) {
            Vec vv = ary.vec(c2);
            try {
                nvecs[c2] = vv.toStringVec();
                continue;
            }
            catch (Exception e2) {
                VecUtils.deleteVecs(nvecs, c2);
                throw e2;
            }
        }
        return new ValFrame(new Frame(ary._names, nvecs));
    }
}

