/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigInteger;
import water.H2O;
import water.Key;
import water.MRTask;
import water.RPC;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.RadixCount;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SplitByMSBLocal;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;

class RadixOrder
extends H2O.H2OCountedCompleter<RadixOrder> {
    private final Frame _DF;
    private final boolean _isLeft;
    private final int[] _whichCols;
    private final int[][] _id_maps;
    final boolean[] _isInt;
    final boolean[] _isCategorical;
    final int[] _shift;
    final int[] _bytesUsed;
    final BigInteger[] _base;
    final int[] _ascending;

    RadixOrder(Frame DF, boolean isLeft, int[] whichCols, int[][] id_maps, int[] ascending) {
        this._DF = DF;
        this._isLeft = isLeft;
        this._whichCols = whichCols;
        this._id_maps = id_maps;
        this._shift = new int[this._whichCols.length];
        this._bytesUsed = new int[this._whichCols.length];
        this._base = new BigInteger[this._whichCols.length];
        this._isInt = new boolean[this._whichCols.length];
        this._isCategorical = new boolean[this._whichCols.length];
        this._ascending = ascending;
    }

    @Override
    public void compute2() {
        long t0 = System.nanoTime();
        this.initBaseShift();
        int keySize = ArrayUtils.sum(this._bytesUsed);
        int batchSize = 0x100000;
        Object[] objectArray = new Object[1];
        long t1 = System.nanoTime();
        objectArray[0] = "Time to use rollup stats to determine biggestBit: " + (double)(t1 - t0) / 1.0E9 + " seconds.";
        Log.debug(objectArray);
        t0 = t1;
        if (this._whichCols.length > 0) {
            new RadixCount(this._isLeft, this._base[0], this._shift[0], this._whichCols[0], this._id_maps, this._ascending[0]).doAll(this._DF.vec(this._whichCols[0]));
        }
        Object[] objectArray2 = new Object[1];
        t1 = System.nanoTime();
        objectArray2[0] = "Time of MSB count MRTask left local on each node (no reduce): " + (double)(t1 - t0) / 1.0E9 + " seconds.";
        Log.debug(objectArray2);
        t0 = t1;
        Key linkTwoMRTask = Key.make();
        if (this._whichCols.length > 0) {
            new SplitByMSBLocal(this._isLeft, this._base, this._shift[0], keySize, batchSize, this._bytesUsed, this._whichCols, linkTwoMRTask, this._id_maps, this._ascending).doAll(this._DF.vecs(this._whichCols));
        }
        Object[] objectArray3 = new Object[1];
        t1 = System.nanoTime();
        objectArray3[0] = "SplitByMSBLocal MRTask (all local per node, no network) took : " + (double)(t1 - t0) / 1.0E9 + " seconds.";
        Log.debug(objectArray3);
        t0 = t1;
        if (this._whichCols.length > 0) {
            new SendSplitMSB(linkTwoMRTask).doAllNodes();
        }
        Object[] objectArray4 = new Object[1];
        t1 = System.nanoTime();
        objectArray4[0] = "SendSplitMSB across all nodes took : " + (double)(t1 - t0) / 1.0E9 + " seconds.";
        Log.debug(objectArray4);
        t0 = t1;
        RPC[] radixOrders = new RPC[256];
        Log.info("Sending SingleThreadRadixOrder async RPC calls ... ");
        for (int i2 = 0; i2 < 256; ++i2) {
            radixOrders[i2] = new RPC<SingleThreadRadixOrder>(SplitByMSBLocal.ownerOfMSB(i2), new SingleThreadRadixOrder(this._DF, this._isLeft, batchSize, keySize, i2)).call();
        }
        Object[] objectArray5 = new Object[1];
        t1 = System.nanoTime();
        objectArray5[0] = "took : " + (double)(t1 - t0) / 1.0E9;
        Log.debug(objectArray5);
        t0 = t1;
        Log.info("Waiting for RPC SingleThreadRadixOrder to finish ... ");
        for (RPC rpc : radixOrders) {
            rpc.get();
        }
        Log.debug("took " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        this.tryComplete();
    }

    private void initBaseShift() {
        for (int i2 = 0; i2 < this._whichCols.length; ++i2) {
            Vec col = this._DF.vec(this._whichCols[i2]);
            BigInteger max = BigInteger.ZERO;
            this._isInt[i2] = col.isCategorical() || col.isInt();
            this._isCategorical[i2] = col.isCategorical();
            if (col.isCategorical()) {
                this._base[i2] = BigInteger.ZERO;
                assert (this._id_maps[i2] != null);
                max = this._isLeft ? BigInteger.valueOf(ArrayUtils.maxValue(this._id_maps[i2])) : BigInteger.valueOf(col.domain().length);
            } else {
                double colMin = col.min();
                double colMax = col.max();
                if (col.isInt()) {
                    GetLongStatsTask glst = GetLongStatsTask.getLongStats(col);
                    long colMini = glst._colMin;
                    long colMaxi = glst._colMax;
                    this._base[i2] = BigInteger.valueOf(Math.min(colMini, colMaxi * (long)this._ascending[i2]));
                    max = BigInteger.valueOf(Math.max(colMaxi, colMini * (long)this._ascending[i2]));
                } else {
                    this._base[i2] = MathUtils.convertDouble2BigInteger(Math.min(col.min(), colMax * (double)this._ascending[i2]));
                    max = MathUtils.convertDouble2BigInteger(Math.max(col.max(), colMin * (double)this._ascending[i2]));
                }
            }
            long chk = this.computeShift(max, i2);
            if (chk == 256L) {
                chk = this.computeShift(max, i2);
            }
            assert (chk <= 255L);
            assert (chk >= 0L);
            this._bytesUsed[i2] = Math.min(8, (this._shift[i2] + 15) / 8);
        }
    }

    private long computeShift(BigInteger max, int i2) {
        int biggestBit = 0;
        int rangeD = max.subtract(this._base[i2]).add(BigInteger.ONE).add(BigInteger.ONE).bitLength();
        int n2 = this._isInt[i2] ? rangeD : (biggestBit = rangeD == 64 ? 64 : rangeD + 1);
        if (biggestBit < 8) {
            Log.warn("biggest bit should be >= 8 otherwise need to dip into next column (TODO)");
        }
        assert (biggestBit >= 1);
        this._shift[i2] = Math.max(8, biggestBit) - 8;
        long MSBwidth = 1L << this._shift[i2];
        BigInteger msbWidth = BigInteger.valueOf(MSBwidth);
        if (this._base[i2].mod(msbWidth).compareTo(BigInteger.ZERO) != 0) {
            BigInteger bigInteger = this._isInt[i2] ? msbWidth.multiply(this._base[i2].divide(msbWidth).add(this._base[i2].signum() < 0 ? BigInteger.valueOf(-1L) : BigInteger.ZERO)) : (this._base[i2] = msbWidth.multiply(this._base[i2].divide(msbWidth)));
            assert (this._base[i2].mod(msbWidth).compareTo(BigInteger.ZERO) == 0);
        }
        return max.subtract(this._base[i2]).add(BigInteger.ONE).shiftRight(this._shift[i2]).intValue();
    }

    private static class SendSplitMSB
    extends MRTask<SendSplitMSB> {
        final Key _linkTwoMRTask;

        SendSplitMSB(Key linkTwoMRTask) {
            this._linkTwoMRTask = linkTwoMRTask;
        }

        @Override
        public void setupLocal() {
            SplitByMSBLocal.MOVESHASH.get(this._linkTwoMRTask).sendSplitMSB();
            SplitByMSBLocal.MOVESHASH.remove(this._linkTwoMRTask);
        }
    }

    private static class GetLongStatsTask
    extends MRTask<GetLongStatsTask> {
        long _colMin = Long.MAX_VALUE;
        long _colMax = Long.MIN_VALUE;

        private GetLongStatsTask() {
        }

        static GetLongStatsTask getLongStats(Vec col) {
            return (GetLongStatsTask)new GetLongStatsTask().doAll(col);
        }

        @Override
        public void map(Chunk c2) {
            for (int i2 = 0; i2 < c2._len; ++i2) {
                if (c2.isNA(i2)) continue;
                long l2 = c2.at8(i2);
                this._colMin = Math.min(this._colMin, l2);
                this._colMax = Math.max(this._colMax, l2);
            }
        }

        @Override
        public void reduce(GetLongStatsTask that) {
            this._colMin = Math.min(this._colMin, that._colMin);
            this._colMax = Math.max(this._colMax, that._colMax);
        }
    }
}

