/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigInteger;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.util.MathUtils;

class RadixCount
extends MRTask<RadixCount> {
    private Long2DArray _counts;
    private final int _shift;
    private final int _col;
    private final BigInteger _base;
    private final boolean _isLeft;
    private final int[][] _id_maps;
    private final int _ascending;

    RadixCount(boolean isLeft, BigInteger base, int shift, int col, int[][] id_maps, int ascending) {
        this._isLeft = isLeft;
        this._base = base;
        this._col = col;
        this._shift = shift;
        this._id_maps = id_maps;
        this._ascending = ascending;
    }

    static Key getKey(boolean isLeft, int col, H2ONode node) {
        return Key.make("__radix_order__MSBNodeCounts_col" + col + "_node" + node.index() + (isLeft ? "_LEFT" : "_RIGHT"));
    }

    @Override
    protected void setupLocal() {
        this._counts = new Long2DArray(this._fr.anyVec().nChunks());
    }

    @Override
    public void map(Chunk chk) {
        block13: {
            boolean isIntVal;
            long[] tmp;
            block12: {
                long[] lArray = new long[256];
                this._counts._val[chk.cidx()] = lArray;
                tmp = lArray;
                boolean bl = isIntVal = chk.vec().isCategorical() || chk.vec().isInt();
                if (!chk.vec().isCategorical()) break block12;
                assert (this._id_maps[0].length > 0);
                assert (this._base.compareTo(BigInteger.ZERO) == 0);
                if (chk.vec().naCnt() == 0L) {
                    for (int r2 = 0; r2 < chk._len; ++r2) {
                        int ctrVal;
                        int n2 = ctrVal = this._isLeft ? BigInteger.valueOf(this._id_maps[0][(int)chk.at8(r2)] + 1).shiftRight(this._shift).intValue() : BigInteger.valueOf((int)chk.at8(r2) + 1).shiftRight(this._shift).intValue();
                        tmp[n2] = tmp[n2] + 1L;
                    }
                } else {
                    for (int r3 = 0; r3 < chk._len; ++r3) {
                        int ctrVal;
                        if (chk.isNA(r3)) {
                            tmp[0] = tmp[0] + 1L;
                            continue;
                        }
                        int n3 = ctrVal = this._isLeft ? BigInteger.valueOf(this._id_maps[0][(int)chk.at8(r3)] + 1).shiftRight(this._shift).intValue() : BigInteger.valueOf((int)chk.at8(r3) + 1).shiftRight(this._shift).intValue();
                        tmp[n3] = tmp[n3] + 1L;
                    }
                }
                break block13;
            }
            if (this._isLeft && chk.vec().isCategorical()) break block13;
            if (chk.vec().naCnt() == 0L) {
                for (int r4 = 0; r4 < chk._len; ++r4) {
                    long ctrVal = isIntVal ? BigInteger.valueOf(chk.at8(r4) * (long)this._ascending).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue() : MathUtils.convertDouble2BigInteger((double)this._ascending * chk.atd(r4)).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue();
                    int n4 = (int)ctrVal;
                    tmp[n4] = tmp[n4] + 1L;
                }
            } else {
                for (int r5 = 0; r5 < chk._len; ++r5) {
                    if (chk.isNA(r5)) {
                        tmp[0] = tmp[0] + 1L;
                        continue;
                    }
                    long ctrVal = isIntVal ? BigInteger.valueOf((long)this._ascending * chk.at8(r5)).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue() : MathUtils.convertDouble2BigInteger((double)this._ascending * chk.atd(r5)).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue();
                    int n5 = (int)ctrVal;
                    tmp[n5] = tmp[n5] + 1L;
                }
            }
        }
    }

    @Override
    protected void closeLocal() {
        DKV.put(RadixCount.getKey(this._isLeft, this._col, H2O.SELF), this._counts, this._fs, true);
    }

    static class Long2DArray
    extends Iced {
        long[][] _val;

        Long2DArray(int len) {
            this._val = new long[len][];
        }
    }
}

