/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import water.DKV;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.MRTask;
import water.RPC;
import water.fvec.C16Chunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.BinaryMerge;
import water.rapids.RadixOrder;
import water.rapids.SingleThreadRadixOrder;
import water.rapids.SortCombine;
import water.rapids.SplitByMSBLocal;
import water.util.Log;

public class Merge {
    public static int ASCENDING = 1;
    public static int DESCENDING = -1;

    public static Frame sort(Frame fr, int col) {
        return Merge.sort(fr, new int[]{col});
    }

    public static Frame sort(Frame fr, int[] cols) {
        int numCol = cols.length;
        int[] ascending = new int[numCol];
        Arrays.fill(ascending, 1);
        return Merge.sort(fr, cols, ascending);
    }

    public static Frame sort(Frame fr, int[] cols, int[] ascending) {
        if (cols.length == 0) {
            return fr;
        }
        for (int col : cols) {
            if (col >= 0 && col < fr.numCols()) continue;
            throw new IllegalArgumentException("Column " + col + " is out of range of " + fr.numCols());
        }
        int[][] id_maps = new int[cols.length][];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            Vec vec = fr.vec(cols[i2]);
            if (!vec.isCategorical()) continue;
            String[] domain = vec.domain();
            id_maps[i2] = new int[domain.length];
            for (int j2 = 0; j2 < domain.length; ++j2) {
                id_maps[i2][j2] = j2;
            }
        }
        return Merge.merge(fr, new Frame(new Vec[0]), cols, new int[0], true, id_maps, ascending, new int[0]);
    }

    public static Frame merge(Frame leftFrame, Frame riteFrame, int[] leftCols, int[] riteCols, boolean allLeft, int[][] id_maps) {
        int[] ascendingR;
        int[] ascendingL;
        if (leftCols != null && leftCols.length > 0) {
            ascendingL = new int[leftCols.length];
            Arrays.fill(ascendingL, 1);
        } else {
            ascendingL = new int[]{};
        }
        if (riteCols != null && riteCols.length > 0) {
            ascendingR = new int[riteCols.length];
            Arrays.fill(ascendingR, 1);
        } else {
            ascendingR = new int[]{};
        }
        return Merge.merge(leftFrame, riteFrame, leftCols, riteCols, allLeft, id_maps, ascendingL, ascendingR);
    }

    public static Frame merge(Frame leftFrame, Frame riteFrame, int[] leftCols, int[] riteCols, boolean allLeft, int[][] id_maps, int[] ascendingL, int[] ascendingR) {
        int j2;
        int leftMSB;
        boolean leftRangeAboveRightMax;
        long leftMSBto;
        boolean riteBaseExceedsleftBase;
        if (allLeft && riteFrame.numRows() == 0L) {
            return Merge.sortOnly(leftFrame, leftCols, id_maps, ascendingL);
        }
        boolean hasRite = riteCols.length > 0;
        boolean naPresent = false;
        if (riteFrame != null) {
            for (int colidx : riteCols) {
                if (riteFrame.vec(colidx).naCnt() <= 0L) continue;
                naPresent = true;
                break;
            }
        }
        Frame rightFrame = naPresent ? ((RemoveNAsTask)new RemoveNAsTask(riteCols).doAll(riteFrame.types(), riteFrame)).outputFrame(riteFrame.names(), riteFrame.domains()) : riteFrame;
        for (int i2 = 0; i2 < id_maps.length; ++i2) {
            if (id_maps[i2] == null) continue;
            assert ((double)id_maps[i2].length >= leftFrame.vec(leftCols[i2]).max() + 1.0) : "Left frame cardinality is higher than right frame!  Switch frames and change merge directions to get around this restriction.";
            if (!hasRite) continue;
            int right_max = (int)rightFrame.vec(riteCols[i2]).max();
            for (int j3 = 0; j3 < id_maps[i2].length; ++j3) {
                assert (id_maps[i2][j3] >= 0);
                if (id_maps[i2][j3] <= right_max) continue;
                id_maps[i2][j3] = -1;
            }
        }
        RadixOrder leftIndex = Merge.createIndex(true, leftFrame, leftCols, id_maps, ascendingL);
        RadixOrder riteIndex = Merge.createIndex(false, rightFrame, riteCols, id_maps, ascendingR);
        boolean leftFrameEmpty = leftFrame.numRows() == 0L;
        boolean riteFrameEmpty = riteFrame.numRows() == 0L;
        Log.info("Making BinaryMerge RPC calls ... ");
        long t0 = System.nanoTime();
        ArrayList<BinaryMerge> bmList = new ArrayList<BinaryMerge>();
        Futures fs = new Futures();
        int leftShift = leftFrameEmpty ? -1 : leftIndex._shift[0];
        BigInteger leftBase = leftFrameEmpty ? BigInteger.ZERO : leftIndex._base[0];
        int riteShift = riteFrameEmpty ? -1 : riteIndex._shift[0];
        BigInteger riteBase = riteFrameEmpty ? BigInteger.ZERO : riteIndex._base[0];
        long leftMSBfrom = riteBase.subtract(leftBase).shiftRight(leftShift).longValue();
        boolean bl = riteFrameEmpty ? false : (riteBaseExceedsleftBase = riteBase.compareTo(leftBase) > 0);
        if (riteBaseExceedsleftBase) {
            assert (leftMSBfrom >= 0L);
            if (leftMSBfrom > 255L) {
                leftMSBfrom = 256L;
            }
            if (allLeft) {
                int leftMSB2 = 0;
                while ((long)leftMSB2 < leftMSBfrom) {
                    BinaryMerge bm = new BinaryMerge(new BinaryMerge.FFSB(leftFrame, leftMSB2, leftShift, leftIndex._bytesUsed, leftIndex._base), new BinaryMerge.FFSB(rightFrame, -1, riteShift, riteIndex._bytesUsed, riteIndex._base), true);
                    bmList.add(bm);
                    fs.add(new RPC<BinaryMerge>(SplitByMSBLocal.ownerOfMSB(leftMSB2), bm).call());
                    ++leftMSB2;
                }
            }
        } else {
            assert (leftMSBfrom <= 0L);
            leftMSBfrom = 0L;
        }
        BigInteger rightS = BigInteger.valueOf(256L << riteShift);
        long l2 = leftMSBto = leftFrameEmpty ? 0L : riteBase.add(rightS).subtract(BigInteger.ONE).subtract(leftBase).shiftRight(leftShift).longValue();
        boolean bl2 = leftIndex._isCategorical[0] ? leftBase.add(BigInteger.valueOf(256L << leftShift)).compareTo(riteBase.add(rightS)) > 0 : (leftRangeAboveRightMax = leftBase.add(BigInteger.valueOf(256L << leftShift)).compareTo(riteBase.add(rightS)) >= 0);
        if (leftRangeAboveRightMax) {
            assert (leftMSBto <= 255L);
            if (leftMSBto < 0L) {
                leftMSBto = -1L;
            }
            if (allLeft) {
                for (leftMSB = (int)leftMSBto + 1; leftMSB <= 255; ++leftMSB) {
                    BinaryMerge bm = new BinaryMerge(new BinaryMerge.FFSB(leftFrame, leftMSB, leftShift, leftIndex._bytesUsed, leftIndex._base), new BinaryMerge.FFSB(rightFrame, -1, riteShift, riteIndex._bytesUsed, riteIndex._base), true);
                    bmList.add(bm);
                    fs.add(new RPC<BinaryMerge>(SplitByMSBLocal.ownerOfMSB(leftMSB), bm).call());
                }
            }
        } else if (!leftFrameEmpty) {
            assert (leftMSBto >= 255L);
            leftMSBto = 255L;
        }
        assert (leftMSBfrom >= 0L);
        assert (leftMSBto <= 255L);
        leftMSB = (int)leftMSBfrom;
        while ((long)leftMSB <= leftMSBto) {
            int rightMSBto;
            long leftFrom = leftFrameEmpty ? 0L : ((long)leftMSB << leftShift) - 1L + leftBase.longValue();
            long leftTo = leftFrameEmpty ? 0L : ((long)leftMSB + 1L << leftShift) - 1L + leftBase.longValue() - 1L;
            long temprightMSB = leftFrom - (riteFrameEmpty ? 0L : riteBase.longValue()) + 1L >> riteShift;
            int rightMSBfrom = temprightMSB < 0L ? 0 : (int)temprightMSB;
            temprightMSB = leftTo - (riteFrameEmpty ? 0L : riteBase.longValue()) + 1L >> riteShift;
            int n2 = rightMSBto = temprightMSB < 0L ? 0 : (int)temprightMSB;
            if (rightMSBfrom < 0) {
                rightMSBfrom = 0;
            }
            assert (rightMSBfrom <= 255);
            if (rightMSBto > 255) {
                rightMSBto = 255;
            }
            assert (rightMSBto >= rightMSBfrom);
            for (int rightMSB = rightMSBfrom; rightMSB <= rightMSBto; ++rightMSB) {
                BinaryMerge bm = new BinaryMerge(new BinaryMerge.FFSB(leftFrame, leftMSB, leftShift, leftIndex._bytesUsed, leftIndex._base), new BinaryMerge.FFSB(rightFrame, rightMSB, riteShift, riteIndex._bytesUsed, riteIndex._base), allLeft);
                bmList.add(bm);
                H2ONode node = SplitByMSBLocal.ownerOfMSB(rightMSB);
                fs.add(new RPC<BinaryMerge>(node, bm).call());
            }
            ++leftMSB;
        }
        Log.debug("took: " + String.format("%.3f", (double)(System.nanoTime() - t0) / 1.0E9) + " seconds.");
        t0 = System.nanoTime();
        Log.info("Sending BinaryMerge async RPC calls in a queue ... ");
        fs.blockForPending();
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        Log.debug("Removing DKV keys of left and right index.  ... ");
        t0 = System.nanoTime();
        for (int msb = 0; msb < 256; ++msb) {
            for (int isLeft = 0; isLeft < 2; ++isLeft) {
                Key k2 = SingleThreadRadixOrder.getSortedOXHeaderKey(isLeft != 0, msb);
                SingleThreadRadixOrder.OXHeader oxheader = (SingleThreadRadixOrder.OXHeader)DKV.getGet(k2);
                DKV.remove(k2);
                if (oxheader == null) continue;
                for (int b2 = 0; b2 < oxheader._nBatch; ++b2) {
                    k2 = SplitByMSBLocal.getSortedOXbatchKey(isLeft != 0, msb, b2);
                    DKV.remove(k2);
                }
            }
        }
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        Log.info("Allocating and populating chunk info (e.g. size and batch number) ...");
        t0 = System.nanoTime();
        long ansN = 0L;
        int numChunks = 0;
        for (BinaryMerge thisbm : bmList) {
            if (thisbm._numRowsInResult <= 0L) continue;
            numChunks += thisbm._chunkSizes.length;
            ansN += thisbm._numRowsInResult;
        }
        long[] chunkSizes = new long[numChunks];
        int[] chunkLeftMSB = new int[numChunks];
        int[] chunkRightMSB = new int[numChunks];
        int[] chunkBatch = new int[numChunks];
        int k3 = 0;
        for (BinaryMerge thisbm : bmList) {
            if (thisbm._numRowsInResult == 0L) continue;
            int[] thisChunkSizes = thisbm._chunkSizes;
            int j4 = 0;
            while (j4 < thisChunkSizes.length) {
                chunkSizes[k3] = thisChunkSizes[j4];
                chunkLeftMSB[k3] = thisbm._leftSB._msb;
                chunkRightMSB[k3] = thisbm._riteSB._msb;
                chunkBatch[k3] = j4++;
                ++k3;
            }
        }
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        Log.info("Allocating and populated espc ...");
        t0 = System.nanoTime();
        long[] espc = new long[chunkSizes.length + 1];
        int i3 = 0;
        long sum = 0L;
        for (long s2 : chunkSizes) {
            espc[i3++] = sum;
            sum += s2;
        }
        espc[espc.length - 1] = sum;
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        assert (sum == ansN);
        Log.info("Allocating dummy vecs/chunks of the final frame ...");
        t0 = System.nanoTime();
        int numJoinCols = hasRite ? leftIndex._bytesUsed.length : 0;
        int numLeftCols = leftFrame.numCols();
        int numColsInResult = numLeftCols + rightFrame.numCols() - numJoinCols;
        byte[] types = new byte[numColsInResult];
        String[][] doms = new String[numColsInResult][];
        String[] names = new String[numColsInResult];
        for (j2 = 0; j2 < numLeftCols; ++j2) {
            types[j2] = leftFrame.vec(j2).get_type();
            doms[j2] = leftFrame.domains()[j2];
            names[j2] = leftFrame.names()[j2];
        }
        for (j2 = 0; j2 < rightFrame.numCols() - numJoinCols; ++j2) {
            types[numLeftCols + j2] = rightFrame.vec(j2 + numJoinCols).get_type();
            doms[numLeftCols + j2] = rightFrame.domains()[j2 + numJoinCols];
            names[numLeftCols + j2] = rightFrame.names()[j2 + numJoinCols];
        }
        Key<Vec> key = Vec.newKey();
        Vec[] vecs = new Vec(key, Vec.ESPC.rowLayout(key, espc)).makeCons(numColsInResult, 0L, doms, types);
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        Log.info("Finally stitch together by overwriting dummies ...");
        t0 = System.nanoTime();
        Frame fr = new Frame(names, vecs);
        ChunkStitcher ff = new ChunkStitcher(chunkSizes, chunkLeftMSB, chunkRightMSB, chunkBatch);
        ff.doAll(fr);
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds");
        return fr;
    }

    public static List<SortCombine> gatherSameMSBRows(Frame leftFrame) {
        long t0 = System.nanoTime();
        ArrayList<SortCombine> bmList = new ArrayList<SortCombine>();
        Futures fs = new Futures();
        for (int leftMSB = 0; leftMSB <= 255; ++leftMSB) {
            SingleThreadRadixOrder.OXHeader leftSortedOXHeader = (SingleThreadRadixOrder.OXHeader)DKV.getGet(SingleThreadRadixOrder.getSortedOXHeaderKey(true, leftMSB));
            if (leftSortedOXHeader == null) continue;
            SortCombine bm = new SortCombine(new SortCombine.FFSB(leftFrame, leftMSB), leftSortedOXHeader);
            bmList.add(bm);
            fs.add(new RPC<SortCombine>(SplitByMSBLocal.ownerOfMSB(leftMSB), bm).call());
        }
        Log.debug("took: " + String.format("%.3f", (double)(System.nanoTime() - t0) / 1.0E9) + " seconds.");
        Log.debug("Removing DKV keys of left index.  ... ");
        t0 = System.nanoTime();
        Log.info("Sending BinaryMerge async RPC calls in a queue ... ");
        fs.blockForPending();
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        t0 = System.nanoTime();
        for (int msb = 0; msb < 256; ++msb) {
            for (int isLeft = 0; isLeft < 2; ++isLeft) {
                Key k2 = SingleThreadRadixOrder.getSortedOXHeaderKey(isLeft != 0, msb);
                SingleThreadRadixOrder.OXHeader oxheader = (SingleThreadRadixOrder.OXHeader)DKV.getGet(k2);
                DKV.remove(k2);
                if (oxheader == null) continue;
                for (int b2 = 0; b2 < oxheader._nBatch; ++b2) {
                    k2 = SplitByMSBLocal.getSortedOXbatchKey(isLeft != 0, msb, b2);
                    DKV.remove(k2);
                }
            }
        }
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        return bmList;
    }

    public static long allocateChunk(List<SortCombine> bmList, long[] chunkSizes, int[] chunkLeftMSB, int[] chunkRightMSB, int[] chunkBatch) {
        Log.info("Allocating and populating chunk info (e.g. size and batch number) ...");
        Long t0 = System.nanoTime();
        long ansN = 0L;
        int numChunks = 0;
        for (SortCombine thisbm : bmList) {
            if (thisbm._numRowsInResult <= 0L) continue;
            numChunks += thisbm._chunkSizes.length;
            ansN += thisbm._numRowsInResult;
        }
        chunkSizes = new long[numChunks];
        chunkLeftMSB = new int[numChunks];
        chunkRightMSB = new int[numChunks];
        Arrays.fill(chunkRightMSB, -1);
        chunkBatch = new int[numChunks];
        int k2 = 0;
        for (SortCombine thisbm : bmList) {
            if (thisbm._numRowsInResult == 0L) continue;
            int[] thisChunkSizes = thisbm._chunkSizes;
            int j2 = 0;
            while (j2 < thisChunkSizes.length) {
                chunkSizes[k2] = thisChunkSizes[j2];
                chunkLeftMSB[k2] = thisbm._leftSB._msb;
                chunkBatch[k2] = j2++;
                ++k2;
            }
        }
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        return ansN;
    }

    public static Frame allocatePopulateChunk(List<SortCombine> bmList, Frame leftFrame, long ansN, long[] chunkSizes, int[] chunkLeftMSB, int[] chunkRightMSB, int[] chunkBatch) {
        int numLeftCols;
        Log.info("Allocating and populated espc ...");
        long t0 = System.nanoTime();
        long[] espc = new long[chunkSizes.length + 1];
        int i2 = 0;
        long sum = 0L;
        for (long s2 : chunkSizes) {
            espc[i2++] = sum;
            sum += s2;
        }
        espc[espc.length - 1] = sum;
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds");
        assert (sum == ansN);
        Log.info("Allocating dummy vecs/chunks of the final frame ...");
        t0 = System.nanoTime();
        int numColsInResult = numLeftCols = leftFrame.numCols();
        byte[] types = new byte[numColsInResult];
        String[][] doms = new String[numColsInResult][];
        String[] names = new String[numColsInResult];
        for (int j2 = 0; j2 < numLeftCols; ++j2) {
            types[j2] = leftFrame.vec(j2).get_type();
            doms[j2] = leftFrame.domains()[j2];
            names[j2] = leftFrame.names()[j2];
        }
        Key<Vec> key = Vec.newKey();
        Vec[] vecs = new Vec(key, Vec.ESPC.rowLayout(key, espc)).makeCons(numColsInResult, 0L, doms, types);
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds");
        Log.info("Finally stitch together by overwriting dummies ...");
        t0 = System.nanoTime();
        Frame fr = new Frame(names, vecs);
        ChunkStitcher ff = new ChunkStitcher(chunkSizes, chunkLeftMSB, chunkRightMSB, chunkBatch);
        ff.doAll(fr);
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        return fr;
    }

    public static Frame sortOnly(Frame leftFrame, int[] leftCols, int[][] id_maps, int[] ascendingL) {
        Merge.createIndex(true, leftFrame, leftCols, id_maps, ascendingL);
        Log.info("Making BinaryMerge RPC calls ... ");
        List<SortCombine> bmList = Merge.gatherSameMSBRows(leftFrame);
        Log.info("Allocating and populating chunk info (e.g. size and batch number) ...");
        Long t0 = System.nanoTime();
        long ansN = 0L;
        int numChunks = 0;
        for (SortCombine thisbm : bmList) {
            if (thisbm._numRowsInResult <= 0L) continue;
            numChunks += thisbm._chunkSizes.length;
            ansN += thisbm._numRowsInResult;
        }
        long[] chunkSizes = new long[numChunks];
        int[] chunkLeftMSB = new int[numChunks];
        int[] chunkRightMSB = new int[numChunks];
        Arrays.fill(chunkRightMSB, -1);
        int[] chunkBatch = new int[numChunks];
        int k2 = 0;
        for (SortCombine thisbm : bmList) {
            if (thisbm._numRowsInResult == 0L) continue;
            int[] thisChunkSizes = thisbm._chunkSizes;
            int j2 = 0;
            while (j2 < thisChunkSizes.length) {
                chunkSizes[k2] = thisChunkSizes[j2];
                chunkLeftMSB[k2] = thisbm._leftSB._msb;
                chunkBatch[k2] = j2++;
                ++k2;
            }
        }
        Log.debug("took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds.");
        long finalRowNumber = Merge.allocateChunk(bmList, chunkSizes, chunkLeftMSB, chunkRightMSB, chunkBatch);
        Log.info("Populate chunks and form final sorted frame ...");
        return Merge.allocatePopulateChunk(bmList, leftFrame, finalRowNumber, chunkSizes, chunkLeftMSB, chunkRightMSB, chunkBatch);
    }

    private static RadixOrder createIndex(boolean isLeft, Frame fr, int[] cols, int[][] id_maps, int[] ascending) {
        Log.info("Creating " + (isLeft ? "left" : "right") + " index ...");
        long t0 = System.nanoTime();
        RadixOrder idxTask = new RadixOrder(fr, isLeft, cols, id_maps, ascending);
        H2O.submitTask(idxTask);
        idxTask.join();
        Log.debug("*** Creating " + (isLeft ? "left" : "right") + " index took: " + (double)(System.nanoTime() - t0) / 1.0E9 + " seconds ***");
        return idxTask;
    }

    static class ChunkStitcher
    extends MRTask<ChunkStitcher> {
        final long[] _chunkSizes;
        final int[] _chunkLeftMSB;
        final int[] _chunkRightMSB;
        final int[] _chunkBatch;

        ChunkStitcher(long[] chunkSizes, int[] chunkLeftMSB, int[] chunkRightMSB, int[] chunkBatch) {
            this._chunkSizes = chunkSizes;
            this._chunkLeftMSB = chunkLeftMSB;
            this._chunkRightMSB = chunkRightMSB;
            this._chunkBatch = chunkBatch;
        }

        @Override
        public void map(Chunk[] cs) {
            int chkIdx = cs[0].cidx();
            Futures fs = new Futures();
            for (int i2 = 0; i2 < cs.length; ++i2) {
                Key destKey = cs[i2].vec().chunkKey(chkIdx);
                assert ((long)cs[i2].len() == this._chunkSizes[chkIdx]);
                Key k2 = BinaryMerge.getKeyForMSBComboPerCol(this._chunkLeftMSB[chkIdx], this._chunkRightMSB[chkIdx], i2, this._chunkBatch[chkIdx]);
                Chunk ck = (Chunk)DKV.getGet(k2);
                DKV.put(destKey, ck, fs, true);
                DKV.remove(k2);
            }
            fs.blockForPending();
        }
    }

    public static class RemoveNAsTask
    extends MRTask<RemoveNAsTask> {
        private final int[] _columns;

        public RemoveNAsTask(int ... _columns) {
            this._columns = _columns;
        }

        private void copyRow(int row, Chunk[] cs, NewChunk[] ncs) {
            for (int i2 = 0; i2 < cs.length; ++i2) {
                if (cs[i2] instanceof CStrChunk) {
                    ncs[i2].addStr(cs[i2], row);
                    continue;
                }
                if (cs[i2] instanceof C16Chunk) {
                    ncs[i2].addUUID(cs[i2], row);
                    continue;
                }
                if (cs[i2].hasFloat()) {
                    ncs[i2].addNum(cs[i2].atd(row));
                    continue;
                }
                ncs[i2].addNum(cs[i2].at8(row), 0);
            }
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            boolean noNA = true;
            for (int row = 0; row < cs[0]._len; ++row) {
                noNA = true;
                for (int col : this._columns) {
                    if (!cs[col].isNA(row)) continue;
                    noNA = false;
                    break;
                }
                if (!noNA) continue;
                this.copyRow(row, cs, ncs);
            }
        }
    }
}

