/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Value;
import water.api.FSIOException;
import water.fvec.NFSFileVec;
import water.persist.Persist;
import water.util.Log;

public final class PersistFS
extends Persist {
    final File _root;
    final File _dir;

    PersistFS(File root) {
        this._root = root;
        this._dir = new File(root, "ice" + H2O.API_PORT);
        root.mkdirs();
        if (!(root.isDirectory() && root.canRead() && root.canWrite())) {
            H2O.die("ice_root not a read/writable directory");
        }
    }

    @Override
    public void cleanUp() {
        PersistFS.deleteRecursive(this._dir);
    }

    private static void deleteRecursive(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isDirectory()) {
            for (File f2 : path.listFiles()) {
                PersistFS.deleteRecursive(f2);
            }
        }
        path.delete();
    }

    public File getFile(Value v2) {
        return new File(this._dir, PersistFS.getIceName(v2));
    }

    @Override
    public byte[] load(Value v2) throws IOException {
        File f2 = this.getFile(v2);
        if (f2.length() < (long)v2._max) {
            assert (!v2.isPersisted()) : f2.length() + " " + v2._max + " " + v2._key;
            return null;
        }
        try (FileInputStream s2 = new FileInputStream(f2);){
            AutoBuffer ab = new AutoBuffer(s2.getChannel(), true, 1);
            byte[] b2 = ab.getA1(v2._max);
            ab.close();
            byte[] byArray = b2;
            return byArray;
        }
    }

    @Override
    public void store(Value v2) throws IOException {
        assert (!v2.isPersisted());
        File dirs = new File(this._dir, PersistFS.getIceDirectory(v2._key));
        if (!dirs.mkdirs() && !dirs.exists()) {
            throw new IOException("mkdirs failed making " + dirs);
        }
        try (FileOutputStream s2 = new FileOutputStream(this.getFile(v2));){
            byte[] m4 = v2.memOrLoad();
            if (m4 != null && m4.length != v2._max) {
                Log.warn("Value size mismatch? " + v2._key + " byte[].len=" + m4.length + " v._max=" + v2._max);
                v2._max = m4.length;
            }
            new AutoBuffer(s2.getChannel(), false, 1).putA1(m4, m4.length).close();
        }
        catch (AutoBuffer.AutoBufferException abe) {
            throw abe._ioe;
        }
    }

    @Override
    public boolean delete(String path) {
        return new File(URI.create(path)).delete();
    }

    @Override
    public void delete(Value v2) {
        this.getFile(v2).delete();
        new File(this._dir, PersistFS.getIceDirectory(v2._key)).delete();
    }

    @Override
    public long getUsableSpace() {
        return this._root.getUsableSpace();
    }

    @Override
    public long getTotalSpace() {
        return this._root.getTotalSpace();
    }

    @Override
    public Key uriToKey(URI uri) {
        return NFSFileVec.make((File)new File((String)uri.toString()))._key;
    }

    public ArrayList<String> calcTypeaheadMatches(String src, int limit) {
        assert (false);
        return new ArrayList<String>();
    }

    @Override
    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        assert (false);
    }

    @Override
    public OutputStream create(String path, boolean overwrite) {
        boolean windowsPath = path.matches("^[a-zA-Z]:.*$");
        File f2 = windowsPath ? new File(path) : new File(URI.create(path));
        if (f2.exists() && !overwrite) {
            throw new FSIOException(path, "File already exists");
        }
        try {
            if (!f2.getParentFile().exists()) {
                f2.getParentFile().mkdirs();
            }
            return new FileOutputStream(f2, false);
        }
        catch (IOException e2) {
            throw new FSIOException(path, e2);
        }
    }

    @Override
    public Persist.PersistEntry[] list(String path) {
        File f2 = new File(URI.create(path));
        if (f2.isFile()) {
            return new Persist.PersistEntry[]{this.getPersistEntry(f2)};
        }
        if (f2.isDirectory()) {
            File[] files = f2.listFiles();
            Persist.PersistEntry[] entries = new Persist.PersistEntry[files.length];
            for (int i2 = 0; i2 < files.length; ++i2) {
                entries[i2] = this.getPersistEntry(files[i2]);
            }
            return entries;
        }
        throw H2O.unimpl();
    }

    @Override
    public InputStream open(String path) {
        try {
            File f2 = new File(URI.create(path));
            return new FileInputStream(f2);
        }
        catch (FileNotFoundException e2) {
            throw new FSIOException(path, "File not found");
        }
        catch (Exception e3) {
            throw new FSIOException(path, e3);
        }
    }

    @Override
    public boolean mkdirs(String path) {
        return new File(URI.create(path)).mkdirs();
    }

    @Override
    public boolean exists(String path) {
        return new File(URI.create(path)).exists();
    }

    @Override
    public String getParent(String path) {
        return new File(URI.create(path)).getParentFile().toURI().toString();
    }

    @Override
    public boolean isDirectory(String path) {
        return new File(URI.create(path)).isDirectory();
    }

    private Persist.PersistEntry getPersistEntry(File f2) {
        return new Persist.PersistEntry(f2.getName(), f2.length(), f2.lastModified());
    }
}

