/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet.ext;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.parquet.io.api.Binary;

public class DecimalUtils {
    public static BigDecimal binaryToDecimal(Binary value, int precision, int scale) {
        if (precision <= 18) {
            ByteBuffer buffer = value.toByteBuffer();
            byte[] bytes = buffer.array();
            int start = buffer.arrayOffset() + buffer.position();
            int end = buffer.arrayOffset() + buffer.limit();
            long unscaled = 0L;
            for (int i2 = start; i2 < end; ++i2) {
                unscaled = unscaled << 8 | (long)(bytes[i2] & 0xFF);
            }
            int bits = 8 * (end - start);
            long unscaledNew = unscaled << 64 - bits >> 64 - bits;
            if ((double)unscaledNew <= -Math.pow(10.0, 18.0) || (double)unscaledNew >= Math.pow(10.0, 18.0)) {
                return new BigDecimal(unscaledNew);
            }
            return BigDecimal.valueOf((double)unscaledNew / Math.pow(10.0, scale));
        }
        return new BigDecimal(new BigInteger(value.getBytes()), scale);
    }
}

