/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import water.H2O;
import water.fvec.Vec;
import water.parser.ParseWriter;
import water.parser.parquet.ChunkReadSupport;
import water.parser.parquet.VecReaderEnv;
import water.parser.parquet.WriterDelegate;
import water.util.Log;

public class VecParquetReader
implements Closeable {
    private static ParquetMetadataConverter converter = new ParquetMetadataConverter();
    private final Vec vec;
    private final ParquetMetadata metadata;
    private final WriterDelegate writer;
    private final byte[] chunkSchema;
    private ParquetReader<Long> reader;
    private boolean[] _keepColumns;

    public VecParquetReader(Vec vec, ParquetMetadata metadata, ParseWriter writer, byte[] chunkSchema, boolean[] keepcolumns, int parseColumnNumber) {
        this(vec, metadata, new WriterDelegate(writer, parseColumnNumber), chunkSchema, keepcolumns);
    }

    VecParquetReader(Vec vec, ParquetMetadata metadata, WriterDelegate writer, byte[] chunkSchema, boolean[] keepcolumns) {
        this.vec = vec;
        this.metadata = metadata;
        this.writer = writer;
        this.chunkSchema = chunkSchema;
        this._keepColumns = keepcolumns;
    }

    public Long read() throws IOException {
        if (this.reader == null) {
            this.initReader();
        }
        assert (this.reader != null);
        return (Long)this.reader.read();
    }

    private void initReader() throws IOException {
        assert (this.reader == null);
        VecReaderEnv env = VecReaderEnv.make(this.vec);
        ChunkReadSupport crSupport = new ChunkReadSupport(this.writer, this.chunkSchema, this._keepColumns);
        ParquetReader.Builder prBuilder = ParquetReader.builder((ReadSupport)crSupport, (Path)env.getPath()).withConf(env.getConf()).withFilter(new FilterCompat.Filter(){

            public <R> R accept(FilterCompat.Visitor<R> visitor) {
                if (visitor instanceof RowGroupFilter) {
                    return (R)VecParquetReader.this.metadata.getBlocks();
                }
                return (R)visitor.visit((FilterCompat.NoOpFilter)FilterCompat.NOOP);
            }
        });
        this.reader = prBuilder.build();
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFooterAsBytes(Vec vec) {
        byte[] byArray;
        FSDataInputStream f2 = null;
        try {
            f2 = (FSDataInputStream)H2O.getPM().openSeekable(vec);
            byArray = VecParquetReader.readFooterAsBytes(vec.length(), f2);
        }
        catch (IOException e3) {
            try {
                throw new RuntimeException("Failed to read Parquet metadata", e3);
            }
            catch (Throwable throwable) {
                try {
                    if (f2 == null) throw throwable;
                    f2.close();
                    throw throwable;
                }
                catch (Exception e4) {
                    Log.warn("Failed to close Vec data input stream", e4);
                }
                throw throwable;
            }
        }
        try {
            if (f2 == null) return byArray;
            f2.close();
            return byArray;
        }
        catch (Exception e2) {
            Log.warn("Failed to close Vec data input stream", e2);
        }
        return byArray;
    }

    static byte[] readFooterAsBytes(long length, FSDataInputStream f2) throws IOException {
        int FOOTER_LENGTH_SIZE = 4;
        if (length < (long)(ParquetFileWriter.MAGIC.length + 4 + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException("Vec doesn't represent a Parquet data (too short)");
        }
        long footerLengthIndex = length - 4L - (long)ParquetFileWriter.MAGIC.length;
        f2.seek(footerLengthIndex);
        int footerLength = BytesUtils.readIntLittleEndian((InputStream)f2);
        byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
        f2.readFully(magic);
        if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
            throw new RuntimeException("Vec is not a Parquet file. expected magic number at tail " + Arrays.toString(ParquetFileWriter.MAGIC) + " but found " + Arrays.toString(magic));
        }
        long footerIndex = footerLengthIndex - (long)footerLength;
        if (footerIndex < (long)ParquetFileWriter.MAGIC.length || footerIndex >= footerLengthIndex) {
            throw new RuntimeException("corrupted file: the footer index is not within the Vec");
        }
        f2.seek(footerIndex);
        byte[] metadataBytes = new byte[footerLength];
        f2.readFully(metadataBytes);
        return metadataBytes;
    }

    public static ParquetMetadata readFooter(byte[] metadataBytes) {
        return VecParquetReader.readFooter(metadataBytes, ParquetMetadataConverter.NO_FILTER);
    }

    public static ParquetMetadata readFooter(byte[] metadataBytes, ParquetMetadataConverter.MetadataFilter filter) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(metadataBytes);
            return converter.readParquetMetadata((InputStream)bis, filter);
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to read Parquet metadata", e2);
        }
    }
}

