/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.Arrays;
import water.Futures;
import water.Job;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.FVecParseWriter;

public class SVMLightFVecParseWriter
extends FVecParseWriter {
    protected final Vec.VectorGroup _vg;
    int _vecIdStart;

    public SVMLightFVecParseWriter(Vec.VectorGroup vg, int vecIdStart, int cidx, int chunkSize, AppendableVec[] avs, int[] parse_columns_indices, Key<Job> jobKey) {
        super(vg, cidx, null, null, chunkSize, avs, parse_columns_indices, jobKey);
        this._vg = vg;
        this._vecIdStart = vecIdStart;
        int numParseCols = parse_columns_indices.length;
        this._nvs = new NewChunk[numParseCols];
        for (int i2 = 0; i2 < numParseCols; ++i2) {
            this._nvs[i2] = new NewChunk((Vec)this._vecs[this._parse_columns_indices[i2]], this._cidx, true);
        }
        this._col = 0;
    }

    @Override
    public void addNumCol(int colIdx, long number, int exp) {
        assert (colIdx >= this._col);
        if (colIdx >= this._vecs.length) {
            this.addColumns(colIdx + 1);
        }
        this._nvs[colIdx].addZeros((int)this._nLines - this._nvs[colIdx]._len);
        this._nvs[colIdx].addNum(number, exp);
        this._col = colIdx + 1;
    }

    @Override
    public void newLine() {
        ++this._nLines;
        this._col = 0;
    }

    @Override
    public void addStrCol(int idx, BufferedString str) {
        this.addInvalidCol(idx);
    }

    @Override
    public boolean isString(int idx) {
        return false;
    }

    @Override
    public FVecParseWriter close(Futures fs) {
        if (this._nvs != null) {
            for (NewChunk nc : this._nvs) {
                nc.addZeros((int)this._nLines - nc._len);
                assert ((long)nc._len == this._nLines) : "incompatible number of lines after parsing chunk, " + this._nLines + " != " + nc._len;
            }
        }
        this._nCols = this._nvs == null ? 0 : this._nvs.length;
        return super.close(fs);
    }

    private void addColumns(int newColCnt) {
        int oldColCnt = this._vecs.length;
        if (newColCnt > oldColCnt) {
            this._nvs = Arrays.copyOf(this._nvs, newColCnt);
            this._vecs = Arrays.copyOf(this._vecs, newColCnt);
            for (int i2 = oldColCnt; i2 < newColCnt; ++i2) {
                this._vecs[i2] = new AppendableVec(this._vg.vecKey(i2 + this._vecIdStart), this._vecs[0]._tmp_espc, 3, this._vecs[0]._chunkOff);
                this._nvs[i2] = new NewChunk((Vec)this._vecs[i2], this._cidx, true);
            }
            this._nCols = newColCnt;
        }
    }
}

