/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.UUID;
import water.fvec.C16Chunk;
import water.parser.BufferedString;

public class ParseUUID {
    public static boolean isUUID(BufferedString str) {
        int old = str.getOffset();
        ParseUUID.attemptUUIDParseLow(str);
        ParseUUID.attemptUUIDParseHigh(str);
        boolean res = str.getOffset() != -1;
        str.setOff(old);
        return res;
    }

    public static UUID attemptUUIDParse(BufferedString str) {
        Long lo = ParseUUID.attemptUUIDParseLow(str);
        Long hi = ParseUUID.attemptUUIDParseHigh(str);
        return str.getOffset() == -1 ? null : ParseUUID.buildUUID(lo, hi);
    }

    private static UUID buildUUID(Long lo, Long hi) {
        return lo == null || hi == null || C16Chunk.isNA(lo, hi) ? null : new UUID(hi, lo);
    }

    private static Long attemptUUIDParseLow(BufferedString str) {
        byte[] buf = str.getBuffer();
        int i2 = str.getOffset();
        if (i2 + 36 > buf.length) {
            return ParseUUID.markBad(str);
        }
        long lo = 0L;
        lo = ParseUUID.get2(lo, buf, (i2 += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i2 += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i2 += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i2 += 2) - 2);
        if (buf[i2++] != 45) {
            return ParseUUID.markBad(str);
        }
        lo = ParseUUID.get2(lo, buf, (i2 += 2) - 2);
        lo = ParseUUID.get2(lo, buf, (i2 += 2) - 2);
        if (buf[i2++] != 45) {
            return ParseUUID.markBad(str);
        }
        lo = ParseUUID.get2(lo, buf, (i2 += 2) - 2);
        return ParseUUID.attemptUUIDParseEnd(str, lo, buf, i2);
    }

    public static Long attemptUUIDParseHigh(BufferedString str) {
        byte[] buf = str.getBuffer();
        int i2 = str.getOffset();
        if (i2 == -1) {
            return ParseUUID.markBad(str);
        }
        long hi = 0L;
        if (buf[i2++] != 45) {
            return ParseUUID.markBad(str);
        }
        hi = ParseUUID.get2(hi, buf, (i2 += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i2 += 2) - 2);
        if (buf[i2++] != 45) {
            return ParseUUID.markBad(str);
        }
        hi = ParseUUID.get2(hi, buf, (i2 += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i2 += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i2 += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i2 += 2) - 2);
        hi = ParseUUID.get2(hi, buf, (i2 += 2) - 2);
        return ParseUUID.attemptUUIDParseEnd(str, hi, buf, i2);
    }

    private static Long attemptUUIDParseEnd(BufferedString str, long lo, byte[] buf, int i2) {
        if (lo == Long.MIN_VALUE) {
            return ParseUUID.markBad(str);
        }
        str.setOff(i2 + 2);
        if (lo == 0x80000000000000L && buf[i2] == 48 && buf[i2 + 1] == 48) {
            return Long.MIN_VALUE;
        }
        return (lo = ParseUUID.get2(lo, buf, i2)) == Long.MIN_VALUE || i2 + 2 < buf.length && ParseUUID.hdigit(0L, buf[i2 + 2]) != Long.MIN_VALUE ? null : Long.valueOf(lo);
    }

    private static long get2(long x2, byte[] buf, int i2) {
        if (x2 == Long.MIN_VALUE) {
            return x2;
        }
        x2 = ParseUUID.hdigit(x2, buf[i2++]);
        x2 = ParseUUID.hdigit(x2, buf[i2++]);
        return x2;
    }

    private static long hdigit(long x2, byte b2) {
        if (x2 == Long.MIN_VALUE) {
            return Long.MIN_VALUE;
        }
        if (b2 >= 48 && b2 <= 57) {
            return (x2 << 4) + (long)b2 - 48L;
        }
        if (b2 >= 65 && b2 <= 70) {
            return (x2 << 4) + (long)b2 - 65L + 10L;
        }
        if (b2 >= 97 && b2 <= 102) {
            return (x2 << 4) + (long)b2 - 97L + 10L;
        }
        return Long.MIN_VALUE;
    }

    private static Long markBad(BufferedString str) {
        str.setOff(-1);
        return null;
    }
}

