/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import water.DKV;
import water.H2O;
import water.H2ORuntime;
import water.Iced;
import water.Key;
import water.MRTask;
import water.api.schemas3.ParseSetupV3;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.ByteVec;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.UploadFileVec;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.CsvParser;
import water.parser.DecryptionTool;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseTime;
import water.parser.ParseUUID;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.ParserProvider;
import water.parser.ParserService;
import water.parser.PreviewParseWriter;
import water.parser.ZipUtil;
import water.util.ArrayUtils;
import water.util.FileUtils;
import water.util.Log;
import water.util.StringUtils;

public class ParseSetup
extends Iced {
    public static final byte GUESS_SEP = -1;
    public static final int NO_HEADER = -1;
    public static final int GUESS_HEADER = 0;
    public static final int HAS_HEADER = 1;
    public static final int GUESS_COL_CNT = -1;
    public static final byte DEFAULT_ESCAPE_CHAR = 0;
    ParserInfo _parse_type;
    byte _separator;
    boolean _single_quotes;
    int _check_header;
    int _number_columns;
    String[] _column_names;
    byte[] _column_types;
    int[] _skipped_columns;
    String[][] _domains;
    String[][] _na_strings;
    String[][] _data;
    int[] _parse_columns_indices;
    byte[] _nonDataLineMarkers;
    String[] _synthetic_column_names;
    String[][] _synthetic_column_values;
    byte _synthetic_column_type = (byte)2;
    byte _escapechar = 0;
    String[] _fileNames = new String[]{"unknown"};
    public boolean disableParallelParse;
    Key<DecryptionTool> _decrypt_tool;
    private ParseWriter.ParseErr[] _errs;
    public int _chunk_size = 0x400000;
    PreviewParseWriter _column_previews = null;

    public void setFileName(String name) {
        this._fileNames[0] = name;
    }

    public final ParseWriter.ParseErr[] errs() {
        return this._errs;
    }

    public void addErrs(ParseWriter.ParseErr ... errs) {
        this._errs = ArrayUtils.append(this._errs, errs);
    }

    public ParseSetup(ParseSetup ps) {
        this(ps._parse_type, ps._separator, ps._single_quotes, ps._check_header, ps._number_columns, ps._column_names, ps._column_types, ps._domains, ps._na_strings, ps._data, new ParseWriter.ParseErr[0], ps._chunk_size, ps._decrypt_tool, ps._skipped_columns, ps._nonDataLineMarkers, ps._escapechar);
    }

    public static ParseSetup makeSVMLightSetup() {
        return new ParseSetup(DefaultParserProviders.SVMLight_INFO, -1, false, -1, 1, null, new byte[]{3}, (String[][])null, (String[][])null, (String[][])null, new ParseWriter.ParseErr[0], null);
    }

    public ParseSetup(ParserInfo parse_type, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, ParseWriter.ParseErr[] errs, int chunkSize, byte[] nonDataLineMarkers, byte escapeChar) {
        this(parse_type, sep, singleQuotes, checkHeader, ncols, columnNames, ctypes, domains, naStrings, data, errs, chunkSize, null, null, nonDataLineMarkers, escapeChar);
    }

    public ParseSetup(ParserInfo parse_type, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, ParseWriter.ParseErr[] errs, int chunkSize, Key<DecryptionTool> decrypt_tool, int[] skipped_columns, byte[] nonDataLineMarkers, byte escapeChar) {
        this._parse_type = parse_type;
        this._separator = sep;
        this._nonDataLineMarkers = nonDataLineMarkers;
        this._single_quotes = singleQuotes;
        this._check_header = checkHeader;
        this._number_columns = ncols;
        this._column_names = columnNames;
        this._column_types = ctypes;
        this._domains = domains;
        this._na_strings = naStrings;
        this._data = data;
        this._chunk_size = chunkSize;
        this._errs = errs;
        this._decrypt_tool = decrypt_tool;
        this._skipped_columns = skipped_columns;
        this._escapechar = escapeChar;
        this.setParseColumnIndices(ncols, this._skipped_columns);
    }

    public void setParseColumnIndices(int ncols, int[] skipped_columns) {
        block4: {
            block3: {
                if (skipped_columns == null) break block3;
                int num_parse_columns = ncols - skipped_columns.length;
                if (num_parse_columns < 0) break block4;
                this._parse_columns_indices = new int[num_parse_columns];
                int counter = 0;
                for (int index = 0; index < ncols; ++index) {
                    if (ArrayUtils.contains(skipped_columns, index)) continue;
                    this._parse_columns_indices[counter++] = index;
                }
                break block4;
            }
            if (ncols > 0) {
                this._parse_columns_indices = new int[ncols];
                for (int index = 0; index < ncols; ++index) {
                    this._parse_columns_indices[index] = index;
                }
            }
        }
    }

    public void setSyntheticColumns(String[] names, String[][] valueMapping, byte synthetic_column_type) {
        this._synthetic_column_names = names;
        this._synthetic_column_values = valueMapping;
        this._synthetic_column_type = synthetic_column_type;
    }

    public ParseSetup(ParseSetupV3 ps) {
        this(ps.parse_type != null ? ParserService.INSTANCE.getByName(ps.parse_type).info() : DefaultParserProviders.GUESS_INFO, ps.separator != 0 ? (byte)ps.separator : (byte)-1, ps.single_quotes, ps.check_header, -1, ps.column_names, ParseSetup.strToColumnTypes(ps.column_types), null, ps.na_strings, null, new ParseWriter.ParseErr[]{}, ps.chunk_size, ps.decrypt_tool != null ? ps.decrypt_tool.key() : null, ps.skipped_columns, ps.custom_non_data_line_markers != null ? ps.custom_non_data_line_markers.getBytes() : null, ps.escapechar);
    }

    public ParseSetup(ParserInfo parseType, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, byte[] nonDataLineMarkers, byte escapeChar) {
        this(parseType, sep, singleQuotes, checkHeader, ncols, columnNames, ctypes, domains, naStrings, data, new ParseWriter.ParseErr[0], 0x400000, nonDataLineMarkers, escapeChar);
    }

    public ParseSetup(ParserInfo parseType, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, byte escapeChar) {
        this(parseType, sep, singleQuotes, checkHeader, ncols, columnNames, ctypes, domains, naStrings, data, new ParseWriter.ParseErr[0], 0x400000, null, escapeChar);
    }

    public ParseSetup(ParserInfo parseType, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data) {
        this(parseType, sep, singleQuotes, checkHeader, ncols, columnNames, ctypes, domains, naStrings, data, new ParseWriter.ParseErr[0], 0x400000, null, 0);
    }

    public ParseSetup(ParserInfo parseType, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, ParseWriter.ParseErr[] errs, byte[] nonDataLineMarkers) {
        this(parseType, sep, singleQuotes, checkHeader, ncols, columnNames, ctypes, domains, naStrings, data, errs, 0x400000, nonDataLineMarkers, 0);
    }

    public ParseSetup(ParserInfo parseType, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, ParseWriter.ParseErr[] errs) {
        this(parseType, sep, singleQuotes, checkHeader, ncols, columnNames, ctypes, domains, naStrings, data, errs, 0x400000, null, 0);
    }

    public ParseSetup(ParserInfo parseType, byte sep, boolean singleQuotes, int checkHeader, int ncols, String[][] data, ParseWriter.ParseErr[] errs) {
        this(parseType, sep, singleQuotes, checkHeader, ncols, null, null, null, null, data, errs, 0x400000, null, 0);
    }

    public ParseSetup() {
    }

    public String[] getColumnNames() {
        return this._column_names;
    }

    public int[] getSkippedColumns() {
        return this._skipped_columns;
    }

    public int[] get_parse_columns_indices() {
        return this._parse_columns_indices;
    }

    public String[][] getData() {
        return this._data;
    }

    public String[] getColumnTypeStrings() {
        String[] types = new String[this._column_types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            types[i2] = Vec.TYPE_STR[this._column_types[i2]];
        }
        return types;
    }

    public byte[] getColumnTypes() {
        return this._column_types;
    }

    public static byte[] strToColumnTypes(String[] strs) {
        if (strs == null) {
            return null;
        }
        byte[] types = new byte[strs.length];
        block23: for (int i2 = 0; i2 < types.length; ++i2) {
            switch (strs[i2].toLowerCase()) {
                case "unknown": {
                    types[i2] = 0;
                    continue block23;
                }
                case "uuid": {
                    types[i2] = 1;
                    continue block23;
                }
                case "string": {
                    types[i2] = 2;
                    continue block23;
                }
                case "float": 
                case "real": 
                case "double": 
                case "int": 
                case "long": 
                case "numeric": {
                    types[i2] = 3;
                    continue block23;
                }
                case "categorical": 
                case "factor": 
                case "enum": {
                    types[i2] = 4;
                    continue block23;
                }
                case "time": {
                    types[i2] = 5;
                    continue block23;
                }
                default: {
                    types[i2] = 0;
                    throw new H2OIllegalArgumentException("Provided column type " + strs[i2] + " is unknown.  Cannot proceed with parse due to invalid argument.");
                }
            }
        }
        return types;
    }

    protected Parser parser(Key jobKey) {
        ParserProvider pp = ParserService.INSTANCE.getByInfo(this._parse_type);
        if (pp != null) {
            return pp.createParser(this, jobKey);
        }
        throw new H2OIllegalArgumentException("Unknown file type.  Parse cannot be completed.", "Attempted to invoke a parser for ParseType:" + this._parse_type + ", which doesn't exist.");
    }

    public final ParseSetup getFinalSetup(Key[] inputKeys, ParseSetup demandedSetup) {
        ParserProvider pp = ParserService.INSTANCE.getByInfo(this._parse_type);
        if (pp != null) {
            ParseSetup ps = pp.createParserSetup(inputKeys, demandedSetup);
            if (demandedSetup._decrypt_tool != null) {
                ps._decrypt_tool = demandedSetup._decrypt_tool;
            }
            ps.setSkippedColumns(demandedSetup.getSkippedColumns());
            ps.setParseColumnIndices(demandedSetup.getNumberColumns(), demandedSetup.getSkippedColumns());
            return ps;
        }
        throw new H2OIllegalArgumentException("Unknown parser configuration! Configuration=" + this);
    }

    public int getNumberColumns() {
        return this._number_columns;
    }

    public final DecryptionTool getDecryptionTool() {
        return DecryptionTool.get(this._decrypt_tool);
    }

    public final ParserInfo.ParseMethod parseMethod(int nfiles, Vec v2) {
        boolean isEncrypted = !this.getDecryptionTool().isTransparent();
        return this._parse_type.parseMethod(nfiles, v2.nChunks(), this.disableParallelParse, isEncrypted);
    }

    HashSet<String> checkDupColumnNames() {
        HashSet<String> conflictingNames = new HashSet<String>();
        if (null == this._column_names) {
            return conflictingNames;
        }
        HashSet<String> uniqueNames = new HashSet<String>();
        for (String n2 : this._column_names) {
            if (uniqueNames.add(n2)) continue;
            conflictingNames.add(n2);
        }
        return conflictingNames;
    }

    public String toString() {
        return this._parse_type.toString();
    }

    static boolean allStrings(String[] line) {
        BufferedString str = new BufferedString();
        for (String s2 : line) {
            try {
                Double.parseDouble(s2);
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                str.set(s2);
                if (ParseTime.isTime(str)) {
                    return false;
                }
                if (!ParseUUID.isUUID(str)) continue;
                return false;
            }
        }
        return true;
    }

    static boolean hasHeader(String[] l1, String[] l2) {
        return ParseSetup.allStrings(l1) && !ParseSetup.allStrings(l2);
    }

    public static ParseSetup guessSetup(Key[] fkeys, boolean singleQuote, int checkHeader) {
        return ParseSetup.guessSetup(fkeys, new ParseSetup(DefaultParserProviders.GUESS_INFO, -1, singleQuote, checkHeader, -1, null, new ParseWriter.ParseErr[0]));
    }

    public static ParseSetup guessSetup(Key[] fkeys, ParseSetup userSetup) {
        GuessSetupTsk t2 = new GuessSetupTsk(userSetup);
        ((GuessSetupTsk)t2.doAll(fkeys)).getResult();
        Object ice = DKV.getGet(fkeys[0]);
        t2._gblSetup._chunk_size = ice instanceof Frame && ((Frame)ice).vec(0) instanceof UploadFileVec ? 0x400000 : FileVec.calcOptimalChunkSize(t2._totalParseSize, t2._gblSetup._number_columns, t2._maxLineLength, H2ORuntime.availableProcessors(), H2O.getCloudSize(), false, true);
        return t2._gblSetup;
    }

    private String file() {
        Object[] names = this._fileNames;
        if (names.length > 5) {
            names = (String[])Arrays.copyOf(names, 5);
        }
        return Arrays.toString(names);
    }

    protected boolean isCompatible(ParseSetup setupB) {
        return this._parse_type.equals(setupB._parse_type) && this._parse_type.equals(DefaultParserProviders.SVMLight_INFO) || this._number_columns == setupB._number_columns;
    }

    public static ParseSetup guessSetup(ByteVec bv, byte[] bits, ParseSetup userSetup) {
        ParserProvider pp = ParserService.INSTANCE.getByInfo(userSetup._parse_type);
        if (pp != null) {
            return pp.guessSetup(bv, bits, userSetup.toInitialSetup());
        }
        throw new ParseDataset.H2OParseException("Cannot determine file type.");
    }

    private ParseSetup toInitialSetup() {
        return new ParseSetup(this._parse_type, this._separator, this._single_quotes, this._check_header, -1, this._column_names, this._column_types, (String[][])null, (String[][])null, (String[][])null, this._nonDataLineMarkers, this._escapechar);
    }

    public static String createHexName(String n2) {
        int sep = n2.lastIndexOf(File.separatorChar);
        if (sep > 0) {
            n2 = n2.substring(sep + 1);
        }
        int dot = n2.lastIndexOf(46);
        while (dot > 0 && (n2.endsWith("zip") || n2.endsWith("gz") || n2.endsWith("csv") || n2.endsWith("xls") || n2.endsWith("txt") || n2.endsWith("svm") || n2.endsWith("orc") || n2.endsWith("arff"))) {
            n2 = n2.substring(0, dot);
            dot = n2.lastIndexOf(46);
        }
        if (!Character.isJavaIdentifierStart(n2.charAt(0))) {
            n2 = "X" + n2;
        }
        n2 = StringUtils.sanitizeIdentifier(n2);
        int i2 = 0;
        String res = n2 + ".hex";
        Key k2 = Key.make(res);
        while (DKV.get(k2) != null) {
            res = n2 + ++i2 + ".hex";
            k2 = Key.make(res);
        }
        return res;
    }

    private static final void checkEncoding(byte[] bits) {
        if (bits.length >= 2 && (bits[0] == -1 && bits[1] == -2 || bits[0] == -2 && bits[1] == -1)) {
            throw new ParseDataset.H2OParseException("UTF16 encoding detected, but is not supported.");
        }
    }

    private static final int maxLineLength(byte[] bytes) {
        int start = bytes.length;
        int max = -1;
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            if (!CsvParser.isEOL(bytes[i2])) continue;
            int delta = i2 - start + 1;
            max = Math.max(max, delta);
            start = i2 + 1;
        }
        return Math.max(max, bytes.length - start + 1);
    }

    public <T extends ParseSetup> T copyTo(T setup) {
        try {
            for (Field field : ParseSetup.class.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.set(setup, field.get(this));
            }
            return setup;
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
    }

    public boolean isNA(int colIdx, BufferedString str) {
        if (this._na_strings == null || colIdx >= this._na_strings.length || this._na_strings[colIdx] == null) {
            return false;
        }
        for (String naStr : this._na_strings[colIdx]) {
            if (!str.equalsAsciiString(naStr)) continue;
            return true;
        }
        return false;
    }

    public ParserInfo getParseType() {
        return this._parse_type;
    }

    public ParseSetup setParseType(ParserInfo parse_type) {
        this._parse_type = parse_type;
        return this;
    }

    public ParseSetup setSeparator(byte separator) {
        this._separator = separator;
        return this;
    }

    public ParseSetup setSingleQuotes(boolean single_quotes) {
        this._single_quotes = single_quotes;
        return this;
    }

    public ParseSetup setCheckHeader(int check_header) {
        this._check_header = check_header;
        return this;
    }

    public ParseSetup setNumberColumns(int number_columns) {
        this._number_columns = number_columns;
        return this;
    }

    public ParseSetup setColumnNames(String[] column_names) {
        this._column_names = column_names;
        return this;
    }

    public ParseSetup setSkippedColumns(int[] skipped_columns) {
        this._skipped_columns = skipped_columns;
        return this;
    }

    public ParseSetup setColumnTypes(byte[] column_types) {
        this._column_types = column_types;
        return this;
    }

    public ParseSetup setDomains(String[][] domains) {
        this._domains = domains;
        return this;
    }

    public ParseSetup setNAStrings(String[][] na_strings) {
        this._na_strings = na_strings;
        return this;
    }

    public ParseSetup setChunkSize(int chunk_size) {
        this._chunk_size = chunk_size;
        return this;
    }

    public ParseSetup setDecryptTool(Key<DecryptionTool> decrypt_tool) {
        this._decrypt_tool = decrypt_tool;
        return this;
    }

    static /* synthetic */ ParseWriter.ParseErr[] access$202(ParseSetup x0, ParseWriter.ParseErr[] x1) {
        x0._errs = x1;
        return x1;
    }

    public static class GuessSetupTsk
    extends MRTask<GuessSetupTsk> {
        final ParseSetup _userSetup;
        boolean _empty = true;
        public ParseSetup _gblSetup;
        public long _totalParseSize;
        public long _maxLineLength;
        String _file;

        public GuessSetupTsk(ParseSetup userSetup) {
            this._userSetup = userSetup;
        }

        @Override
        public void map(Key key) {
            byte[] bits;
            this._file = key.toString();
            Object ice = DKV.getGet(key);
            if (ice == null) {
                throw new H2OIllegalArgumentException("Missing data", "Did not find any data under key " + key);
            }
            ByteVec bv = (ByteVec)(ice instanceof ByteVec ? ice : ((Frame)ice).vecs()[0]);
            try {
                bits = bv.getFirstBytes();
            }
            catch (Exception e2) {
                throw new RuntimeException("This H2O node couldn't read data from '" + this._file + "'. Please make sure the file is available on all H2O nodes and/or check the working directories.", e2);
            }
            Key<DecryptionTool> decryptToolKey = this._userSetup._decrypt_tool != null ? this._userSetup._decrypt_tool : H2O.defaultDecryptionTool();
            DecryptionTool decrypt = (DecryptionTool)DKV.getGet(decryptToolKey);
            if (decrypt != null) {
                byte[] byArray = decrypt.decryptFirstBytes(bits);
                if (byArray != bits) {
                    bits = byArray;
                } else {
                    decryptToolKey = null;
                }
            }
            if ((bits = ZipUtil.getFirstUnzippedBytes(bits)) != null && bits.length > 0) {
                this._empty = false;
                this._totalParseSize += bv.length();
                ParseSetup.checkEncoding(bits);
                this._maxLineLength = ParseSetup.maxLineLength(bits);
                if (this._maxLineLength == -1L) {
                    throw new H2OIllegalArgumentException("The first 4MB of the data don't contain any line breaks. Cannot parse.");
                }
                try {
                    this._gblSetup = ParseSetup.guessSetup(bv, bits, this._userSetup);
                    this._gblSetup._decrypt_tool = decryptToolKey;
                    for (ParseWriter.ParseErr e3 : this._gblSetup._errs) {
                        e3._cidx = 0;
                        e3._file = this._file;
                    }
                }
                catch (ParseDataset.H2OParseException h2OParseException) {
                    throw h2OParseException.resetMsg(h2OParseException.getMessage() + " for " + key);
                }
            }
            if (this._gblSetup == null) {
                throw new RuntimeException("This H2O node couldn't find the file(s) to parse. Please check files and/or working directories.");
            }
            this._gblSetup.setFileName(FileUtils.keyToFileName(key));
        }

        @Override
        public void reduce(GuessSetupTsk other) {
            if (other._empty) {
                return;
            }
            if (this._gblSetup == null) {
                this._empty = false;
                this._gblSetup = other._gblSetup;
                assert (this._gblSetup != null);
                return;
            }
            this._gblSetup = this.mergeSetups(this._gblSetup, other._gblSetup, this._file, other._file);
            this._totalParseSize += other._totalParseSize;
            this._maxLineLength = Math.max(this._maxLineLength, other._maxLineLength);
        }

        @Override
        public void postGlobal() {
            if (this._gblSetup._column_previews != null && !this._gblSetup._parse_type.equals(DefaultParserProviders.ARFF_INFO)) {
                this._gblSetup._column_types = this._gblSetup._column_previews.guessTypes();
                this._gblSetup._na_strings = this._userSetup._na_strings == null ? this._gblSetup._column_previews.guessNAStrings(this._gblSetup._column_types) : this._userSetup._na_strings;
            }
            for (ParseWriter.ParseErr err : this._gblSetup._errs) {
                Log.warn("ParseSetup: " + err.toString());
            }
        }

        private ParseSetup mergeSetups(ParseSetup setupA, ParseSetup setupB, String fileA, String fileB) {
            if (setupA == null) {
                return setupB;
            }
            if (setupA._parse_type.equals(DefaultParserProviders.SVMLight_INFO) && setupB._parse_type.equals(DefaultParserProviders.SVMLight_INFO)) {
                return setupA._number_columns >= setupB._number_columns ? setupA : setupB;
            }
            ParseSetup mergedSetup = setupA;
            mergedSetup._check_header = GuessSetupTsk.unifyCheckHeader(setupA._check_header, setupB._check_header);
            mergedSetup._separator = GuessSetupTsk.unifyColumnSeparators(setupA._separator, setupB._separator);
            if (!setupA._parse_type.equals(DefaultParserProviders.ARFF_INFO) || !setupB._parse_type.equals(DefaultParserProviders.CSV_INFO)) {
                if (setupA._parse_type.equals(DefaultParserProviders.CSV_INFO) && setupB._parse_type.equals(DefaultParserProviders.ARFF_INFO)) {
                    mergedSetup._parse_type = DefaultParserProviders.ARFF_INFO;
                    mergedSetup._column_types = setupB._column_types;
                    mergedSetup._nonDataLineMarkers = setupB._nonDataLineMarkers;
                } else if (setupA.isCompatible(setupB)) {
                    mergedSetup._column_previews = PreviewParseWriter.unifyColumnPreviews(setupA._column_previews, setupB._column_previews);
                } else {
                    throw new ParseDataset.H2OParseException("File type mismatch. Cannot parse files " + setupA.file() + " and " + setupB.file() + " of type " + setupA._parse_type.name() + " and " + setupB._parse_type.name() + " as one dataset.");
                }
            }
            mergedSetup._column_names = GuessSetupTsk.unifyColumnNames(setupA._column_names, setupB._column_names);
            int n2 = mergedSetup._number_columns = mergedSetup._parse_type.equals(DefaultParserProviders.CSV_INFO) ? Math.max(setupA._number_columns, setupB._number_columns) : this.unifyColumnCount(setupA._number_columns, setupB._number_columns, mergedSetup, fileA, fileB);
            if (mergedSetup._data.length < 10) {
                int n3 = mergedSetup._data.length;
                int m4 = Math.min(10, n3 + setupB._data.length - 1);
                mergedSetup._data = (String[][])Arrays.copyOf(mergedSetup._data, m4);
                System.arraycopy(setupB._data, 1, mergedSetup._data, n3, m4 - n3);
            }
            ParseSetup.access$202(mergedSetup, ArrayUtils.append(setupA._errs, setupB._errs));
            mergedSetup._fileNames = ArrayUtils.append(setupA._fileNames, setupB._fileNames);
            if (mergedSetup._errs.length > 20) {
                ParseSetup.access$202(mergedSetup, Arrays.copyOf(mergedSetup._errs, 20));
            }
            return mergedSetup;
        }

        private static int unifyCheckHeader(int chkHdrA, int chkHdrB) {
            if (chkHdrA == 0 || chkHdrB == 0) {
                throw new ParseDataset.H2OParseException("Unable to determine header on a file. Not expected.");
            }
            if (chkHdrA == 1 || chkHdrB == 1) {
                return 1;
            }
            return -1;
        }

        private static byte unifyColumnSeparators(byte sepA, byte sepB) {
            if (sepA == sepB) {
                return sepA;
            }
            if (sepA == -1) {
                return sepB;
            }
            if (sepB == -1) {
                return sepA;
            }
            throw new ParseDataset.H2OParseException("Column separator mismatch. One file seems to use \"" + (char)sepA + "\" and the other uses \"" + (char)sepB + "\".");
        }

        private int unifyColumnCount(int cntA, int cntB, ParseSetup mergedSetup, String fileA, String fileB) {
            if (cntA == cntB) {
                return cntA;
            }
            if (cntA == 0) {
                return cntB;
            }
            if (cntB == 0) {
                return cntA;
            }
            ParseWriter.ParseErr err = new ParseWriter.ParseErr();
            err._err = "Incompatible number of columns, " + cntA + " != " + cntB;
            err._file = fileA + ", " + fileB;
            ParseSetup.access$202(mergedSetup, ArrayUtils.append(mergedSetup._errs, err));
            return Math.max(cntA, cntB);
        }

        private static String[] unifyColumnNames(String[] namesA, String[] namesB) {
            if (namesA == null) {
                return namesB;
            }
            if (namesB == null) {
                return namesA;
            }
            for (int i2 = 0; i2 < namesA.length; ++i2) {
                if (i2 <= namesB.length && namesA[i2].equals(namesB[i2])) continue;
                throw new ParseDataset.H2OParseException("Column names do not match between files.");
            }
            return namesA;
        }
    }
}

