/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.List;
import water.Job;
import water.Key;
import water.exceptions.H2OUnsupportedDataFileException;
import water.fvec.ByteVec;
import water.parser.ARFFParser;
import water.parser.CsvParser;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.ParserProvider;
import water.parser.ParserService;
import water.parser.SVMLightParser;
import water.parser.XlsParser;
import water.util.Log;

public final class DefaultParserProviders {
    public static final ParserInfo ARFF_INFO = new ParserInfo("ARFF", 0, true);
    public static final ParserInfo XLS_INFO = new ParserInfo("XLS", 100, false);
    public static final ParserInfo XLSX_INFO = new ParserInfo("XLSX", 102, false);
    public static final ParserInfo SVMLight_INFO = new ParserInfo("SVMLight", 1000, true);
    public static final ParserInfo CSV_INFO = new ParserInfo("CSV", Integer.MAX_VALUE, true);
    public static final ParserInfo GUESS_INFO = new ParserInfo("GUESS", -10000, false);
    public static final int MAX_CORE_PRIO = 10000;

    static abstract class AbstractParserProvide
    extends ParserProvider {
        AbstractParserProvide() {
        }

        @Override
        public ParseSetup createParserSetup(Key[] inputs, ParseSetup requiredSetup) {
            return requiredSetup;
        }
    }

    public static final class GuessParserProvider
    extends AbstractParserProvide {
        @Override
        public ParserInfo info() {
            return GUESS_INFO;
        }

        @Override
        protected ParseSetup guessSetup_impl(ByteVec bv, byte[] bits, ParseSetup userSetup) {
            List<ParserProvider> pps = ParserService.INSTANCE.getAllProviders(true);
            ParseSetup parseSetup = null;
            ParserProvider provider = null;
            for (ParserProvider pp : pps) {
                if (pp == this || pp.info().equals(GUESS_INFO)) continue;
                try {
                    ParseSetup ps = pp.guessInitSetup(bv, bits, userSetup);
                    if (ps == null) continue;
                    provider = pp;
                    parseSetup = ps;
                    break;
                }
                catch (H2OUnsupportedDataFileException e2) {
                    throw e2;
                }
                catch (Throwable ignore) {
                    Log.trace("Guesser failed for parser type", pp.info(), ignore);
                }
            }
            if (provider == null) {
                throw new ParseDataset.H2OParseException("Cannot determine file type.");
            }
            return provider.guessFinalSetup(bv, bits, parseSetup);
        }

        @Override
        public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
            throw new UnsupportedOperationException("Guess parser provided does not know how to create a new parser! Use a specific parser!");
        }
    }

    public static final class CsvParserProvider
    extends AbstractParserProvide {
        @Override
        public ParserInfo info() {
            return CSV_INFO;
        }

        @Override
        public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
            return new CsvParser(setup, (Key)jobKey);
        }

        @Override
        public ParseSetup guessInitSetup(ByteVec v2, byte[] bits, ParseSetup ps) {
            return CsvParser.guessSetup(bits, ps._separator, ps._number_columns, ps._single_quotes, ps._check_header, ps._column_names, ps._column_types, ps._na_strings, ps._nonDataLineMarkers, ps._escapechar);
        }
    }

    public static final class SVMLightParserProvider
    extends AbstractParserProvide {
        @Override
        public ParserInfo info() {
            return SVMLight_INFO;
        }

        @Override
        public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
            return new SVMLightParser(setup, (Key)jobKey);
        }

        @Override
        public ParseSetup guessSetup(ByteVec bv, byte[] bits, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] domains, String[][] naStrings) {
            return SVMLightParser.guessSetup(bits);
        }
    }

    public static final class XlsParserProvider
    extends AbstractParserProvide {
        @Override
        public ParserInfo info() {
            return XLS_INFO;
        }

        @Override
        public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
            return new XlsParser(setup, (Key)jobKey);
        }

        @Override
        public ParseSetup guessSetup(ByteVec bv, byte[] bits, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] domains, String[][] naStrings) {
            return XlsParser.guessSetup(bits);
        }
    }

    public static final class ArffParserProvider
    extends AbstractParserProvide {
        @Override
        public ParserInfo info() {
            return ARFF_INFO;
        }

        @Override
        public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
            return new ARFFParser(setup, (Key)jobKey);
        }

        @Override
        public ParseSetup guessInitSetup(ByteVec v2, byte[] bits, ParseSetup ps) {
            return ARFFParser.guessSetup(v2, bits, ps._separator, ps._single_quotes, ps._column_names, ps._na_strings, ps._nonDataLineMarkers, ps._escapechar);
        }
    }
}

