/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.concurrent.atomic.AtomicInteger;
import water.Iced;
import water.parser.BufferedString;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.PrettyPrint;

public final class Categorical
extends Iced {
    public static final int MAX_CATEGORICAL_COUNT = 10000000;
    transient AtomicInteger _id = new AtomicInteger();
    int _maxId = -1;
    volatile IcedHashMap<BufferedString, Integer> _map = new IcedHashMap();
    boolean maxDomainExceeded = false;

    Categorical() {
    }

    int addKey(BufferedString str) {
        IcedHashMap<BufferedString, Integer> m4 = this._map;
        if (m4 == null) {
            return Integer.MAX_VALUE;
        }
        Integer res = (Integer)m4.get(str);
        if (res != null) {
            return res;
        }
        assert (str.length() < 65535);
        int newVal = this._id.incrementAndGet();
        res = m4.putIfAbsent(new BufferedString(str), newVal);
        if (res != null) {
            return res;
        }
        if (m4.size() > 10000000) {
            this.maxDomainExceeded = true;
        }
        return newVal;
    }

    final boolean containsKey(BufferedString key) {
        return this._map.containsKey(key);
    }

    public String toString() {
        return "{" + this._map + " }";
    }

    int getTokenId(BufferedString str) {
        return (Integer)this._map.get(str);
    }

    int maxId() {
        return this._maxId == -1 ? this._id.get() : this._maxId;
    }

    int size() {
        return this._map.size();
    }

    boolean isMapFull() {
        return this.maxDomainExceeded;
    }

    BufferedString[] getColumnDomain() {
        return this._map.keySet().toArray(new BufferedString[this._map.size()]);
    }

    void convertToUTF8(int col) {
        int hexConvLeft = 10;
        BufferedString[] bStrs = this._map.keySet().toArray(new BufferedString[this._map.size()]);
        StringBuilder hexSB = new StringBuilder();
        for (int i2 = 0; i2 < bStrs.length; ++i2) {
            String s2 = bStrs[i2].toString();
            if (bStrs[i2].equalsAsciiString(s2)) continue;
            if (s2.contains("\ufffd")) {
                s2 = bStrs[i2].toSanitizedString();
                if (hexConvLeft-- > 0) {
                    hexSB.append(s2).append(", ");
                }
                if (hexConvLeft == 0) {
                    hexSB.append("...");
                }
            }
            int val = (Integer)this._map.get(bStrs[i2]);
            this._map.remove(bStrs[i2]);
            bStrs[i2] = new BufferedString(s2);
            this._map.put(bStrs[i2], val);
        }
        if (hexSB.length() > 0) {
            Log.info("Found categoricals with non-UTF-8 characters or NULL character in the " + PrettyPrint.withOrdinalIndicator(col) + " column. Converting unrecognized characters into hex:  " + hexSB.toString());
        }
    }
}

