/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public abstract class AbstractBuildVersion {
    static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static int TOO_OLD_THRESHOLD = 100;
    static String LATEST_STABLE_URL = " http://h2o-release.s3.amazonaws.com/h2o/latest_stable";
    static Pattern VERSION_EXTRACT_PATTERN = Pattern.compile(".*h2o-(.*).zip");
    public static String DEVEL_VERSION_PATCH_NUMBER = "99999";
    private static final String UNKNOWN_VERSION_MARKER = "(unknown)";
    public static final AbstractBuildVersion UNKNOWN_VERSION = new AbstractBuildVersion(){

        @Override
        public String projectVersion() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String lastCommitHash() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String describe() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String compiledOn() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String compiledBy() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }

        @Override
        public String branchName() {
            return AbstractBuildVersion.UNKNOWN_VERSION_MARKER;
        }
    };

    public abstract String branchName();

    public abstract String lastCommitHash();

    public abstract String describe();

    public abstract String projectVersion();

    public abstract String compiledOn();

    public abstract String compiledBy();

    public String toString() {
        return "H2O v" + this.projectVersion() + " (" + this.branchName() + " - " + this.lastCommitHash() + ")";
    }

    public String buildNumber() {
        String pv = this.projectVersion();
        if (pv.equals(UNKNOWN_VERSION_MARKER)) {
            return UNKNOWN_VERSION_MARKER;
        }
        String[] split_pv = pv.split("\\.");
        String bn = split_pv[split_pv.length - 1];
        return bn;
    }

    public final Date compiledOnDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        try {
            return dateFormat.parse(this.compiledOn());
        }
        catch (ParseException e2) {
            return null;
        }
    }

    public final boolean isTooOld() {
        Date compileTime = this.compiledOnDate();
        if (compileTime == null) {
            return false;
        }
        long timeDiff = System.currentTimeMillis() - compileTime.getTime();
        long days = timeDiff / 86400000L;
        return days > (long)TOO_OLD_THRESHOLD;
    }

    public boolean isDevVersion() {
        return this.projectVersion().equals(UNKNOWN_VERSION_MARKER) || this.projectVersion().endsWith(DEVEL_VERSION_PATCH_NUMBER);
    }

    private String getValue(String name) {
        switch (name) {
            case "projectVersion": {
                return this.projectVersion();
            }
            case "lastCommitHash": {
                return this.lastCommitHash();
            }
            case "describe": {
                return this.describe();
            }
            case "compiledOn": {
                return this.compiledOn();
            }
            case "compiledBy": {
                return this.compiledBy();
            }
            case "branchName": {
                return this.branchName();
            }
        }
        return null;
    }

    public static AbstractBuildVersion getBuildVersion() {
        AbstractBuildVersion abv = UNKNOWN_VERSION;
        try {
            Class<?> klass = Class.forName("water.init.BuildVersion");
            Constructor<?> constructor = klass.getConstructor(new Class[0]);
            abv = (AbstractBuildVersion)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return abv;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"projectVersion"};
        }
        AbstractBuildVersion buildVersion = AbstractBuildVersion.getBuildVersion();
        System.out.print(buildVersion.getValue(args[0]));
        for (int i2 = 1; i2 < args.length; ++i2) {
            System.out.print(' ');
            System.out.print(buildVersion.getValue(args[i2]));
        }
        System.out.println();
    }
}

