/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.util.List;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.hive.HiveMetaData;
import water.rapids.Rapids;
import water.rapids.Val;

public class PartitionFrameJoiner
extends H2O.H2OCountedCompleter<PartitionFrameJoiner> {
    private final Job<Frame> _job;
    private final HiveMetaData.Table _table;
    private final List<HiveMetaData.Partition> _partitions;
    private final String _targetFrame;
    private final List<Job<Frame>> _parseJobs;

    public PartitionFrameJoiner(Job<Frame> job, HiveMetaData.Table table, List<HiveMetaData.Partition> partitions, String targetFrame, List<Job<Frame>> parseJobs) {
        this._job = job;
        this._table = table;
        this._partitions = partitions;
        this._targetFrame = targetFrame;
        this._parseJobs = parseJobs;
    }

    @Override
    public void compute2() {
        int keyCount = this._table.getPartitionKeys().size();
        StringBuilder partKeys = new StringBuilder();
        for (Job<Frame> job : this._parseJobs) {
            Frame partitionFrame = job.get();
            String partKey = partitionFrame._key.toString();
            String[] keySplit = partKey.split("_");
            int partIndex = Integer.parseInt(keySplit[keySplit.length - 1]);
            HiveMetaData.Partition part = this._partitions.get(partIndex);
            partKeys.append(" ").append(partKey);
            long rows = partitionFrame.numRows();
            for (int keyIndex = 0; keyIndex < keyCount; ++keyIndex) {
                String partitionValue = part.getValues().get(keyIndex);
                Vec vec = this.makeVecWithValue(rows, partitionValue);
                partitionFrame.add(this._table.getPartitionKeys().get(keyIndex).getName(), vec);
            }
            this._job.update(1L);
        }
        String tree = "(rbind" + partKeys + ")";
        Val val = Rapids.exec(tree);
        Frame merged = val.getFrame();
        merged._key = Key.make(this._targetFrame);
        DKV.put(merged);
        for (Job<Frame> parseJob : this._parseJobs) {
            DKV.remove(parseJob._result);
        }
        this._job.update(1L);
        this.tryComplete();
    }

    private Vec makeVecWithValue(long rows, final String value) {
        Vec zeroes = Vec.makeZero(rows, (byte)2);
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c2 : cs) {
                    for (int r2 = 0; r2 < c2._len; ++r2) {
                        c2.set(r2, value);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{zeroes}))._fr.vecs()[0];
    }
}

