/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import ai.h2o.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import water.H2O;
import water.MRTask;
import water.Paxos;
import water.hive.DelegationTokenPrinter;
import water.hive.HiveTokenGenerator;
import water.util.BinaryFileTransfer;
import water.util.FileUtils;

public class DelegationTokenRefresher
implements Runnable {
    public static final String H2O_AUTH_USER = "h2o.auth.user";
    public static final String H2O_AUTH_PRINCIPAL = "h2o.auth.principal";
    public static final String H2O_AUTH_KEYTAB = "h2o.auth.keytab";
    public static final String H2O_HIVE_USE_KEYTAB = "h2o.hive.useKeytab";
    public static final String H2O_HIVE_JDBC_URL_PATTERN = "h2o.hive.jdbc.urlPattern";
    public static final String H2O_HIVE_HOST = "h2o.hive.jdbc.host";
    public static final String H2O_HIVE_PRINCIPAL = "h2o.hive.principal";
    public static final String H2O_HIVE_TOKEN = "h2o.hive.token";
    private final ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("delegation-token-refresher-%d").build());
    private final String _authPrincipal;
    private final String _authKeytabPath;
    private final String _authUser;
    private final String _hiveJdbcUrl;
    private final String _hivePrincipal;
    private final HiveTokenGenerator _hiveTokenGenerator = new HiveTokenGenerator();

    public static void setup(Configuration conf, String tmpDir) throws IOException {
        if (!HiveTokenGenerator.isHiveDriverPresent()) {
            return;
        }
        String token = conf.get(H2O_HIVE_TOKEN);
        if (token != null) {
            DelegationTokenRefresher.log("Adding credentials from property", null);
            Credentials creds = HiveTokenGenerator.tokenToCredentials(token);
            UserGroupInformation.getCurrentUser().addCredentials(creds);
        }
        String authUser = conf.get(H2O_AUTH_USER);
        String authPrincipal = conf.get(H2O_AUTH_PRINCIPAL);
        boolean useKeytab = conf.getBoolean(H2O_HIVE_USE_KEYTAB, true);
        String authKeytab = useKeytab ? conf.get(H2O_AUTH_KEYTAB) : null;
        String hivePrincipal = conf.get(H2O_HIVE_PRINCIPAL);
        String hiveJdbcUrl = DelegationTokenRefresher.makeHiveJdbcUrl(conf, hivePrincipal, authKeytab != null);
        if (hiveJdbcUrl != null) {
            String authKeytabPath = authKeytab != null ? DelegationTokenRefresher.writeKeytabToFile(authKeytab, tmpDir) : null;
            new DelegationTokenRefresher(authPrincipal, authKeytabPath, authUser, hiveJdbcUrl, hivePrincipal).start();
        } else {
            DelegationTokenRefresher.log("Delegation token refresh not active.", null);
        }
    }

    private static String makeHiveJdbcUrl(Configuration conf, String hivePrincipal, boolean useKeytab) {
        String hiveJdbcUrlPattern = conf.get(H2O_HIVE_JDBC_URL_PATTERN);
        String hiveHost = conf.get(H2O_HIVE_HOST);
        String hiveJdbcUrl = useKeytab ? HiveTokenGenerator.makeHivePrincipalJdbcUrl(hiveJdbcUrlPattern, hiveHost, hivePrincipal) : HiveTokenGenerator.makeHiveDelegationTokenJdbcUrl(hiveJdbcUrlPattern, hiveHost);
        return hiveJdbcUrl;
    }

    public static boolean startRefresher(Configuration conf, H2O.OptArgs args) {
        String authKeytabPath = args.keytab_path;
        String authPrincipal = args.principal;
        String hivePrincipal = conf.get(H2O_HIVE_PRINCIPAL);
        String hiveJdbcUrl = DelegationTokenRefresher.makeHiveJdbcUrl(conf, hivePrincipal, authKeytabPath != null);
        if (hiveJdbcUrl == null) {
            return false;
        }
        new DelegationTokenRefresher(authPrincipal, authKeytabPath, null, hiveJdbcUrl, hivePrincipal).start();
        return true;
    }

    private static String writeKeytabToFile(String authKeytab, String tmpDir) throws IOException {
        FileUtils.makeSureDirExists(tmpDir);
        String fileName = tmpDir + File.separator + "auth_keytab";
        byte[] byteArr = BinaryFileTransfer.convertStringToByteArr(authKeytab);
        BinaryFileTransfer.writeBinaryFile(fileName, byteArr);
        return fileName;
    }

    public DelegationTokenRefresher(String authPrincipal, String authKeytabPath, String authUser, String hiveJdbcUrl, String hivePrincipal) {
        this._authPrincipal = authPrincipal;
        this._authKeytabPath = authKeytabPath;
        this._authUser = authUser;
        this._hiveJdbcUrl = hiveJdbcUrl;
        this._hivePrincipal = hivePrincipal;
    }

    public void start() {
        this._executor.scheduleAtFixedRate(this, 0L, 1L, TimeUnit.MINUTES);
    }

    private static void log(String s2, Exception e2) {
        System.out.println("TOKEN REFRESH: " + s2);
        if (e2 != null) {
            e2.printStackTrace(System.out);
        }
    }

    @Override
    public void run() {
        if (Paxos._cloudLocked && H2O.CLOUD.leader() != H2O.SELF) {
            this._executor.shutdown();
            return;
        }
        try {
            this.refreshTokens();
        }
        catch (IOException | InterruptedException e2) {
            DelegationTokenRefresher.log("Failed to refresh token.", e2);
        }
    }

    private void distribute(Credentials creds) throws IOException {
        if (!Paxos._cloudLocked) {
            DelegationTokenRefresher.log("Updating credentials", null);
            UserGroupInformation.getCurrentUser().addCredentials(creds);
        } else {
            byte[] credsSerialized = this.serializeCreds(creds);
            new DistributeCreds(credsSerialized).doAllNodes();
        }
    }

    private void refreshTokens() throws IOException, InterruptedException {
        String token;
        if (this._authKeytabPath != null) {
            UserGroupInformation realUser;
            DelegationTokenRefresher.log("Log in from keytab as " + this._authPrincipal, null);
            UserGroupInformation tokenUser = realUser = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)this._authPrincipal, (String)this._authKeytabPath);
            if (this._authUser != null) {
                DelegationTokenRefresher.log("Impersonate " + this._authUser, null);
                tokenUser = UserGroupInformation.createProxyUser((String)this._authUser, (UserGroupInformation)tokenUser);
            }
            token = this._hiveTokenGenerator.getHiveDelegationTokenAsUser(realUser, tokenUser, this._hiveJdbcUrl, this._hivePrincipal);
        } else {
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            token = this._hiveTokenGenerator.getHiveDelegationTokenIfPossible(currentUser, this._hiveJdbcUrl, this._hivePrincipal);
        }
        if (token != null) {
            DelegationTokenPrinter.printToken(token);
            Credentials creds = HiveTokenGenerator.tokenToCredentials(token);
            this.distribute(creds);
        } else {
            DelegationTokenRefresher.log("Failed to refresh delegation token.", null);
        }
    }

    private byte[] serializeCreds(Credentials creds) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        creds.writeTokenStorageToStream(dataStream);
        return byteStream.toByteArray();
    }

    private static class DistributeCreds
    extends MRTask<DistributeCreds> {
        private final byte[] _credsSerialized;

        private DistributeCreds(byte[] credsSerialized) {
            this._credsSerialized = credsSerialized;
        }

        @Override
        protected void setupLocal() {
            try {
                Credentials creds = this.deserialize();
                DelegationTokenRefresher.log("Updating credentials", null);
                UserGroupInformation.getCurrentUser().addCredentials(creds);
            }
            catch (IOException e2) {
                DelegationTokenRefresher.log("Failed to update credentials", e2);
            }
        }

        private Credentials deserialize() throws IOException {
            ByteArrayInputStream tokensBuf = new ByteArrayInputStream(this._credsSerialized);
            Credentials creds = new Credentials();
            creds.readTokenStorageStream(new DataInputStream(tokensBuf));
            return creds;
        }
    }
}

