/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import water.AutoBuffer;
import water.DKV;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.TAtomic;
import water.Value;
import water.fvec.AppendableVec;
import water.fvec.C0DChunk;
import water.fvec.C0LChunk;
import water.fvec.CStrChunk;
import water.fvec.CategoricalWrappedVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.NewChunk;
import water.fvec.RollupStats;
import water.nbhm.NonBlockingHashMap;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.TwoDimTable;
import water.util.UnsafeUtils;
import water.util.VecUtils;

public class Vec
extends Keyed<Vec> {
    byte _type;
    public int _rowLayout;
    private transient long[] _espc;
    private String[] _domain;
    private transient Key _rollupStatsKey;
    private boolean _volatile;
    public static final byte T_BAD = 0;
    public static final byte T_UUID = 1;
    public static final byte T_STR = 2;
    public static final byte T_NUM = 3;
    public static final byte T_CAT = 4;
    public static final byte T_TIME = 5;
    public static final String[] TYPE_STR = new String[]{"BAD", "UUID", "String", "Numeric", "Enum", "Time", "Time", "Time"};
    public static final boolean DO_HISTOGRAMS = true;
    public static final double[] PERCENTILES = new double[]{0.001, 0.01, 0.1, 0.2, 0.25, 0.3, 0.3333333333333333, 0.4, 0.5, 0.6, 0.6666666666666666, 0.7, 0.75, 0.8, 0.9, 0.99, 0.999};
    public transient int[] _cids;
    public static final int KEY_PREFIX_LEN = 10;

    public String[] domain() {
        return this._domain;
    }

    public final String factor(long i2) {
        return this._domain[(int)i2];
    }

    public final void setDomain(String[] domain) {
        this._domain = domain;
        if (domain != null) {
            this._type = (byte)4;
        }
    }

    public final int cardinality() {
        return this.isCategorical() ? this._domain.length : -1;
    }

    public final boolean isDomainTruncated(int expectedCardinality) {
        return this.cardinality() == expectedCardinality + 1 && "other".equals(this._domain[this._domain.length - 1]);
    }

    public final boolean isCategorical() {
        assert (this._type == 4 && this._domain != null || this._type != 4 && this._domain == null || this._type == 3 && this instanceof InteractionWrappedVec && this._domain != null);
        return this._type == 4;
    }

    public final double sparseRatio() {
        return (double)this.rollupStats()._nzCnt / (double)this.length();
    }

    public final boolean isUUID() {
        return this._type == 1;
    }

    public final boolean isString() {
        return this._type == 2;
    }

    public final boolean isNumeric() {
        return this._type == 3;
    }

    public final boolean isTime() {
        return this._type == 5;
    }

    public Vec(Key<Vec> key, int rowLayout) {
        this(key, rowLayout, null, 3);
    }

    Vec(Key<Vec> key, int rowLayout, String[] domain) {
        this(key, rowLayout, domain, domain == null ? (byte)3 : 4);
    }

    public Vec(Key<Vec> key, int rowLayout, String[] domain, byte type) {
        super(key);
        assert (key._kb[0] == 4);
        assert (domain == null || type == 4);
        assert (0 <= type && type <= 5);
        this._rowLayout = rowLayout;
        this._type = type;
        this._domain = domain;
        this._espc = ESPC.espc(this);
    }

    public long[] espc() {
        if (this._espc == null) {
            this._espc = ESPC.espc(this);
        }
        return this._espc;
    }

    public long length() {
        this.espc();
        return this._espc[this._espc.length - 1];
    }

    public int nChunks() {
        return this.espc().length - 1;
    }

    public int nonEmptyChunks() {
        int nonEmptyCnt = this.nChunks();
        for (int i2 = 1; i2 < this._espc.length; ++i2) {
            if (this._espc[i2 - 1] != this._espc[i2]) continue;
            --nonEmptyCnt;
        }
        return nonEmptyCnt;
    }

    long chunk2StartElem(int cidx) {
        return this.espc()[cidx];
    }

    public int chunkLen(int cidx) {
        this.espc();
        return (int)(this._espc[cidx + 1] - this._espc[cidx]);
    }

    public boolean isCompatibleWith(Vec v2) {
        return !(this.espc() != v2.espc() && !Arrays.equals(this._espc, v2._espc) || !VectorGroup.sameGroup(this, v2) && !((double)this.length() < 1000.0));
    }

    boolean readable() {
        return true;
    }

    boolean writable() {
        return true;
    }

    public void setBad() {
        this._type = 0;
    }

    public byte get_type() {
        return this._type;
    }

    public String get_type_str() {
        return TYPE_STR[this._type];
    }

    public boolean isBinary() {
        RollupStats rs = this.rollupStats();
        return rs._isInt && rs._mins[0] >= 0.0 && rs._maxs[0] <= 1.0;
    }

    public boolean isBinary(boolean strict) {
        if (strict) {
            return (this.isBinary() || this.isBinaryOnes()) && !this.isConst();
        }
        return this.isBinary();
    }

    public boolean isBinaryOnes() {
        RollupStats rs = this.rollupStats();
        long zeroCount = rs._rows - rs._nzCnt;
        return rs._isInt && rs._mins[0] >= -1.0 && rs._maxs[0] <= 1.0 && zeroCount == 0L;
    }

    public static Vec makeZero(long len, boolean redistribute) {
        return Vec.makeCon(0.0, len, redistribute);
    }

    public static Vec makeZero(long len) {
        return Vec.makeZero(len, (byte)3);
    }

    public static Vec makeOne(long len) {
        return Vec.makeOne(len, (byte)3);
    }

    public static Vec makeOne(long len, byte typeCode) {
        return Vec.makeCon(1.0, len, true, typeCode);
    }

    public static Vec makeZero(long len, byte typeCode) {
        return Vec.makeCon(0.0, len, true, typeCode);
    }

    public static Vec makeCon(double x2, long len) {
        return Vec.makeCon(x2, len, true);
    }

    public static Vec makeCon(double x2, long len, byte type) {
        int log_rows_per_chunk = 22;
        return Vec.makeCon(x2, len, log_rows_per_chunk, true, type);
    }

    public static Vec makeCon(double x2, long len, boolean redistribute) {
        return Vec.makeCon(x2, len, redistribute, (byte)3);
    }

    public static Vec makeCon(double x2, long len, boolean redistribute, byte typeCode) {
        int log_rows_per_chunk = 22;
        return Vec.makeCon(x2, len, log_rows_per_chunk, redistribute, typeCode);
    }

    public static Vec makeCon(double x2, long len, int log_rows_per_chunk) {
        return Vec.makeCon(x2, len, log_rows_per_chunk, true);
    }

    public static Vec makeCon(long totSize, long len) {
        int safetyInflationFactor = 8;
        int nchunks = (int)Math.max(totSize * 8L / Integer.MAX_VALUE, 1L);
        return Vec.makeConN(len, nchunks);
    }

    public static Vec makeConN(long len, int nchunks) {
        long[] espc = new long[nchunks + 1];
        espc[0] = 0L;
        for (int i2 = 1; i2 < nchunks; ++i2) {
            espc[i2] = espc[i2 - 1] + len / (long)nchunks;
        }
        espc[nchunks] = len;
        VectorGroup vg = VectorGroup.VG_LEN1;
        return Vec.makeCon(0.0, vg, ESPC.rowLayout(vg._key, espc), (byte)3);
    }

    public static int nChunksFor(long len, int log_rows_per_chunk, boolean redistribute) {
        int chunks0 = (int)Math.max(1L, len >> log_rows_per_chunk);
        int chunks1 = (int)Math.min((long)(4 * H2O.NUMCPUS * H2O.CLOUD.size()), len);
        int nchunks = redistribute && chunks0 < chunks1 && len > (long)(10 * chunks1) ? chunks1 : chunks0;
        return nchunks;
    }

    public static Vec makeCon(double x2, long len, int log_rows_per_chunk, boolean redistribute) {
        return Vec.makeCon(x2, len, log_rows_per_chunk, redistribute, (byte)3);
    }

    public static Vec makeCon(double x2, long len, int log_rows_per_chunk, boolean redistribute, byte type) {
        int nchunks = Vec.nChunksFor(len, log_rows_per_chunk, redistribute);
        long[] espc = new long[nchunks + 1];
        espc[0] = 0L;
        for (int i2 = 1; i2 < nchunks; ++i2) {
            espc[i2] = redistribute ? espc[i2 - 1] + len / (long)nchunks : (long)i2 << log_rows_per_chunk;
        }
        espc[nchunks] = len;
        VectorGroup vg = VectorGroup.VG_LEN1;
        return Vec.makeCon(x2, vg, ESPC.rowLayout(vg._key, espc), type);
    }

    public Vec[] makeDoubles(int n2, double[] values) {
        Key<Vec>[] keys = this.group().addVecs(n2);
        Vec[] res = new Vec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            res[i2] = new Vec(keys[i2], this._rowLayout);
        }
        Vec.fillDoubleChunks(this, res, values);
        Futures fs = new Futures();
        for (Vec v2 : res) {
            DKV.put(v2, fs);
        }
        fs.blockForPending();
        return res;
    }

    private static void fillDoubleChunks(Vec v2, final Vec[] ds, final double[] values) {
        new MRTask(){

            @Override
            public void map(Chunk c2) {
                for (int i2 = 0; i2 < ds.length; ++i2) {
                    DKV.put(ds[i2].chunkKey(c2.cidx()), new C0DChunk(values[i2], c2._len << 3));
                }
            }
        }.doAll(v2);
    }

    public Vec makeZero() {
        return Vec.makeCon(0L, null, this.group(), this._rowLayout);
    }

    public Vec makeZero(String[] domain) {
        return Vec.makeCon(0L, domain, this.group(), this._rowLayout);
    }

    public Vec makeCopy() {
        return this.makeCopy(this.domain());
    }

    public Vec makeCopy(String[] domain) {
        byte type = this._type == 4 && domain == null ? (byte)3 : this._type;
        return this.makeCopy(domain, type);
    }

    public Vec makeCopy(String[] domain, byte type) {
        if (domain == null && type == 4) {
            throw new IllegalArgumentException("Desired Vec type is Categorical but not domain provided.");
        }
        Vec v2 = this.doCopy();
        v2._domain = domain;
        v2._type = type;
        DKV.put(v2);
        return v2;
    }

    public Vec doCopy() {
        final Vec v2 = new Vec(this.group().addVec(), this._rowLayout);
        new MRTask(){

            @Override
            public void map(Chunk c2) {
                Chunk c22 = c2.deepCopy();
                DKV.put(v2.chunkKey(c2.cidx()), c22, this._fs);
            }
        }.doAll(this);
        return v2;
    }

    public static Vec makeCon(long l2, String[] domain, VectorGroup group2, int rowLayout) {
        return Vec.makeCon(l2, domain, group2, rowLayout, domain == null ? (byte)3 : 4);
    }

    private static Vec makeCon(final long l2, String[] domain, VectorGroup group2, int rowLayout, byte type) {
        final Vec v0 = new Vec(group2.addVec(), rowLayout, domain, type);
        final int nchunks = v0.nChunks();
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i2 = 0; i2 < nchunks; ++i2) {
                    Key k2 = v0.chunkKey(i2);
                    if (!k2.home()) continue;
                    DKV.put(k2, new C0LChunk(l2, v0.chunkLen(i2)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public static Vec makeTimeVec(double[] vals, Key<Vec> vecKey) {
        if (vecKey == null) {
            vecKey = VectorGroup.VG_LEN1.addVec();
        }
        int layout = ESPC.rowLayout(vecKey, new long[]{0L, vals.length});
        Vec v2 = new Vec(vecKey, layout, null, 5);
        NewChunk nc = new NewChunk(v2, 0);
        Futures fs = new Futures();
        for (double d2 : vals) {
            nc.addNum(d2);
        }
        nc.close(fs);
        DKV.put(v2._key, v2, fs);
        fs.blockForPending();
        return v2;
    }

    public static Vec makeVec(double[] vals, Key<Vec> vecKey) {
        Vec v2 = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}));
        NewChunk nc = new NewChunk(v2, 0);
        Futures fs = new Futures();
        for (double d2 : vals) {
            nc.addNum(d2);
        }
        nc.close(fs);
        DKV.put(v2._key, v2, fs);
        fs.blockForPending();
        return v2;
    }

    public static Vec makeVec(float[] vals, Key<Vec> vecKey) {
        Vec v2 = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}));
        NewChunk nc = new NewChunk(v2, 0);
        Futures fs = new Futures();
        for (float d2 : vals) {
            nc.addNum(d2);
        }
        nc.close(fs);
        DKV.put(v2._key, v2, fs);
        fs.blockForPending();
        return v2;
    }

    public static Vec makeVec(String[] vals, Key<Vec> vecKey) {
        Vec v2 = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), null, 2);
        NewChunk nc = new NewChunk(v2, 0);
        Futures fs = new Futures();
        for (String s2 : vals) {
            nc.addStr(s2);
        }
        nc.close(fs);
        DKV.put(v2._key, v2, fs);
        fs.blockForPending();
        return v2;
    }

    public static Vec makeVec(float[] vals, String[] domain, Key<Vec> vecKey) {
        Vec v2 = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), domain);
        NewChunk nc = new NewChunk(v2, 0);
        Futures fs = new Futures();
        for (float d2 : vals) {
            assert (Float.isNaN(d2) || (float)((long)d2) == d2);
            nc.addNum(d2);
        }
        nc.close(fs);
        DKV.put(v2._key, v2, fs);
        fs.blockForPending();
        return v2;
    }

    public static Vec makeVec(double[] vals, String[] domain, Key<Vec> vecKey) {
        Vec v2 = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), domain);
        NewChunk nc = new NewChunk(v2, 0);
        Futures fs = new Futures();
        for (double d2 : vals) {
            assert (Double.isNaN(d2) || (double)((long)d2) == d2);
            nc.addNum(d2);
        }
        nc.close(fs);
        DKV.put(v2._key, v2, fs);
        fs.blockForPending();
        return v2;
    }

    public static Vec makeVec(long[] vals, String[] domain, Key<Vec> vecKey) {
        Vec v2 = new Vec(vecKey, ESPC.rowLayout(vecKey, new long[]{0L, vals.length}), domain);
        NewChunk nc = new NewChunk(v2, 0);
        Futures fs = new Futures();
        for (long d2 : vals) {
            nc.addNum(d2);
        }
        nc.close(fs);
        DKV.put(v2._key, v2, fs);
        fs.blockForPending();
        return v2;
    }

    public static Vec[] makeCons(double x2, long len, int n2) {
        Vec[] vecs = new Vec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            vecs[i2] = Vec.makeCon(x2, len, true);
        }
        return vecs;
    }

    public Vec makeCon(double d2) {
        return Vec.makeCon(d2, this.group(), this._rowLayout, (byte)3);
    }

    public Vec makeCon(double d2, byte type) {
        return Vec.makeCon(d2, this.group(), this._rowLayout, type);
    }

    public Vec makeCon(byte type) {
        return Vec.makeCon(0L, null, this.group(), this._rowLayout, type);
    }

    private static Vec makeCon(final double d2, VectorGroup group2, int rowLayout, byte type) {
        if ((double)((long)d2) == d2) {
            return Vec.makeCon((long)d2, null, group2, rowLayout, type);
        }
        final Vec v0 = new Vec(group2.addVec(), rowLayout, null, type);
        final int nchunks = v0.nChunks();
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i2 = 0; i2 < nchunks; ++i2) {
                    Key k2 = v0.chunkKey(i2);
                    if (!k2.home()) continue;
                    DKV.put(k2, new C0DChunk(d2, v0.chunkLen(i2)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public Vec makeCon(String s2) {
        return Vec.makeCon(s2, this.group(), this._rowLayout, (byte)2);
    }

    private static Vec makeCon(final String s2, VectorGroup group2, int rowLayout, byte type) {
        final Vec v0 = new Vec(group2.addVec(), rowLayout, null, type);
        final int nchunks = v0.nChunks();
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i2 = 0; i2 < nchunks; ++i2) {
                    Key k2 = v0.chunkKey(i2);
                    if (!k2.home()) continue;
                    DKV.put(k2, new CStrChunk(s2, v0.chunkLen(i2)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public Vec[] makeZeros(int n2) {
        return this.makeZeros(n2, null, null);
    }

    public Vec[] makeOnes(int n2) {
        return this.makeOnes(n2, null, null);
    }

    public Vec[] makeVolatileDoubles(int n2) {
        Vec[] vecs;
        for (Vec v2 : vecs = this.makeZeros(n2)) {
            v2._volatile = true;
            DKV.put(v2);
        }
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                int len = cs[0].len();
                for (int i2 = 0; i2 < cs.length; ++i2) {
                    cs[i2].setVolatile(MemoryManager.malloc8d(len));
                }
            }
        }.doAll(vecs);
        return vecs;
    }

    public Vec[] makeVolatileInts(final int[] cons) {
        Vec[] vecs;
        for (Vec v2 : vecs = this.makeZeros(cons.length)) {
            v2._volatile = true;
            DKV.put(v2);
        }
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                int len = cs[0].len();
                for (int i2 = 0; i2 < cs.length; ++i2) {
                    int[] vals = MemoryManager.malloc4(len);
                    Arrays.fill(vals, cons[i2]);
                    cs[i2].setVolatile(vals);
                }
            }
        }.doAll(vecs);
        return vecs;
    }

    public Vec[] makeZeros(int n2, String[][] domain, byte[] types) {
        return this.makeCons(n2, 0L, domain, types);
    }

    public Vec[] makeOnes(int n2, String[][] domain, byte[] types) {
        return this.makeCons(n2, 1L, domain, types);
    }

    public Vec[] makeCons(int n2, final long l2, String[][] domains, byte[] types) {
        final int nchunks = this.nChunks();
        Key<Vec>[] keys = this.group().addVecs(n2);
        final Vec[] vs = new Vec[keys.length];
        for (int i2 = 0; i2 < vs.length; ++i2) {
            vs[i2] = new Vec(keys[i2], this._rowLayout, domains == null ? null : domains[i2], types == null ? (byte)3 : types[i2]);
        }
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (Vec v1 : vs) {
                    for (int i2 = 0; i2 < nchunks; ++i2) {
                        Key k2 = v1.chunkKey(i2);
                        if (!k2.home()) continue;
                        DKV.put(k2, new C0LChunk(l2, Vec.this.chunkLen(i2)), this._fs);
                    }
                }
                for (Vec v2 : vs) {
                    if (!v2._key.home()) continue;
                    DKV.put(v2._key, v2, this._fs);
                }
            }
        }.doAllNodes();
        return vs;
    }

    public static Vec makeCon(Key<Vec> k2, double ... rows) {
        k2 = k2 == null ? VectorGroup.VG_LEN1.addVec() : k2;
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k2, 3);
        NewChunk chunk = new NewChunk(avec, 0);
        for (double r2 : rows) {
            chunk.addNum(r2);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public static Vec makeSeq(long len, boolean redistribute) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c2 : cs) {
                    for (int r2 = 0; r2 < c2._len; ++r2) {
                        c2.set(r2, (long)(r2 + 1) + c2._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len, (boolean)redistribute)}))._fr.vecs()[0];
    }

    public static Vec makeSeq(final long min2, long len) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c2 : cs) {
                    for (int r2 = 0; r2 < c2._len; ++r2) {
                        c2.set(r2, (long)r2 + min2 + c2._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len)}))._fr.vecs()[0];
    }

    public static Vec makeSeq(final long min2, long len, boolean redistribute) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c2 : cs) {
                    for (int r2 = 0; r2 < c2._len; ++r2) {
                        c2.set(r2, (long)r2 + min2 + c2._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len, (boolean)redistribute)}))._fr.vecs()[0];
    }

    public static Vec makeRepSeq(long len, final long repeat2) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c2 : cs) {
                    for (int r2 = 0; r2 < c2._len; ++r2) {
                        c2.set(r2, ((long)r2 + c2._start) % repeat2);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len)}))._fr.vecs()[0];
    }

    public Vec makeRand(final long seed) {
        Vec randVec = this.makeZero();
        new MRTask(){

            @Override
            public void map(Chunk c2) {
                RandomUtils.PCGRNG rng = new RandomUtils.PCGRNG(c2._start, 1L);
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    ((Random)rng).setSeed(seed + c2._start + (long)i2);
                    c2.set(i2, rng.nextFloat());
                }
            }
        }.doAll(randVec);
        return randVec;
    }

    public double min() {
        return this.mins()[0];
    }

    public double[] mins() {
        return this.rollupStats()._mins;
    }

    public double max() {
        return this.maxs()[0];
    }

    public double[] maxs() {
        return this.rollupStats()._maxs;
    }

    public final boolean isConst() {
        return this.min() == this.max();
    }

    public final boolean isConst(boolean includeNAs) {
        if (!this.isConst()) {
            return false;
        }
        return !includeNAs || this.naCnt() == 0L;
    }

    public final boolean isBad() {
        return this.naCnt() == this.length();
    }

    public double mean() {
        return this.rollupStats()._mean;
    }

    public double sigma() {
        return this.rollupStats()._sigma;
    }

    public int mode() {
        if (!this.isCategorical()) {
            throw H2O.unimpl();
        }
        long[] bins = this.bins();
        return ArrayUtils.maxIndex(bins);
    }

    public long naCnt() {
        return this.rollupStats()._naCnt;
    }

    public long nzCnt() {
        return this.rollupStats()._nzCnt;
    }

    public long pinfs() {
        return this.rollupStats()._pinfs;
    }

    public long ninfs() {
        return this.rollupStats()._ninfs;
    }

    public boolean isInt() {
        return this.rollupStats()._isInt;
    }

    public long byteSize() {
        return this.rollupStats()._size;
    }

    public long[] bins() {
        return RollupStats.get((Vec)this, (boolean)true)._bins;
    }

    public long[] lazy_bins() {
        return this.rollupStats()._bins;
    }

    public double base() {
        return RollupStats.get(this, true).h_base();
    }

    public double stride() {
        return RollupStats.get(this, true).h_stride();
    }

    public double[] pctiles() {
        return RollupStats.get((Vec)this, (boolean)true)._pctiles;
    }

    private RollupStats rollupStats() {
        return RollupStats.get(this);
    }

    public void startRollupStats(Futures fs) {
        this.startRollupStats(fs, false);
    }

    public void startRollupStats(Futures fs, boolean doHisto) {
        RollupStats.start(this, fs, doHisto);
    }

    @Override
    protected long checksum_impl() {
        return this.rollupStats()._checksum;
    }

    public boolean isVolatile() {
        return this._volatile;
    }

    public void preWriting() {
        if (!this.writable()) {
            throw new IllegalArgumentException("Vector not writable");
        }
        Vec.setMutating(this.rollupStatsKey());
    }

    private static void setMutating(Key rskey) {
        RollupStats rs;
        Value val = DKV.get(rskey);
        if (val != null && (rs = val.get(RollupStats.class)).isMutating()) {
            return;
        }
        new SetMutating().invoke(rskey);
    }

    public Futures postWrite(Futures fs) {
        if (this.writable()) {
            RollupStats rs;
            Key rskey = this.rollupStatsKey();
            Value val = DKV.get(this.rollupStatsKey());
            if (val != null && (rs = val.get(RollupStats.class)).isMutating()) {
                DKV.remove(rskey, fs);
            }
        }
        return fs;
    }

    public int elem2ChunkIdx(long i2) {
        if (0L > i2 || i2 >= this.length()) {
            throw new ArrayIndexOutOfBoundsException("0 <= " + i2 + " < " + this.length());
        }
        long[] espc = this.espc();
        int lo = 0;
        int hi = this.nChunks();
        while (lo < hi - 1) {
            int mid = hi + lo >>> 1;
            if (i2 < espc[mid]) {
                hi = mid;
                continue;
            }
            lo = mid;
        }
        while (espc[lo + 1] == i2) {
            ++lo;
        }
        return lo;
    }

    public static Key getVecKey(Key chk_key) {
        assert (chk_key._kb[0] == 5);
        byte[] bits = (byte[])chk_key._kb.clone();
        bits[0] = 4;
        UnsafeUtils.set4(bits, 6, -1);
        return Key.make(bits);
    }

    public Key chunkKey(int cidx) {
        return Vec.chunkKey(this._key, cidx);
    }

    public static Key chunkKey(Key veckey, int cidx) {
        byte[] bits = (byte[])veckey._kb.clone();
        bits[0] = 5;
        UnsafeUtils.set4(bits, 6, cidx);
        return Key.make(bits);
    }

    public Key rollupStatsKey() {
        if (this._rollupStatsKey == null) {
            this._rollupStatsKey = this.chunkKey(-2);
        }
        return this._rollupStatsKey;
    }

    Value chunkIdx(int cidx) {
        Value val = DKV.get(this.chunkKey(cidx));
        if (val == null) {
            boolean vecExists = DKV.get(this._key) != null;
            String vecInfo = (vecExists ? "is in DKV" : "is not in DKV") + "; home=" + this._key.home_node() + "; self=" + H2O.SELF;
            throw new IllegalStateException("Missing chunk " + cidx + " for vector " + this._key + "; Vec info: " + vecInfo);
        }
        return val;
    }

    Chunk nextChunk(Chunk prior) {
        int cidx = this.elem2ChunkIdx(prior._start) + 1;
        return cidx < this.nChunks() ? this.chunkForChunkIdx(cidx) : null;
    }

    public static Key<Vec> newKey() {
        return Vec.newKey(Key.make());
    }

    static Key<Vec> newKey(Key k2) {
        byte[] kb = k2._kb;
        byte[] bits = MemoryManager.malloc1(kb.length + 10);
        bits[0] = 4;
        bits[1] = -1;
        UnsafeUtils.set4(bits, 2, 0);
        UnsafeUtils.set4(bits, 6, -1);
        System.arraycopy(kb, 0, bits, 10, kb.length);
        return Key.make(bits);
    }

    private static Key espcKey(Key key) {
        byte[] bits = (byte[])key._kb.clone();
        bits[0] = 6;
        UnsafeUtils.set4(bits, 2, -1);
        UnsafeUtils.set4(bits, 6, -2);
        return Key.make(bits);
    }

    private Key groupKey() {
        byte[] bits = (byte[])this._key._kb.clone();
        bits[0] = 6;
        UnsafeUtils.set4(bits, 2, -1);
        UnsafeUtils.set4(bits, 6, -1);
        return Key.make(bits);
    }

    public final VectorGroup group() {
        Key gKey = this.groupKey();
        Value v2 = DKV.get(gKey);
        return v2 == null ? new VectorGroup(gKey, 1) : (VectorGroup)v2.get();
    }

    public Chunk chunkForChunkIdx(int cidx) {
        long start = this.chunk2StartElem(cidx);
        Value dvec = this.chunkIdx(cidx);
        Chunk c2 = (Chunk)dvec.get();
        long cstart = c2._start;
        Vec v2 = c2._vec;
        int tcidx = c2._cidx;
        if (cstart == start && v2 == this && tcidx == cidx) {
            return c2;
        }
        c2._vec = this;
        c2._start = start;
        c2._cidx = cidx;
        return c2;
    }

    public final Chunk chunkForRow(long i2) {
        return this.chunkForChunkIdx(this.elem2ChunkIdx(i2));
    }

    public final long at8(long i2) {
        return this.chunkForRow(i2).at8_abs(i2);
    }

    public final double at(long i2) {
        return this.chunkForRow(i2).at_abs(i2);
    }

    public final boolean isNA(long row) {
        return this.chunkForRow(row).isNA_abs(row);
    }

    public final long at16l(long i2) {
        return this.chunkForRow(i2).at16l_abs(i2);
    }

    public final long at16h(long i2) {
        return this.chunkForRow(i2).at16h_abs(i2);
    }

    public final BufferedString atStr(BufferedString bStr, long i2) {
        if (this.isCategorical()) {
            if (this.isNA(i2)) {
                return null;
            }
            return bStr.set(this._domain[(int)this.at8(i2)]);
        }
        return this.chunkForRow(i2).atStr_abs(bStr, i2);
    }

    public String stringAt(long i2) {
        return String.valueOf(this.atStr(new BufferedString(), i2));
    }

    public final void set(long i2, long l2) {
        Chunk ck = this.chunkForRow(i2);
        ck.set_abs(i2, l2);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i2, double d2) {
        Chunk ck = this.chunkForRow(i2);
        ck.set_abs(i2, d2);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i2, float f2) {
        Chunk ck = this.chunkForRow(i2);
        ck.set_abs(i2, f2);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void setNA(long i2) {
        Chunk ck = this.chunkForRow(i2);
        ck.setNA_abs(i2);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i2, String str) {
        Chunk ck = this.chunkForRow(i2);
        ck.set_abs(i2, str);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i2, UUID uuid) {
        Chunk ck = this.chunkForRow(i2);
        ck.set_abs(i2, uuid);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final Writer open() {
        return new Writer();
    }

    private Futures closeLocal(Futures fs) {
        int nc = this.nChunks();
        for (int i2 = 0; i2 < nc; ++i2) {
            if (!H2O.containsKey(this.chunkKey(i2))) continue;
            this.chunkForChunkIdx(i2).close(i2, fs);
        }
        return fs;
    }

    public String toString() {
        RollupStats rs = RollupStats.getOrNull(this, this.rollupStatsKey());
        String s2 = "[" + this.length() + (rs == null ? ", {" : "," + rs._mins[0] + "/" + rs._mean + "/" + rs._maxs[0] + ", " + PrettyPrint.bytes(rs._size) + ", {");
        int nc = this.nChunks();
        for (int i2 = 0; i2 < nc; ++i2) {
            s2 = s2 + this.chunkKey(i2).home_node() + ":" + this.chunk2StartElem(i2) + ":";
        }
        return s2 + "}]";
    }

    public TwoDimTable toTwoDimTable(int off, int len) {
        return new Frame(this).toTwoDimTable(off, len);
    }

    public TwoDimTable toTwoDimTable() {
        int len = (int)Math.min(Integer.MAX_VALUE, this.length());
        return new Frame(this).toTwoDimTable(0L, len);
    }

    public Vec toCategoricalVec() {
        return VecUtils.toCategoricalVec(this);
    }

    public Vec toStringVec() {
        return VecUtils.toStringVec(this);
    }

    public Vec toNumericVec() {
        return VecUtils.toNumericVec(this);
    }

    public boolean equals(Object o2) {
        return o2 instanceof Vec && ((Vec)o2)._key.equals(this._key);
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    @Override
    public Futures remove_impl(Futures fs, boolean cascade) {
        Vec.bulk_remove(new Key[]{this._key}, this.nChunks());
        return fs;
    }

    @Override
    protected Futures remove_self_key_impl(Futures fs) {
        return fs;
    }

    static void bulk_remove(final Key[] keys, final int ncs) {
        Futures fs = new Futures();
        for (Key key : keys) {
            fs.add(new SetMutating().fork(Vec.chunkKey(key, -2)));
        }
        fs.blockForPending();
        new MRTask(){

            @Override
            public void setupLocal() {
                for (Key k2 : keys) {
                    if (k2 == null) continue;
                    Vec.bulk_remove_vec(k2, ncs);
                }
            }
        }.doAllNodes();
        new MRTask(){

            @Override
            public void setupLocal() {
                for (Key k2 : keys) {
                    if (k2 == null) continue;
                    H2O.raw_remove(Vec.chunkKey(k2, -2));
                }
            }
        }.doAllNodes();
    }

    private static void bulk_remove_vec(Key vkey, int ncs) {
        for (int i2 = 0; i2 < ncs; ++i2) {
            Key kc = Vec.chunkKey(vkey, i2);
            H2O.raw_remove(kc);
        }
        H2O.raw_remove(vkey);
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        int ncs = this.nChunks();
        for (int i2 = 0; i2 < ncs; ++i2) {
            Key ck = this.chunkKey(i2);
            ab.put((Freezable)DKV.getGet(ck));
            if (ck.home()) continue;
            H2O.raw_remove(ck);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        int ncs = this.nChunks();
        for (int i2 = 0; i2 < ncs; ++i2) {
            DKV.put(this.chunkKey(i2), ab.get(Chunk.class), fs, true);
        }
        return super.readAll_impl(ab, fs);
    }

    public Vec align(Vec vec) {
        return new Frame(this).makeCompatible(new Frame(vec), true)[0];
    }

    public Vec adaptTo(String[] domain) {
        if (!this.isBad() && this.isNumeric() && !ArrayUtils.isInt(domain)) {
            int oldDomainLen = domain.length;
            int nan_cnt = 0;
            int j2 = 0;
            double[] double_domain = MemoryManager.malloc8d(domain.length);
            for (int i2 = 0; i2 < double_domain.length; ++i2) {
                try {
                    double_domain[j2] = Double.parseDouble(domain[i2]);
                    ++j2;
                    continue;
                }
                catch (NumberFormatException ex) {
                    ++nan_cnt;
                }
            }
            if (j2 == double_domain.length) {
                double[] new_double_domain;
                if (j2 < double_domain.length) {
                    double_domain = Arrays.copyOf(double_domain, j2);
                }
                if ((new_double_domain = ((VecUtils.CollectDoubleDomain)new VecUtils.CollectDoubleDomain(double_domain, 100000).doAll(this)).domain()).length > 0) {
                    int n2 = domain.length;
                    domain = Arrays.copyOf(domain, domain.length + new_double_domain.length);
                    for (int i3 = 0; i3 < new_double_domain.length; ++i3) {
                        domain[n2 + i3] = String.valueOf(new_double_domain[i3]);
                    }
                }
                Vec res = this.makeZero(domain);
                double_domain = MemoryManager.malloc8d(domain.length - nan_cnt);
                j2 = 0;
                int[] indeces = MemoryManager.malloc4(domain.length - nan_cnt);
                int[] order_indeces = ArrayUtils.seq(0, indeces.length);
                for (int i4 = 0; i4 < domain.length; ++i4) {
                    try {
                        double_domain[j2] = Double.parseDouble(domain[i4]);
                        indeces[j2] = i4;
                        ++j2;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!ArrayUtils.isSorted(double_domain)) {
                    ArrayUtils.sort(order_indeces, double_domain);
                }
                final double[] sorted_domain_vals = ArrayUtils.select(double_domain, order_indeces);
                final int[] sorted_indeces = ArrayUtils.select(indeces, order_indeces);
                new MRTask(){

                    @Override
                    public void map(Chunk c0, Chunk c1) {
                        for (int i2 = 0; i2 < c0._len; ++i2) {
                            double d2 = c0.atd(i2);
                            if (Double.isNaN(d2)) {
                                c1.setNA(i2);
                                continue;
                            }
                            c1.set(i2, sorted_indeces[Arrays.binarySearch(sorted_domain_vals, d2)]);
                        }
                    }
                }.doAll(this, res);
                return res;
            }
        }
        return new CategoricalWrappedVec((Key)this.group().addVec(), this._rowLayout, domain, this._key);
    }

    public static Key setChunkIdx(Key k2, int cidx) {
        UnsafeUtils.set4(k2._kb, 6, cidx);
        return k2;
    }

    public boolean isHomedLocally(int cidx) {
        return this.chunkKey(cidx).home();
    }

    public static class ESPC
    extends Keyed<ESPC> {
        private static NonBlockingHashMap<Key, ESPC> ESPCS = new NonBlockingHashMap();
        public final long[][] _espcs;

        private ESPC(Key key, long[][] espcs) {
            super(key);
            this._espcs = espcs;
        }

        private static ESPC getLocal(Key kespc) {
            ESPC local = ESPCS.get(kespc);
            if (local != null) {
                return local;
            }
            ESPCS.putIfAbsent(kespc, new ESPC(kespc, new long[0][]));
            return ESPCS.get(kespc);
        }

        private static ESPC getRemote(ESPC local, Key kespc) {
            ESPC remote = (ESPC)DKV.getGet(kespc);
            if (remote == null || remote == local) {
                return local;
            }
            long[][] local_espcs = local._espcs;
            long[][] remote_espcs = remote._espcs;
            while (true) {
                if (local_espcs.length >= remote_espcs.length) {
                    return local;
                }
                System.arraycopy(local._espcs, 0, remote._espcs, 0, local._espcs.length);
                ESPC res = ESPCS.putIfMatch(kespc, remote, local);
                if (res == local) {
                    return remote;
                }
                local = res;
                local_espcs = res._espcs;
                assert (remote_espcs == remote._espcs);
            }
        }

        public static long[] espc(Vec v2) {
            int r2 = v2._rowLayout;
            if (r2 == -1) {
                return null;
            }
            Key kespc = Vec.espcKey(v2._key);
            ESPC local = ESPC.getLocal(kespc);
            if (r2 < local._espcs.length) {
                return local._espcs[r2];
            }
            ESPC remote = ESPC.getRemote(local, kespc);
            if (r2 < remote._espcs.length) {
                return remote._espcs[r2];
            }
            throw H2O.fail("Vec " + v2._key + " asked for layout " + r2 + ", but only " + remote._espcs.length + " layouts defined");
        }

        private static int find_espc(long[] espc, long[][] espcs) {
            int i2;
            for (i2 = 0; i2 < espcs.length; ++i2) {
                if (espc != espcs[i2]) continue;
                return i2;
            }
            for (i2 = 0; i2 < espcs.length; ++i2) {
                if (espc.length != espcs[i2].length || !Arrays.equals(espc, espcs[i2])) continue;
                return i2;
            }
            return -1;
        }

        public static int rowLayout(Key key, final long[] espc) {
            Key kespc = Vec.espcKey(key);
            ESPC local = ESPC.getLocal(kespc);
            int idx = ESPC.find_espc(espc, local._espcs);
            if (idx != -1) {
                return idx;
            }
            if (!H2O.containsKey(kespc)) {
                local = ESPC.getRemote(local, kespc);
                idx = ESPC.find_espc(espc, local._espcs);
                if (idx != -1) {
                    return idx;
                }
            }
            new TAtomic<ESPC>(){

                @Override
                public ESPC atomic(ESPC old) {
                    if (old == null) {
                        return new ESPC(this._key, new long[][]{espc});
                    }
                    long[][] espcs = old._espcs;
                    int idx = ESPC.find_espc(espc, espcs);
                    if (idx != -1) {
                        return null;
                    }
                    int len = espcs.length;
                    espcs = (long[][])Arrays.copyOf(espcs, len + 1);
                    espcs[len] = espc;
                    return new ESPC(this._key, espcs);
                }
            }.invoke(kespc);
            ESPC reloaded = ESPC.getRemote(local, kespc);
            idx = ESPC.find_espc(espc, reloaded._espcs);
            assert (idx != -1);
            return idx;
        }

        public static void clear() {
            ESPCS.clear();
        }

        @Override
        protected long checksum_impl() {
            throw H2O.fail();
        }
    }

    public static class VectorGroup
    extends Keyed<VectorGroup> {
        public static final VectorGroup VG_LEN1 = new VectorGroup();
        final int _len;

        public VectorGroup() {
            super(VectorGroup.init_key());
            this._len = 0;
        }

        private static Key init_key() {
            byte[] bits = new byte[26];
            bits[0] = 6;
            bits[1] = -1;
            UnsafeUtils.set4(bits, 2, -1);
            UnsafeUtils.set4(bits, 6, -1);
            UUID uu = UUID.randomUUID();
            UnsafeUtils.set8(bits, 10, uu.getLeastSignificantBits());
            UnsafeUtils.set8(bits, 18, uu.getMostSignificantBits());
            return Key.make(bits);
        }

        private VectorGroup(Key key, int newlen) {
            super(key);
            this._len = newlen;
        }

        public Key<Vec> vecKey(int vecId) {
            byte[] bits = (byte[])this._key._kb.clone();
            bits[0] = 4;
            UnsafeUtils.set4(bits, 2, vecId);
            return Key.make(bits);
        }

        public int reserveKeys(int n2) {
            AddVecs2GroupTsk tsk = new AddVecs2GroupTsk(this._key, n2);
            tsk.invoke(this._key);
            return tsk._offset;
        }

        public Key<Vec>[] addVecs(int n2) {
            int nn = this.reserveKeys(n2);
            Key[] res = new Key[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                res[i2] = this.vecKey(i2 + nn);
            }
            return res;
        }

        public Key<Vec> addVec() {
            return this.addVecs(1)[0];
        }

        static boolean sameGroup(Vec v1, Vec v2) {
            byte[] bits1 = v1._key._kb;
            byte[] bits2 = v2._key._kb;
            if (bits1.length != bits2.length) {
                return false;
            }
            int res = 0;
            for (int i2 = 10; i2 < bits1.length; ++i2) {
                res |= bits1[i2] ^ bits2[i2];
            }
            return res == 0;
        }

        public String toString() {
            return "VecGrp " + this._key.toString() + ", next free=" + this._len;
        }

        public int len() {
            return this._len;
        }

        public boolean equals(Object o2) {
            return o2 instanceof VectorGroup && ((VectorGroup)o2)._key.equals(this._key);
        }

        public int hashCode() {
            return this._key.hashCode();
        }

        @Override
        protected long checksum_impl() {
            throw H2O.fail();
        }

        @Override
        protected Futures remove_impl(Futures fs, boolean cascade) {
            throw H2O.fail();
        }

        @Override
        protected AutoBuffer writeAll_impl(AutoBuffer ab) {
            throw H2O.fail();
        }

        @Override
        protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
            throw H2O.unimpl();
        }

        private static final class AddVecs2GroupTsk
        extends TAtomic<VectorGroup> {
            final Key _key;
            final int _n;
            int _offset;

            private AddVecs2GroupTsk(Key key, int n2) {
                this._key = key;
                this._n = n2;
            }

            @Override
            protected VectorGroup atomic(VectorGroup old) {
                this._offset = old == null ? 1 : old._len;
                return new VectorGroup(this._key, this._offset + this._n);
            }
        }
    }

    public final class Writer
    implements Closeable {
        private Chunk _cache;

        private Chunk chk(long i2) {
            Chunk c2 = this._cache;
            return c2 != null && c2.chk2() == null && c2._start <= i2 && i2 < c2._start + (long)c2._len ? c2 : (this._cache = Vec.this.chunkForRow(i2));
        }

        private Writer() {
            Vec.this.preWriting();
        }

        public final void set(long i2, long l2) {
            this.chk(i2).set_abs(i2, l2);
        }

        public final void set(long i2, double d2) {
            this.chk(i2).set_abs(i2, d2);
        }

        public final void set(long i2, float f2) {
            this.chk(i2).set_abs(i2, f2);
        }

        public final void setNA(long i2) {
            this.chk(i2).setNA_abs(i2);
        }

        public final void set(long i2, String str) {
            this.chk(i2).set_abs(i2, str);
        }

        public Futures close(Futures fs) {
            return Vec.this.postWrite(Vec.this.closeLocal(fs));
        }

        @Override
        public void close() {
            this.close(new Futures()).blockForPending();
        }
    }

    public final class Reader {
        private Chunk _cache;

        private Chunk chk(long i2) {
            Chunk c2 = this._cache;
            return c2 != null && c2.chk2() == null && c2._start <= i2 && i2 < c2._start + (long)c2._len ? c2 : (this._cache = Vec.this.chunkForRow(i2));
        }

        public final long at8(long i2) {
            return this.chk(i2).at8_abs(i2);
        }

        public final double at(long i2) {
            return this.chk(i2).at_abs(i2);
        }

        public final boolean isNA(long i2) {
            return this.chk(i2).isNA_abs(i2);
        }

        public final BufferedString atStr(BufferedString sb, long i2) {
            return this.chk(i2).atStr_abs(sb, i2);
        }

        public final long length() {
            return Vec.this.length();
        }
    }

    private static class SetMutating
    extends TAtomic<RollupStats> {
        private SetMutating() {
        }

        @Override
        protected RollupStats atomic(RollupStats rs) {
            return rs != null && rs.isMutating() ? null : RollupStats.makeMutating();
        }
    }

    public static interface Holder {
        public Vec vec();
    }
}

