/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.Key;
import water.Lockable;
import water.Value;
import water.fvec.C1NChunk;
import water.fvec.Chunk;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public class UploadFileVec
extends FileVec {
    int _nchunks;

    protected UploadFileVec(Key key) {
        super(key, -1L, (byte)1);
    }

    @Override
    public boolean writable() {
        return this._len == -1L;
    }

    public void addAndCloseChunk(Chunk c2, Futures fs) {
        assert (this._len == -1L);
        assert (c2._vec == null);
        c2._vec = this;
        DKV.put(this.chunkKey(this._nchunks++), c2, fs, true);
    }

    public void close(C1NChunk c2, int cidx, Futures fs) {
        assert (this._len == -1L);
        c2._vec = this;
        DKV.put(this.chunkKey(cidx), c2, fs);
        long l2 = (long)this._nchunks - 1L;
        this._len = l2 * (long)this._chunkSize + (long)c2._len;
    }

    private boolean checkMissing(int cidx, Value val) {
        if (val != null) {
            return true;
        }
        Log.err("Missing chunk " + cidx + " for " + this._key);
        return false;
    }

    @Override
    public Value chunkIdx(int cidx) {
        Value val = DKV.get(this.chunkKey(cidx));
        assert (this.checkMissing(cidx, val));
        return val;
    }

    public static Key readPut(String keyname, InputStream is, ReadPutStats stats) throws IOException {
        return UploadFileVec.readPut(Key.make(keyname), is, stats);
    }

    public static Key readPut(Key k2, InputStream is, ReadPutStats stats) throws IOException {
        return UploadFileVec.readPut_impl(k2, is, stats);
    }

    private static Key readPut_impl(Key key, InputStream is, ReadPutStats stats) throws IOException {
        Log.info("Reading byte InputStream into Frame:");
        Log.info("    frameKey:    " + key.toString());
        Key<Vec> newVecKey = Vec.newKey();
        UploadFileVec uv = null;
        try {
            int rv;
            new Frame(key, new String[0], new Vec[0]).delete_and_lock();
            uv = new UploadFileVec((Key)newVecKey);
            assert (uv.writable());
            Futures fs = new Futures();
            byte[] prev = null;
            byte[] bytebuf = new byte[0x400000];
            int bytesInChunkSoFar = 0;
            while ((rv = is.read(bytebuf, bytesInChunkSoFar, 0x400000 - bytesInChunkSoFar)) >= 0) {
                if ((bytesInChunkSoFar += rv) != 0x400000) continue;
                C1NChunk c2 = new C1NChunk(bytebuf);
                uv.addAndCloseChunk(c2, fs);
                prev = bytebuf;
                bytebuf = new byte[0x400000];
                bytesInChunkSoFar = 0;
            }
            if (bytesInChunkSoFar > 0) {
                byte[] buf2 = Arrays.copyOf(bytebuf, bytesInChunkSoFar);
                uv.close(new C1NChunk(buf2), uv._nchunks++, fs);
            }
            if (stats != null) {
                stats.total_chunks = uv.nChunks();
                stats.total_bytes = uv.length();
            }
            Log.info("    totalChunks: " + uv.nChunks());
            Log.info("    totalBytes:  " + uv.length());
            DKV.put(newVecKey, uv, fs);
            fs.blockForPending();
            Frame f2 = new Frame(key, new String[]{"bytes"}, new Vec[]{uv});
            f2.unlock();
            Log.info("    Success.");
        }
        catch (IOException e2) {
            Log.err("Exception caught in Frame::readPut; attempting to clean up the new frame and vector", e2);
            Lockable.delete(key);
            if (uv != null) {
                UploadFileVec.remove(newVecKey);
            }
            Log.err("Frame::readPut cleaned up new frame and vector successfully");
            throw e2;
        }
        return key;
    }

    @Override
    public int setChunkSize(Frame fr, int chunkSize) {
        return this._chunkSize;
    }

    public static class ReadPutStats {
        public long total_chunks;
        public long total_bytes;
    }
}

